/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ftp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ftp.FTPException;
import org.apache.hadoop.fs.ftp.FTPInputStream;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FTPFileSystem
extends FileSystem {
    public static final Log LOG = LogFactory.getLog(FTPFileSystem.class);
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    private URI uri;

    @Override
    public String getScheme() {
        return "ftp";
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        String host = uri.getHost();
        String string = host = host == null ? conf.get("fs.ftp.host", null) : host;
        if (host == null) {
            throw new IOException("Invalid host specified");
        }
        conf.set("fs.ftp.host", host);
        int port = uri.getPort();
        port = port == -1 ? 21 : port;
        conf.setInt("fs.ftp.host.port", port);
        String userAndPassword = uri.getUserInfo();
        if (userAndPassword == null && (userAndPassword = conf.get("fs.ftp.user." + host, null) + ":" + conf.get("fs.ftp.password." + host, null)) == null) {
            throw new IOException("Invalid user/passsword specified");
        }
        String[] userPasswdInfo = userAndPassword.split(":");
        conf.set("fs.ftp.user." + host, userPasswdInfo[0]);
        if (userPasswdInfo.length > 1) {
            conf.set("fs.ftp.password." + host, userPasswdInfo[1]);
        } else {
            conf.set("fs.ftp.password." + host, null);
        }
        this.setConf(conf);
        this.uri = uri;
    }

    private FTPClient connect() throws IOException {
        FTPClient client = null;
        Configuration conf = this.getConf();
        String host = conf.get("fs.ftp.host");
        int port = conf.getInt("fs.ftp.host.port", 21);
        String user = conf.get("fs.ftp.user." + host);
        String password = conf.get("fs.ftp.password." + host);
        client = new FTPClient();
        client.connect(host, port);
        int reply = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            throw new IOException("Server - " + host + " refused connection on port - " + port);
        }
        if (!client.login(user, password)) {
            throw new IOException("Login failed on server - " + host + ", port - " + port);
        }
        client.setFileTransferMode(11);
        client.setFileType(2);
        client.setBufferSize(0x100000);
        return client;
    }

    private void disconnect(FTPClient client) throws IOException {
        if (client != null) {
            if (!client.isConnected()) {
                throw new FTPException("Client not connected");
            }
            boolean logoutSuccess = client.logout();
            client.disconnect();
            if (!logoutSuccess) {
                LOG.warn((Object)("Logout failed while disconnecting, error code - " + client.getReplyCode()));
            }
        }
    }

    private Path makeAbsolute(Path workDir, Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(workDir, path);
    }

    @Override
    public FSDataInputStream open(Path file, int bufferSize) throws IOException {
        Path workDir;
        Path absolute;
        FTPClient client = this.connect();
        FileStatus fileStat = this.getFileStatus(client, absolute = this.makeAbsolute(workDir = new Path(client.printWorkingDirectory()), file));
        if (fileStat.isDirectory()) {
            this.disconnect(client);
            throw new IOException("Path " + file + " is a directory.");
        }
        client.allocate(bufferSize);
        Path parent = absolute.getParent();
        client.changeWorkingDirectory(parent.toUri().getPath());
        InputStream is = client.retrieveFileStream(file.getName());
        FSDataInputStream fis = new FSDataInputStream(new FTPInputStream(is, client, this.statistics));
        if (!FTPReply.isPositivePreliminary((int)client.getReplyCode())) {
            fis.close();
            throw new IOException("Unable to open file: " + file + ", Aborting");
        }
        return fis;
    }

    @Override
    public FSDataOutputStream create(Path file, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent;
        final FTPClient client = this.connect();
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        if (this.exists(client, file)) {
            if (overwrite) {
                this.delete(client, file);
            } else {
                this.disconnect(client);
                throw new IOException("File already exists: " + file);
            }
        }
        if ((parent = absolute.getParent()) == null || !this.mkdirs(client, parent, FsPermission.getDirDefault())) {
            parent = parent == null ? new Path("/") : parent;
            this.disconnect(client);
            throw new IOException("create(): Mkdirs failed to create: " + parent);
        }
        client.allocate(bufferSize);
        client.changeWorkingDirectory(parent.toUri().getPath());
        FSDataOutputStream fos = new FSDataOutputStream(client.storeFileStream(file.getName()), this.statistics){

            @Override
            public void close() throws IOException {
                super.close();
                if (!client.isConnected()) {
                    throw new FTPException("Client not connected");
                }
                boolean cmdCompleted = client.completePendingCommand();
                FTPFileSystem.this.disconnect(client);
                if (!cmdCompleted) {
                    throw new FTPException("Could not complete transfer, Reply Code - " + client.getReplyCode());
                }
            }
        };
        if (!FTPReply.isPositivePreliminary((int)client.getReplyCode())) {
            fos.close();
            throw new IOException("Unable to create file: " + file + ", Aborting");
        }
        return fos;
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    private boolean exists(FTPClient client, Path file) {
        try {
            return this.getFileStatus(client, file) != null;
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        catch (IOException ioe) {
            throw new FTPException("Failed to get file status", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Path file, boolean recursive) throws IOException {
        FTPClient client = this.connect();
        try {
            boolean success;
            boolean bl = success = this.delete(client, file, recursive);
            return bl;
        }
        finally {
            this.disconnect(client);
        }
    }

    @Deprecated
    private boolean delete(FTPClient client, Path file) throws IOException {
        return this.delete(client, file, false);
    }

    private boolean delete(FTPClient client, Path file, boolean recursive) throws IOException {
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        String pathName = absolute.toUri().getPath();
        FileStatus fileStat = this.getFileStatus(client, absolute);
        if (fileStat.isFile()) {
            return client.deleteFile(pathName);
        }
        FileStatus[] dirEntries = this.listStatus(client, absolute);
        if (dirEntries != null && dirEntries.length > 0 && !recursive) {
            throw new IOException("Directory: " + file + " is not empty.");
        }
        if (dirEntries != null) {
            for (int i = 0; i < dirEntries.length; ++i) {
                this.delete(client, new Path(absolute, dirEntries[i].getPath()), recursive);
            }
        }
        return client.removeDirectory(pathName);
    }

    private FsAction getFsAction(int accessGroup, FTPFile ftpFile) {
        FsAction action = FsAction.NONE;
        if (ftpFile.hasPermission(accessGroup, 0)) {
            action.or(FsAction.READ);
        }
        if (ftpFile.hasPermission(accessGroup, 1)) {
            action.or(FsAction.WRITE);
        }
        if (ftpFile.hasPermission(accessGroup, 2)) {
            action.or(FsAction.EXECUTE);
        }
        return action;
    }

    private FsPermission getPermissions(FTPFile ftpFile) {
        FsAction user = this.getFsAction(0, ftpFile);
        FsAction group = this.getFsAction(1, ftpFile);
        FsAction others = this.getFsAction(2, ftpFile);
        return new FsPermission(user, group, others);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileStatus[] listStatus(Path file) throws IOException {
        FTPClient client = this.connect();
        try {
            FileStatus[] stats;
            FileStatus[] fileStatusArray = stats = this.listStatus(client, file);
            return fileStatusArray;
        }
        finally {
            this.disconnect(client);
        }
    }

    private FileStatus[] listStatus(FTPClient client, Path file) throws IOException {
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        FileStatus fileStat = this.getFileStatus(client, absolute);
        if (fileStat.isFile()) {
            return new FileStatus[]{fileStat};
        }
        FTPFile[] ftpFiles = client.listFiles(absolute.toUri().getPath());
        FileStatus[] fileStats = new FileStatus[ftpFiles.length];
        for (int i = 0; i < ftpFiles.length; ++i) {
            fileStats[i] = this.getFileStatus(ftpFiles[i], absolute);
        }
        return fileStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileStatus getFileStatus(Path file) throws IOException {
        FTPClient client = this.connect();
        try {
            FileStatus status;
            FileStatus fileStatus = status = this.getFileStatus(client, file);
            return fileStatus;
        }
        finally {
            this.disconnect(client);
        }
    }

    private FileStatus getFileStatus(FTPClient client, Path file) throws IOException {
        FileStatus fileStat = null;
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        Path parentPath = absolute.getParent();
        if (parentPath == null) {
            long length = -1L;
            boolean isDir = true;
            int blockReplication = 1;
            long blockSize = 4096L;
            long modTime = -1L;
            Path root = new Path("/");
            return new FileStatus(length, isDir, blockReplication, blockSize, modTime, root.makeQualified(this));
        }
        String pathName = parentPath.toUri().getPath();
        FTPFile[] ftpFiles = client.listFiles(pathName);
        if (ftpFiles != null) {
            for (FTPFile ftpFile : ftpFiles) {
                if (!ftpFile.getName().equals(file.getName())) continue;
                fileStat = this.getFileStatus(ftpFile, parentPath);
                break;
            }
            if (fileStat == null) {
                throw new FileNotFoundException("File " + file + " does not exist.");
            }
        } else {
            throw new FileNotFoundException("File " + file + " does not exist.");
        }
        return fileStat;
    }

    private FileStatus getFileStatus(FTPFile ftpFile, Path parentPath) {
        long length = ftpFile.getSize();
        boolean isDir = ftpFile.isDirectory();
        int blockReplication = 1;
        long blockSize = 4096L;
        long modTime = ftpFile.getTimestamp().getTimeInMillis();
        long accessTime = 0L;
        FsPermission permission = this.getPermissions(ftpFile);
        String user = ftpFile.getUser();
        String group = ftpFile.getGroup();
        Path filePath = new Path(parentPath, ftpFile.getName());
        return new FileStatus(length, isDir, blockReplication, blockSize, modTime, accessTime, permission, user, group, filePath.makeQualified(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mkdirs(Path file, FsPermission permission) throws IOException {
        FTPClient client = this.connect();
        try {
            boolean success;
            boolean bl = success = this.mkdirs(client, file, permission);
            return bl;
        }
        finally {
            this.disconnect(client);
        }
    }

    private boolean mkdirs(FTPClient client, Path file, FsPermission permission) throws IOException {
        boolean created = true;
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        String pathName = absolute.getName();
        if (!this.exists(client, absolute)) {
            Path parent = absolute.getParent();
            boolean bl = created = parent == null || this.mkdirs(client, parent, FsPermission.getDirDefault());
            if (created) {
                String parentDir = parent.toUri().getPath();
                client.changeWorkingDirectory(parentDir);
                created &= client.makeDirectory(pathName);
            }
        } else if (this.isFile(client, absolute)) {
            throw new IOException(String.format("Can't make directory for path %s since it is a file.", absolute));
        }
        return created;
    }

    private boolean isFile(FTPClient client, Path file) {
        try {
            return this.getFileStatus(client, file).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException ioe) {
            throw new FTPException("File check failed", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        FTPClient client = this.connect();
        try {
            boolean success;
            boolean bl = success = this.rename(client, src, dst);
            return bl;
        }
        finally {
            this.disconnect(client);
        }
    }

    private boolean rename(FTPClient client, Path src, Path dst) throws IOException {
        Path workDir = new Path(client.printWorkingDirectory());
        Path absoluteSrc = this.makeAbsolute(workDir, src);
        Path absoluteDst = this.makeAbsolute(workDir, dst);
        if (!this.exists(client, absoluteSrc)) {
            throw new IOException("Source path " + src + " does not exist");
        }
        if (this.exists(client, absoluteDst)) {
            throw new IOException("Destination path " + dst + " already exist, cannot rename!");
        }
        String parentSrc = absoluteSrc.getParent().toUri().toString();
        String parentDst = absoluteDst.getParent().toUri().toString();
        String from = src.getName();
        String to = dst.getName();
        if (!parentSrc.equals(parentDst)) {
            throw new IOException("Cannot rename parent(source): " + parentSrc + ", parent(destination):  " + parentDst);
        }
        client.changeWorkingDirectory(parentSrc);
        boolean renamed = client.rename(from, to);
        return renamed;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.getHomeDirectory();
    }

    @Override
    public Path getHomeDirectory() {
        FTPClient client = null;
        try {
            Path homeDir;
            client = this.connect();
            Path path = homeDir = new Path(client.printWorkingDirectory());
            return path;
        }
        catch (IOException ioe) {
            throw new FTPException("Failed to get home directory", ioe);
        }
        finally {
            try {
                this.disconnect(client);
            }
            catch (IOException ioe) {
                throw new FTPException("Failed to disconnect", ioe);
            }
        }
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
    }
}

