/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TAppend
implements TBase<TAppend, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("TAppend");
    private static final TField TABLE_FIELD_DESC = new TField("table", 11, 1);
    private static final TField ROW_FIELD_DESC = new TField("row", 11, 2);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 3);
    private static final TField VALUES_FIELD_DESC = new TField("values", 15, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer table;
    public ByteBuffer row;
    public List<ByteBuffer> columns;
    public List<ByteBuffer> values;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TAppend() {
    }

    public TAppend(ByteBuffer table, ByteBuffer row, List<ByteBuffer> columns, List<ByteBuffer> values) {
        this();
        this.table = table;
        this.row = row;
        this.columns = columns;
        this.values = values;
    }

    public TAppend(TAppend other) {
        if (other.isSetTable()) {
            this.table = other.table;
        }
        if (other.isSetRow()) {
            this.row = other.row;
        }
        if (other.isSetColumns()) {
            ArrayList<ByteBuffer> __this__columns = new ArrayList<ByteBuffer>();
            for (ByteBuffer other_element : other.columns) {
                __this__columns.add(other_element);
            }
            this.columns = __this__columns;
        }
        if (other.isSetValues()) {
            ArrayList<ByteBuffer> __this__values = new ArrayList<ByteBuffer>();
            for (ByteBuffer other_element : other.values) {
                __this__values.add(other_element);
            }
            this.values = __this__values;
        }
    }

    public TAppend deepCopy() {
        return new TAppend(this);
    }

    public void clear() {
        this.table = null;
        this.row = null;
        this.columns = null;
        this.values = null;
    }

    public byte[] getTable() {
        this.setTable(TBaseHelper.rightSize((ByteBuffer)this.table));
        return this.table == null ? null : this.table.array();
    }

    public ByteBuffer bufferForTable() {
        return this.table;
    }

    public TAppend setTable(byte[] table) {
        this.setTable(table == null ? (ByteBuffer)null : ByteBuffer.wrap(table));
        return this;
    }

    public TAppend setTable(ByteBuffer table) {
        this.table = table;
        return this;
    }

    public void unsetTable() {
        this.table = null;
    }

    public boolean isSetTable() {
        return this.table != null;
    }

    public void setTableIsSet(boolean value) {
        if (!value) {
            this.table = null;
        }
    }

    public byte[] getRow() {
        this.setRow(TBaseHelper.rightSize((ByteBuffer)this.row));
        return this.row == null ? null : this.row.array();
    }

    public ByteBuffer bufferForRow() {
        return this.row;
    }

    public TAppend setRow(byte[] row) {
        this.setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
        return this;
    }

    public TAppend setRow(ByteBuffer row) {
        this.row = row;
        return this;
    }

    public void unsetRow() {
        this.row = null;
    }

    public boolean isSetRow() {
        return this.row != null;
    }

    public void setRowIsSet(boolean value) {
        if (!value) {
            this.row = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public Iterator<ByteBuffer> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(ByteBuffer elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<ByteBuffer>();
        }
        this.columns.add(elem);
    }

    public List<ByteBuffer> getColumns() {
        return this.columns;
    }

    public TAppend setColumns(List<ByteBuffer> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public int getValuesSize() {
        return this.values == null ? 0 : this.values.size();
    }

    public Iterator<ByteBuffer> getValuesIterator() {
        return this.values == null ? null : this.values.iterator();
    }

    public void addToValues(ByteBuffer elem) {
        if (this.values == null) {
            this.values = new ArrayList<ByteBuffer>();
        }
        this.values.add(elem);
    }

    public List<ByteBuffer> getValues() {
        return this.values;
    }

    public TAppend setValues(List<ByteBuffer> values) {
        this.values = values;
        return this;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public void setValuesIsSet(boolean value) {
        if (!value) {
            this.values = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TABLE: {
                if (value == null) {
                    this.unsetTable();
                    break;
                }
                this.setTable((ByteBuffer)value);
                break;
            }
            case ROW: {
                if (value == null) {
                    this.unsetRow();
                    break;
                }
                this.setRow((ByteBuffer)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            case VALUES: {
                if (value == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLE: {
                return this.getTable();
            }
            case ROW: {
                return this.getRow();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case VALUES: {
                return this.getValues();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLE: {
                return this.isSetTable();
            }
            case ROW: {
                return this.isSetRow();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case VALUES: {
                return this.isSetValues();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TAppend) {
            return this.equals((TAppend)that);
        }
        return false;
    }

    public boolean equals(TAppend that) {
        if (that == null) {
            return false;
        }
        boolean this_present_table = this.isSetTable();
        boolean that_present_table = that.isSetTable();
        if (this_present_table || that_present_table) {
            if (!this_present_table || !that_present_table) {
                return false;
            }
            if (!this.table.equals(that.table)) {
                return false;
            }
        }
        boolean this_present_row = this.isSetRow();
        boolean that_present_row = that.isSetRow();
        if (this_present_row || that_present_row) {
            if (!this_present_row || !that_present_row) {
                return false;
            }
            if (!this.row.equals(that.row)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!this.columns.equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_values = this.isSetValues();
        boolean that_present_values = that.isSetValues();
        if (this_present_values || that_present_values) {
            if (!this_present_values || !that_present_values) {
                return false;
            }
            if (!this.values.equals(that.values)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(TAppend other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        TAppend typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetTable()).compareTo(typedOther.isSetTable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTable() && (lastComparison = TBaseHelper.compareTo((Comparable)this.table, (Comparable)typedOther.table)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRow()).compareTo(typedOther.isSetRow());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow() && (lastComparison = TBaseHelper.compareTo((Comparable)this.row, (Comparable)typedOther.row)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(typedOther.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, typedOther.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValues()).compareTo(typedOther.isSetValues());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValues() && (lastComparison = TBaseHelper.compareTo(this.values, typedOther.values)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TAppend(");
        boolean first = true;
        sb.append("table:");
        if (this.table == null) {
            sb.append("null");
        } else {
            sb.append(this.table);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("row:");
        if (this.row == null) {
            sb.append("null");
        } else {
            sb.append(this.row);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("values:");
        if (this.values == null) {
            sb.append("null");
        } else {
            sb.append(this.values);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TAppendStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TAppendTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLE, new FieldMetaData("table", 3, new FieldValueMetaData(11, "Text")));
        tmpMap.put(_Fields.ROW, new FieldMetaData("row", 3, new FieldValueMetaData(11, "Text")));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11, "Text"))));
        tmpMap.put(_Fields.VALUES, new FieldMetaData("values", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11, "Text"))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TAppend.class, metaDataMap);
    }

    private static class TAppendTupleScheme
    extends TupleScheme<TAppend> {
        private TAppendTupleScheme() {
        }

        public void write(TProtocol prot, TAppend struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetTable()) {
                optionals.set(0);
            }
            if (struct.isSetRow()) {
                optionals.set(1);
            }
            if (struct.isSetColumns()) {
                optionals.set(2);
            }
            if (struct.isSetValues()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetTable()) {
                oprot.writeBinary(struct.table);
            }
            if (struct.isSetRow()) {
                oprot.writeBinary(struct.row);
            }
            if (struct.isSetColumns()) {
                oprot.writeI32(struct.columns.size());
                for (ByteBuffer _iter42 : struct.columns) {
                    oprot.writeBinary(_iter42);
                }
            }
            if (struct.isSetValues()) {
                oprot.writeI32(struct.values.size());
                for (ByteBuffer _iter43 : struct.values) {
                    oprot.writeBinary(_iter43);
                }
            }
        }

        public void read(TProtocol prot, TAppend struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
            }
            if (incoming.get(1)) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list44 = new TList(11, iprot.readI32());
                struct.columns = new ArrayList<ByteBuffer>(_list44.size);
                for (int _i45 = 0; _i45 < _list44.size; ++_i45) {
                    ByteBuffer _elem46 = iprot.readBinary();
                    struct.columns.add(_elem46);
                }
                struct.setColumnsIsSet(true);
            }
            if (incoming.get(3)) {
                TList _list47 = new TList(11, iprot.readI32());
                struct.values = new ArrayList<ByteBuffer>(_list47.size);
                for (int _i48 = 0; _i48 < _list47.size; ++_i48) {
                    ByteBuffer _elem49 = iprot.readBinary();
                    struct.values.add(_elem49);
                }
                struct.setValuesIsSet(true);
            }
        }
    }

    private static class TAppendTupleSchemeFactory
    implements SchemeFactory {
        private TAppendTupleSchemeFactory() {
        }

        public TAppendTupleScheme getScheme() {
            return new TAppendTupleScheme();
        }
    }

    private static class TAppendStandardScheme
    extends StandardScheme<TAppend> {
        private TAppendStandardScheme() {
        }

        public void read(TProtocol iprot, TAppend struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.table = iprot.readBinary();
                            struct.setTableIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.row = iprot.readBinary();
                            struct.setRowIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list34 = iprot.readListBegin();
                            struct.columns = new ArrayList<ByteBuffer>(_list34.size);
                            for (int _i35 = 0; _i35 < _list34.size; ++_i35) {
                                ByteBuffer _elem36 = iprot.readBinary();
                                struct.columns.add(_elem36);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list37 = iprot.readListBegin();
                            struct.values = new ArrayList<ByteBuffer>(_list37.size);
                            for (int _i38 = 0; _i38 < _list37.size; ++_i38) {
                                ByteBuffer _elem39 = iprot.readBinary();
                                struct.values.add(_elem39);
                            }
                            iprot.readListEnd();
                            struct.setValuesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TAppend struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.table != null) {
                oprot.writeFieldBegin(TABLE_FIELD_DESC);
                oprot.writeBinary(struct.table);
                oprot.writeFieldEnd();
            }
            if (struct.row != null) {
                oprot.writeFieldBegin(ROW_FIELD_DESC);
                oprot.writeBinary(struct.row);
                oprot.writeFieldEnd();
            }
            if (struct.columns != null) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.columns.size()));
                for (ByteBuffer _iter40 : struct.columns) {
                    oprot.writeBinary(_iter40);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.values != null) {
                oprot.writeFieldBegin(VALUES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.values.size()));
                for (ByteBuffer _iter41 : struct.values) {
                    oprot.writeBinary(_iter41);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TAppendStandardSchemeFactory
    implements SchemeFactory {
        private TAppendStandardSchemeFactory() {
        }

        public TAppendStandardScheme getScheme() {
            return new TAppendStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLE(1, "table"),
        ROW(2, "row"),
        COLUMNS(3, "columns"),
        VALUES(4, "values");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLE;
                }
                case 2: {
                    return ROW;
                }
                case 3: {
                    return COLUMNS;
                }
                case 4: {
                    return VALUES;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

