/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.LsrPBImage;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class OfflineImageViewerPB {
    public static final Log LOG = LogFactory.getLog(OfflineImageViewerPB.class);
    private static final String usage = "Usage: bin/hdfs oiv [OPTIONS] -i INPUTFILE -o OUTPUTFILE\nOffline Image Viewer\nView a Hadoop fsimage INPUTFILE using the specified PROCESSOR,\nsaving the results in OUTPUTFILE.\n\nThe oiv utility will attempt to parse correctly formed image files\nand will abort fail with mal-formed image files.\n\nThe tool works offline and does not require a running cluster in\norder to process an image file.\n\nThe following image processors are available:\n  * Ls: The default image processor generates an lsr-style listing\n    of the files in the namespace, with the same fields in the same\n    order.  Note that in order to correctly determine file sizes,\n    this formatter cannot skip blocks and will override the\n    -skipBlocks option.\n  * XML: This processor creates an XML document with all elements of\n    the fsimage enumerated, suitable for further analysis by XML\n    tools.\n  * FileDistribution: This processor analyzes the file size\n    distribution in the image.\n    -maxSize specifies the range [0, maxSize] of file sizes to be\n     analyzed (128GB by default).\n    -step defines the granularity of the distribution. (2MB by default)\n\nRequired command line arguments:\n-i,--inputFile <arg>   FSImage file to process.\n-o,--outputFile <arg>  Name of output file. If the specified\n                       file exists, it will be overwritten.\n\nOptional command line arguments:\n-p,--processor <arg>   Select which type of processor to apply\n                       against image file. (Ls|XML|FileDistribution).\n-h,--help              Display usage information and exit\n";

    private static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"outputFile");
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"inputFile");
        options.addOption(OptionBuilder.create((String)"i"));
        options.addOption("p", "processor", true, "");
        options.addOption("h", "help", false, "");
        options.addOption("skipBlocks", false, "");
        options.addOption("printToScreen", false, "");
        options.addOption("delimiter", true, "");
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws IOException {
        PrintWriter out;
        block12: {
            CommandLine cmd;
            Options options = OfflineImageViewerPB.buildOptions();
            if (args.length == 0) {
                OfflineImageViewerPB.printUsage();
                return;
            }
            PosixParser parser = new PosixParser();
            try {
                cmd = parser.parse(options, args);
            }
            catch (ParseException e) {
                System.out.println("Error parsing command-line options: ");
                OfflineImageViewerPB.printUsage();
                return;
            }
            if (cmd.hasOption("h")) {
                OfflineImageViewerPB.printUsage();
                return;
            }
            String inputFile = cmd.getOptionValue("i");
            String processor = cmd.getOptionValue("p", "Ls");
            String outputFile = cmd.getOptionValue("o");
            out = outputFile == null || outputFile.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new File(outputFile));
            Configuration conf = new Configuration();
            try {
                if (processor.equals("FileDistribution")) {
                    long maxSize = Long.parseLong(cmd.getOptionValue("maxSize", "0"));
                    int step = Integer.parseInt(cmd.getOptionValue("step", "0"));
                    new FileDistributionCalculator(conf, maxSize, step, out).visit(new RandomAccessFile(inputFile, "r"));
                    break block12;
                }
                if (processor.equals("XML")) {
                    new PBImageXmlWriter(conf, out).visit(new RandomAccessFile(inputFile, "r"));
                    break block12;
                }
                new LsrPBImage(conf, out).visit(new RandomAccessFile(inputFile, "r"));
            }
            catch (EOFException e) {
                System.err.println("Input file ended unexpectedly. Exiting");
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            }
            catch (IOException e2) {
                System.err.println("Encountered exception.  Exiting: " + e2.getMessage());
                {
                    catch (Throwable throwable) {
                        IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
                        throw throwable;
                    }
                }
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            }
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
    }

    private static void printUsage() {
        System.out.println(usage);
    }
}

