/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;

@InterfaceAudience.Private
public class NameNodeLayoutVersion {
    public static final Map<Integer, SortedSet<LayoutVersion.LayoutFeature>> FEATURES = new HashMap<Integer, SortedSet<LayoutVersion.LayoutFeature>>();
    public static final int CURRENT_LAYOUT_VERSION = LayoutVersion.getCurrentLayoutVersion(Feature.values());

    public static SortedSet<LayoutVersion.LayoutFeature> getFeatures(int lv) {
        return FEATURES.get(lv);
    }

    public static boolean supports(LayoutVersion.LayoutFeature f, int lv) {
        return LayoutVersion.supports(FEATURES, f, lv);
    }

    static {
        LayoutVersion.updateMap(FEATURES, LayoutVersion.Feature.values());
        LayoutVersion.updateMap(FEATURES, Feature.values());
    }

    public static enum Feature implements LayoutVersion.LayoutFeature
    {
        ROLLING_UPGRADE(-55, -53, "Support rolling upgrade", false, new Feature[0]);

        private final LayoutVersion.FeatureInfo info;

        private Feature(int lv, String description) {
            this(lv, lv + 1, description, false, new Feature[0]);
        }

        private Feature(int lv, int ancestorLV, String description, boolean reserved, Feature ... features) {
            this.info = new LayoutVersion.FeatureInfo(lv, ancestorLV, description, reserved, features);
        }

        @Override
        public LayoutVersion.FeatureInfo getInfo() {
            return this.info;
        }
    }
}

