/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;

public class SequenceFileLogWriter
implements HLog.Writer {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private SequenceFile.Writer writer;
    private OutputStream dfsClient_out;
    private Method syncFs;
    private Class<? extends HLogKey> keyClass;

    public SequenceFileLogWriter() {
    }

    public SequenceFileLogWriter(Class<? extends HLogKey> keyClass) {
        this.keyClass = keyClass;
    }

    @Override
    public void init(FileSystem fs, Path path, Configuration conf) throws IOException {
        if (null == this.keyClass) {
            this.keyClass = HLog.getKeyClass(conf);
        }
        this.writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, this.keyClass, WALEdit.class, (int)fs.getConf().getInt("io.file.buffer.size", 4096), (short)((short)conf.getInt("hbase.regionserver.hlog.replication", (int)fs.getDefaultReplication())), (long)conf.getLong("hbase.regionserver.hlog.blocksize", fs.getDefaultBlockSize()), (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, (CompressionCodec)new DefaultCodec(), null, (SequenceFile.Metadata)new SequenceFile.Metadata());
        Field[] fields = this.writer.getClass().getDeclaredFields();
        String fieldName = "out";
        for (int i = 0; i < fields.length; ++i) {
            if (!"out".equals(fields[i].getName())) continue;
            try {
                fields[i].setAccessible(true);
                FSDataOutputStream out = (FSDataOutputStream)fields[i].get(this.writer);
                this.dfsClient_out = out.getWrappedStream();
                break;
            }
            catch (IllegalAccessException ex) {
                throw new IOException("Accessing out", ex);
            }
        }
        Method m = null;
        boolean append = conf.getBoolean("dfs.support.append", false);
        if (append) {
            try {
                m = this.writer.getClass().getMethod("syncFs", new Class[0]);
            }
            catch (SecurityException e) {
                throw new IOException("Failed test for syncfs", e);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        this.syncFs = m;
        this.LOG.info((Object)(this.syncFs != null ? "Using syncFs -- HDFS-200" : "syncFs -- HDFS-200 -- not available, dfs.support.append=" + append));
    }

    @Override
    public void append(HLog.Entry entry) throws IOException {
        this.writer.append((Writable)entry.getKey(), (Writable)entry.getEdit());
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void sync() throws IOException {
        if (this.syncFs != null) {
            try {
                this.syncFs.invoke((Object)this.writer, HLog.NO_ARGS);
            }
            catch (Exception e) {
                throw new IOException("Reflection", e);
            }
        }
    }

    @Override
    public long getLength() throws IOException {
        return this.writer.getLength();
    }

    public OutputStream getDFSCOutputStream() {
        return this.dfsClient_out;
    }
}

