/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.OrphanHLogAfterSplitException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.MultipleIOException;

public class HLogSplitter {
    private static final String LOG_SPLITTER_IMPL = "hbase.hlog.splitter.impl";
    public static final String RECOVERED_EDITS = "recovered.edits";
    static final Log LOG = LogFactory.getLog(HLogSplitter.class);
    private boolean hasSplit = false;
    private long splitTime = 0L;
    private long splitSize = 0L;
    protected final Path rootDir;
    protected final Path srcDir;
    protected final Path oldLogDir;
    protected final FileSystem fs;
    protected final Configuration conf;
    OutputSink outputSink;
    EntryBuffers entryBuffers;
    protected AtomicReference<Throwable> thrown = new AtomicReference();
    Object dataAvailable = new Object();

    public static HLogSplitter createLogSplitter(Configuration conf, Path rootDir, Path srcDir, Path oldLogDir, FileSystem fs) {
        Class splitterClass = conf.getClass(LOG_SPLITTER_IMPL, HLogSplitter.class);
        try {
            Constructor constructor = splitterClass.getConstructor(Configuration.class, Path.class, Path.class, Path.class, FileSystem.class);
            return (HLogSplitter)constructor.newInstance(conf, rootDir, srcDir, oldLogDir, fs);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public HLogSplitter(Configuration conf, Path rootDir, Path srcDir, Path oldLogDir, FileSystem fs) {
        this.conf = conf;
        this.rootDir = rootDir;
        this.srcDir = srcDir;
        this.oldLogDir = oldLogDir;
        this.fs = fs;
        this.entryBuffers = new EntryBuffers(conf.getInt("hbase.regionserver.hlog.splitlog.buffersize", 0x8000000));
        this.outputSink = new OutputSink();
    }

    public List<Path> splitLog() throws IOException {
        Preconditions.checkState((!this.hasSplit ? 1 : 0) != 0, (Object)"An HLogSplitter instance may only be used once");
        this.hasSplit = true;
        long startTime = System.currentTimeMillis();
        List<Path> splits = null;
        if (!this.fs.exists(this.srcDir)) {
            return splits;
        }
        FileStatus[] logfiles = this.fs.listStatus(this.srcDir);
        if (logfiles == null || logfiles.length == 0) {
            return splits;
        }
        LOG.info((Object)("Splitting " + logfiles.length + " hlog(s) in " + this.srcDir.toString()));
        splits = this.splitLog(logfiles);
        this.splitTime = System.currentTimeMillis() - startTime;
        LOG.info((Object)("hlog file splitting completed in " + this.splitTime + " ms for " + this.srcDir.toString()));
        return splits;
    }

    public long getTime() {
        return this.splitTime;
    }

    public long getSize() {
        return this.splitSize;
    }

    Map<byte[], Long> getOutputCounts() {
        Preconditions.checkState((boolean)this.hasSplit);
        return this.outputSink.getOutputCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Path> splitLog(FileStatus[] logfiles) throws IOException {
        ArrayList<Path> processedLogs = new ArrayList<Path>();
        ArrayList<Path> corruptedLogs = new ArrayList<Path>();
        List<Path> splits = null;
        boolean skipErrors = this.conf.getBoolean("hbase.hlog.split.skip.errors", true);
        this.splitSize = 0L;
        this.outputSink.startWriterThreads(this.entryBuffers);
        try {
            int i = 0;
            for (FileStatus log : logfiles) {
                Path logPath = log.getPath();
                long logLength = log.getLen();
                this.splitSize += logLength;
                LOG.debug((Object)("Splitting hlog " + (i++ + 1) + " of " + logfiles.length + ": " + logPath + ", length=" + logLength));
                try {
                    FSUtils.recoverFileLease(this.fs, logPath, this.conf);
                    this.parseHLog(log, this.entryBuffers, this.fs, this.conf);
                    processedLogs.add(logPath);
                }
                catch (EOFException eof) {
                    LOG.info((Object)("EOF from hlog " + logPath + ". Continuing"));
                    processedLogs.add(logPath);
                }
                catch (FileNotFoundException fnfe) {
                    LOG.info((Object)("A log was missing " + logPath + ", probably because it was moved by the" + " now dead region server. Continuing"));
                    processedLogs.add(logPath);
                }
                catch (IOException e) {
                    if (e.getCause() instanceof ParseException) {
                        LOG.warn((Object)("Parse exception from hlog " + logPath + ".  continuing"), (Throwable)e);
                        processedLogs.add(logPath);
                        continue;
                    }
                    if (skipErrors) {
                        LOG.info((Object)("Got while parsing hlog " + logPath + ". Marking as corrupted"), (Throwable)e);
                        corruptedLogs.add(logPath);
                        continue;
                    }
                    throw e;
                }
            }
            if (this.fs.listStatus(this.srcDir).length > processedLogs.size() + corruptedLogs.size()) {
                throw new OrphanHLogAfterSplitException("Discovered orphan hlog after split. Maybe the HRegionServer was not dead when we started");
            }
            HLogSplitter.archiveLogs(this.srcDir, corruptedLogs, processedLogs, this.oldLogDir, this.fs, this.conf);
        }
        finally {
            splits = this.outputSink.finishWritingAndClose();
        }
        return splits;
    }

    private static void archiveLogs(Path srcDir, List<Path> corruptedLogs, List<Path> processedLogs, Path oldLogDir, FileSystem fs, Configuration conf) throws IOException {
        Path corruptDir = new Path(conf.get("hbase.rootdir"), conf.get("hbase.regionserver.hlog.splitlog.corrupt.dir", ".corrupt"));
        if (!fs.mkdirs(corruptDir)) {
            LOG.info((Object)("Unable to mkdir " + corruptDir));
        }
        fs.mkdirs(oldLogDir);
        for (Path corrupted : corruptedLogs) {
            Path p;
            if (!fs.rename(corrupted, p = new Path(corruptDir, corrupted.getName()))) {
                LOG.info((Object)("Unable to move corrupted log " + corrupted + " to " + p));
                continue;
            }
            LOG.info((Object)("Moving corrupted log " + corrupted + " to " + p));
        }
        for (Path p : processedLogs) {
            Path newPath;
            if (!fs.rename(p, newPath = HLog.getHLogArchivePath(oldLogDir, p))) {
                LOG.info((Object)("Unable to move  " + p + " to " + newPath));
                continue;
            }
            LOG.info((Object)("Archived processed log " + p + " to " + newPath));
        }
        if (!fs.delete(srcDir, true)) {
            throw new IOException("Unable to delete src dir: " + srcDir);
        }
    }

    static Path getRegionSplitEditsPath(FileSystem fs, HLog.Entry logEntry, Path rootDir) throws IOException {
        Path tableDir = HTableDescriptor.getTableDir(rootDir, logEntry.getKey().getTablename());
        Path regiondir = HRegion.getRegionDir(tableDir, Bytes.toString(logEntry.getKey().getEncodedRegionName()));
        if (!fs.exists(regiondir)) {
            LOG.info((Object)("This region's directory doesn't exist: " + regiondir.toString() + ". It is very likely that it was" + " already split so it's safe to discard those edits."));
            return null;
        }
        Path dir = HLog.getRegionDirRecoveredEditsDir(regiondir);
        if (!fs.exists(dir) && !fs.mkdirs(dir)) {
            LOG.warn((Object)("mkdir failed on " + dir));
        }
        return new Path(dir, HLogSplitter.formatRecoveredEditsFileName(logEntry.getKey().getLogSeqNum()));
    }

    static String formatRecoveredEditsFileName(long seqid) {
        return String.format("%019d", seqid);
    }

    private void parseHLog(FileStatus logfile, EntryBuffers entryBuffers, FileSystem fs, Configuration conf) throws IOException {
        HLog.Reader in;
        long length = logfile.getLen();
        if (length <= 0L) {
            LOG.warn((Object)("File " + logfile.getPath() + " might be still open, length is 0"));
        }
        Path path = logfile.getPath();
        int editsCount = 0;
        try {
            in = this.getReader(fs, path, conf);
        }
        catch (EOFException e) {
            if (length <= 0L) {
                LOG.warn((Object)("Could not open " + path + " for reading. File is empty" + e));
                return;
            }
            throw e;
        }
        try {
            HLog.Entry entry;
            while ((entry = in.next()) != null) {
                entryBuffers.appendEntry(entry);
                ++editsCount;
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            LOG.debug((Object)("Pushed=" + editsCount + " entries from " + path));
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Close log reader in finally threw exception -- continuing", (Throwable)e);
            }
        }
    }

    private void writerThreadError(Throwable t) {
        this.thrown.compareAndSet(null, t);
    }

    private void checkForErrors() throws IOException {
        Throwable thrown = this.thrown.get();
        if (thrown == null) {
            return;
        }
        if (thrown instanceof IOException) {
            throw (IOException)thrown;
        }
        throw new RuntimeException(thrown);
    }

    protected HLog.Writer createWriter(FileSystem fs, Path logfile, Configuration conf) throws IOException {
        return HLog.createWriter(fs, logfile, conf);
    }

    protected HLog.Reader getReader(FileSystem fs, Path curLogFile, Configuration conf) throws IOException {
        return HLog.getReader(fs, curLogFile, conf);
    }

    private static final class WriterAndPath {
        final Path p;
        final HLog.Writer w;
        long editsWritten = 0L;
        long nanosSpent = 0L;

        WriterAndPath(Path p, HLog.Writer w) {
            this.p = p;
            this.w = w;
        }

        void incrementEdits(int edits) {
            this.editsWritten += (long)edits;
        }

        void incrementNanoTime(long nanos) {
            this.nanosSpent += nanos;
        }
    }

    class OutputSink {
        private final Map<byte[], WriterAndPath> logWriters = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        private final List<WriterThread> writerThreads = Lists.newArrayList();
        private final Set<byte[]> blacklistedRegions = Collections.synchronizedSet(new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR));
        private boolean hasClosed = false;

        OutputSink() {
        }

        synchronized void startWriterThreads(EntryBuffers entryBuffers) {
            int numThreads = HLogSplitter.this.conf.getInt("hbase.regionserver.hlog.splitlog.writer.threads", 3);
            for (int i = 0; i < numThreads; ++i) {
                WriterThread t = new WriterThread(i);
                t.start();
                this.writerThreads.add(t);
            }
        }

        List<Path> finishWritingAndClose() throws IOException {
            LOG.info((Object)"Waiting for split writer threads to finish");
            for (WriterThread t : this.writerThreads) {
                t.finish();
            }
            for (WriterThread t : this.writerThreads) {
                try {
                    t.join();
                }
                catch (InterruptedException ie) {
                    throw new IOException(ie);
                }
                HLogSplitter.this.checkForErrors();
            }
            LOG.info((Object)"Split writers finished");
            return this.closeStreams();
        }

        private List<Path> closeStreams() throws IOException {
            Preconditions.checkState((!this.hasClosed ? 1 : 0) != 0);
            ArrayList<Path> paths = new ArrayList<Path>();
            ArrayList thrown = Lists.newArrayList();
            for (WriterAndPath wap : this.logWriters.values()) {
                try {
                    wap.w.close();
                }
                catch (IOException ioe) {
                    LOG.error((Object)("Couldn't close log at " + wap.p), (Throwable)ioe);
                    thrown.add(ioe);
                    continue;
                }
                paths.add(wap.p);
                LOG.info((Object)("Closed path " + wap.p + " (wrote " + wap.editsWritten + " edits in " + wap.nanosSpent / 1000L / 1000L + "ms)"));
            }
            if (!thrown.isEmpty()) {
                throw MultipleIOException.createIOException((List)thrown);
            }
            this.hasClosed = true;
            return paths;
        }

        WriterAndPath getWriterAndPath(HLog.Entry entry) throws IOException {
            byte[] region = entry.getKey().getEncodedRegionName();
            WriterAndPath ret = this.logWriters.get(region);
            if (ret != null) {
                return ret;
            }
            if (this.blacklistedRegions.contains(region)) {
                return null;
            }
            Path regionedits = HLogSplitter.getRegionSplitEditsPath(HLogSplitter.this.fs, entry, HLogSplitter.this.rootDir);
            if (regionedits == null) {
                this.blacklistedRegions.add(region);
                return null;
            }
            this.deletePreexistingOldEdits(regionedits);
            HLog.Writer w = HLogSplitter.this.createWriter(HLogSplitter.this.fs, regionedits, HLogSplitter.this.conf);
            ret = new WriterAndPath(regionedits, w);
            this.logWriters.put(region, ret);
            LOG.debug((Object)("Creating writer path=" + regionedits + " region=" + Bytes.toStringBinary(region)));
            return ret;
        }

        private void deletePreexistingOldEdits(Path regionedits) throws IOException {
            if (HLogSplitter.this.fs.exists(regionedits)) {
                LOG.warn((Object)("Found existing old edits file. It could be the result of a previous failed split attempt. Deleting " + regionedits + ", length=" + HLogSplitter.this.fs.getFileStatus(regionedits).getLen()));
                if (!HLogSplitter.this.fs.delete(regionedits, false)) {
                    LOG.warn((Object)("Failed delete of old " + regionedits));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<byte[], Long> getOutputCounts() {
            TreeMap<byte[], Long> ret = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            Map<byte[], WriterAndPath> map = this.logWriters;
            synchronized (map) {
                for (Map.Entry<byte[], WriterAndPath> entry : this.logWriters.entrySet()) {
                    ret.put(entry.getKey(), entry.getValue().editsWritten);
                }
            }
            return ret;
        }
    }

    class WriterThread
    extends Thread {
        private volatile boolean shouldStop;

        WriterThread(int i) {
            super("WriterThread-" + i);
            this.shouldStop = false;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                LOG.error((Object)"Error in log splitting write thread", t);
                HLogSplitter.this.writerThreadError(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() throws IOException {
            LOG.debug((Object)("Writer thread " + this + ": starting"));
            while (true) {
                RegionEntryBuffer buffer;
                if ((buffer = HLogSplitter.this.entryBuffers.getChunkToWrite()) == null) {
                    Object object = HLogSplitter.this.dataAvailable;
                    synchronized (object) {
                        block12: {
                            if (this.shouldStop) {
                                return;
                            }
                            try {
                                HLogSplitter.this.dataAvailable.wait(1000L);
                            }
                            catch (InterruptedException ie) {
                                if (this.shouldStop) break block12;
                                throw new RuntimeException(ie);
                            }
                        }
                    }
                }
                assert (buffer != null);
                try {
                    this.writeBuffer(buffer);
                    continue;
                }
                finally {
                    HLogSplitter.this.entryBuffers.doneWriting(buffer);
                    continue;
                }
                break;
            }
        }

        private void writeBuffer(RegionEntryBuffer buffer) throws IOException {
            List<HLog.Entry> entries = buffer.entryBuffer;
            if (entries.isEmpty()) {
                LOG.warn((Object)(this.getName() + " got an empty buffer, skipping"));
                return;
            }
            WriterAndPath wap = null;
            long startTime = System.nanoTime();
            try {
                int editsCount = 0;
                for (HLog.Entry logEntry : entries) {
                    if (wap == null && (wap = HLogSplitter.this.outputSink.getWriterAndPath(logEntry)) == null) {
                        return;
                    }
                    wap.w.append(logEntry);
                    ++editsCount;
                }
                wap.incrementEdits(editsCount);
                wap.incrementNanoTime(System.nanoTime() - startTime);
            }
            catch (IOException e) {
                e = RemoteExceptionHandler.checkIOException(e);
                LOG.fatal((Object)(this.getName() + " Got while writing log entry to log"), (Throwable)e);
                throw e;
            }
        }

        void finish() {
            this.shouldStop = true;
        }
    }

    static class RegionEntryBuffer
    implements HeapSize {
        long heapInBuffer = 0L;
        List<HLog.Entry> entryBuffer;
        byte[] tableName;
        byte[] encodedRegionName;

        RegionEntryBuffer(byte[] table, byte[] region) {
            this.tableName = table;
            this.encodedRegionName = region;
            this.entryBuffer = new LinkedList<HLog.Entry>();
        }

        long appendEntry(HLog.Entry entry) {
            this.internify(entry);
            this.entryBuffer.add(entry);
            long incrHeap = entry.getEdit().heapSize() + (long)ClassSize.align(2 * ClassSize.REFERENCE) + 0L;
            this.heapInBuffer += incrHeap;
            return incrHeap;
        }

        private void internify(HLog.Entry entry) {
            HLogKey k = entry.getKey();
            k.internTableName(this.tableName);
            k.internEncodedRegionName(this.encodedRegionName);
        }

        @Override
        public long heapSize() {
            return this.heapInBuffer;
        }
    }

    class EntryBuffers {
        Map<byte[], RegionEntryBuffer> buffers = new TreeMap<byte[], RegionEntryBuffer>(Bytes.BYTES_COMPARATOR);
        Set<byte[]> currentlyWriting = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        long totalBuffered = 0L;
        long maxHeapUsage;

        EntryBuffers(long maxHeapUsage) {
            this.maxHeapUsage = maxHeapUsage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void appendEntry(HLog.Entry entry) throws InterruptedException, IOException {
            HLogKey key = entry.getKey();
            Object object = this;
            synchronized (object) {
                RegionEntryBuffer buffer = this.buffers.get(key.getEncodedRegionName());
                if (buffer == null) {
                    buffer = new RegionEntryBuffer(key.getTablename(), key.getEncodedRegionName());
                    this.buffers.put(key.getEncodedRegionName(), buffer);
                }
                long incrHeap = buffer.appendEntry(entry);
                this.totalBuffered += incrHeap;
            }
            object = HLogSplitter.this.dataAvailable;
            synchronized (object) {
                while (this.totalBuffered > this.maxHeapUsage && HLogSplitter.this.thrown == null) {
                    LOG.debug((Object)("Used " + this.totalBuffered + " bytes of buffered edits, waiting for IO threads..."));
                    HLogSplitter.this.dataAvailable.wait(3000L);
                }
                HLogSplitter.this.dataAvailable.notifyAll();
            }
            HLogSplitter.this.checkForErrors();
        }

        synchronized RegionEntryBuffer getChunkToWrite() {
            long biggestSize = 0L;
            byte[] biggestBufferKey = null;
            for (Map.Entry<byte[], RegionEntryBuffer> entry : this.buffers.entrySet()) {
                long size = entry.getValue().heapSize();
                if (size <= biggestSize || this.currentlyWriting.contains(entry.getKey())) continue;
                biggestSize = size;
                biggestBufferKey = entry.getKey();
            }
            if (biggestBufferKey == null) {
                return null;
            }
            RegionEntryBuffer buffer = this.buffers.remove(biggestBufferKey);
            this.currentlyWriting.add(biggestBufferKey);
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doneWriting(RegionEntryBuffer buffer) {
            EntryBuffers entryBuffers = this;
            synchronized (entryBuffers) {
                boolean removed = this.currentlyWriting.remove(buffer.encodedRegionName);
                assert (removed);
            }
            long size = buffer.heapSize();
            Object object = HLogSplitter.this.dataAvailable;
            synchronized (object) {
                this.totalBuffered -= size;
                HLogSplitter.this.dataAvailable.notifyAll();
            }
        }

        synchronized boolean isRegionCurrentlyWriting(byte[] region) {
            return this.currentlyWriting.contains(region);
        }
    }
}

