/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableRecordReader;
import org.apache.hadoop.hbase.mapred.TableSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

@Deprecated
public abstract class TableInputFormatBase
implements InputFormat<ImmutableBytesWritable, Result> {
    final Log LOG = LogFactory.getLog(TableInputFormatBase.class);
    private byte[][] inputColumns;
    private HTable table;
    private TableRecordReader tableRecordReader;
    private Filter rowFilter;

    public RecordReader<ImmutableBytesWritable, Result> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        TableSplit tSplit = (TableSplit)split;
        TableRecordReader trr = this.tableRecordReader;
        if (trr == null) {
            trr = new TableRecordReader();
        }
        trr.setStartRow(tSplit.getStartRow());
        trr.setEndRow(tSplit.getEndRow());
        trr.setHTable(this.table);
        trr.setInputColumns(this.inputColumns);
        trr.setRowFilter(this.rowFilter);
        trr.init();
        return trr;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        if (this.table == null) {
            throw new IOException("No table was provided");
        }
        byte[][] startKeys = this.table.getStartKeys();
        if (startKeys == null || startKeys.length == 0) {
            throw new IOException("Expecting at least one region");
        }
        if (this.inputColumns == null || this.inputColumns.length == 0) {
            throw new IOException("Expecting at least one column");
        }
        int realNumSplits = numSplits > startKeys.length ? startKeys.length : numSplits;
        InputSplit[] splits = new InputSplit[realNumSplits];
        int middle = startKeys.length / realNumSplits;
        int startPos = 0;
        for (int i = 0; i < realNumSplits; ++i) {
            int lastPos = startPos + middle;
            lastPos = startKeys.length % realNumSplits > i ? lastPos + 1 : lastPos;
            String regionLocation = this.table.getRegionLocation(startKeys[startPos]).getServerAddress().getHostname();
            splits[i] = new TableSplit(this.table.getTableName(), startKeys[startPos], i + 1 < realNumSplits ? startKeys[lastPos] : HConstants.EMPTY_START_ROW, regionLocation);
            this.LOG.info((Object)("split: " + i + "->" + splits[i]));
            startPos = lastPos;
        }
        return splits;
    }

    protected void setInputColumns(byte[][] inputColumns) {
        this.inputColumns = inputColumns;
    }

    protected HTable getHTable() {
        return this.table;
    }

    protected void setHTable(HTable table) {
        this.table = table;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }

    protected void setRowFilter(Filter rowFilter) {
        this.rowFilter = rowFilter;
    }
}

