/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class Increment
implements Writable {
    private static final byte INCREMENT_VERSION = 2;
    private byte[] row = null;
    private long lockId = -1L;
    private boolean writeToWAL = true;
    private TimeRange tr = new TimeRange();
    private Map<byte[], NavigableMap<byte[], Long>> familyMap = new TreeMap<byte[], NavigableMap<byte[], Long>>(Bytes.BYTES_COMPARATOR);

    public Increment() {
    }

    public Increment(byte[] row) {
        this(row, null);
    }

    public Increment(byte[] row, RowLock rowLock) {
        this.row = row;
        if (rowLock != null) {
            this.lockId = rowLock.getLockId();
        }
    }

    public Increment addColumn(byte[] family, byte[] qualifier, long amount) {
        NavigableMap<byte[], Long> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
        }
        set.put(qualifier, amount);
        this.familyMap.put(family, set);
        return this;
    }

    public byte[] getRow() {
        return this.row;
    }

    public RowLock getRowLock() {
        return new RowLock(this.row, this.lockId);
    }

    public long getLockId() {
        return this.lockId;
    }

    public boolean getWriteToWAL() {
        return this.writeToWAL;
    }

    public Increment setWriteToWAL(boolean writeToWAL) {
        this.writeToWAL = writeToWAL;
        return this;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public Increment setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    public Set<byte[]> familySet() {
        return this.familyMap.keySet();
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public int numColumns() {
        if (!this.hasFamilies()) {
            return 0;
        }
        int num = 0;
        for (NavigableMap<byte[], Long> family : this.familyMap.values()) {
            num += family.size();
        }
        return num;
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public Map<byte[], NavigableMap<byte[], Long>> getFamilyMap() {
        return this.familyMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("row=");
        sb.append(Bytes.toString(this.row));
        if (this.familyMap.size() == 0) {
            sb.append(", no columns set to be incremented");
            return sb.toString();
        }
        sb.append(", families=");
        boolean moreThanOne = false;
        for (Map.Entry<byte[], NavigableMap<byte[], Long>> entry : this.familyMap.entrySet()) {
            if (moreThanOne) {
                sb.append("), ");
            } else {
                moreThanOne = true;
                sb.append("{");
            }
            sb.append("(family=");
            sb.append(Bytes.toString(entry.getKey()));
            sb.append(", columns=");
            if (entry.getValue() == null) {
                sb.append("NONE");
                continue;
            }
            sb.append("{");
            boolean moreThanOneB = false;
            for (Map.Entry column : entry.getValue().entrySet()) {
                if (moreThanOneB) {
                    sb.append(", ");
                } else {
                    moreThanOneB = true;
                }
                sb.append(Bytes.toString((byte[])column.getKey()) + "+=" + column.getValue());
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 2) {
            throw new IOException("unsupported version");
        }
        this.row = Bytes.readByteArray(in);
        this.tr = new TimeRange();
        this.tr.readFields(in);
        this.lockId = in.readLong();
        int numFamilies = in.readInt();
        if (numFamilies == 0) {
            throw new IOException("At least one column required");
        }
        this.familyMap = new TreeMap<byte[], NavigableMap<byte[], Long>>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            boolean hasColumns = in.readBoolean();
            TreeMap<byte[], Long> set = null;
            if (hasColumns) {
                int numColumns = in.readInt();
                set = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
                for (int j = 0; j < numColumns; ++j) {
                    byte[] qualifier = Bytes.readByteArray(in);
                    set.put(qualifier, in.readLong());
                }
            } else {
                throw new IOException("At least one column required per family");
            }
            this.familyMap.put(family, set);
        }
        if (version > 1) {
            this.writeToWAL = in.readBoolean();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(2);
        Bytes.writeByteArray(out, this.row);
        this.tr.write(out);
        out.writeLong(this.lockId);
        if (this.familyMap.size() == 0) {
            throw new IOException("At least one column required");
        }
        out.writeInt(this.familyMap.size());
        for (Map.Entry<byte[], NavigableMap<byte[], Long>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            NavigableMap<byte[], Long> columnSet = entry.getValue();
            if (columnSet == null) {
                throw new IOException("At least one column required per family");
            }
            out.writeBoolean(true);
            out.writeInt(columnSet.size());
            for (Map.Entry qualifier : columnSet.entrySet()) {
                Bytes.writeByteArray(out, (byte[])qualifier.getKey());
                out.writeLong((Long)qualifier.getValue());
            }
        }
        out.writeBoolean(this.writeToWAL);
    }
}

