/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluckTuple
extends EvalFunc<Tuple> {
    private static final TupleFactory mTupleFactory = TupleFactory.getInstance();
    private boolean isInitialized = false;
    private int[] indicesToInclude;
    private String prefix;

    public PluckTuple(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Tuple exec(Tuple input) throws IOException {
        if (!this.isInitialized) {
            ArrayList indicesToInclude = Lists.newArrayList();
            Schema inputSchema = this.getInputSchema();
            for (int i = 0; i < inputSchema.size(); ++i) {
                String alias = inputSchema.getField((int)i).alias;
                if (!alias.startsWith(this.prefix)) continue;
                indicesToInclude.add(i);
            }
            this.indicesToInclude = new int[indicesToInclude.size()];
            int idx = 0;
            Iterator i$ = indicesToInclude.iterator();
            while (i$.hasNext()) {
                int val = (Integer)i$.next();
                this.indicesToInclude[idx++] = val;
            }
            this.isInitialized = true;
        }
        Tuple result = mTupleFactory.newTuple(this.indicesToInclude.length);
        int idx = 0;
        for (int val : this.indicesToInclude) {
            result.set(idx++, input.get(val));
        }
        return result;
    }

    @Override
    public Schema outputSchema(Schema inputSchema) {
        if (!this.isInitialized) {
            ArrayList indicesToInclude = Lists.newArrayList();
            for (int i = 0; i < inputSchema.size(); ++i) {
                String alias;
                try {
                    alias = inputSchema.getField((int)i).alias;
                }
                catch (FrontendException e) {
                    throw new RuntimeException(e);
                }
                if (!alias.startsWith(this.prefix)) continue;
                indicesToInclude.add(i);
            }
            this.indicesToInclude = new int[indicesToInclude.size()];
            int idx = 0;
            Iterator i$ = indicesToInclude.iterator();
            while (i$.hasNext()) {
                int val = (Integer)i$.next();
                this.indicesToInclude[idx++] = val;
            }
            this.isInitialized = true;
        }
        Schema outputSchema = new Schema();
        for (int val : this.indicesToInclude) {
            try {
                outputSchema.add(inputSchema.getField(val));
            }
            catch (FrontendException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return new Schema(new Schema.FieldSchema("plucked", outputSchema, 110));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

