/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.hbase;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadPushDown;
import org.apache.pig.LoadStoreCaster;
import org.apache.pig.OrderedLoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.hbase.HBaseBinaryConverter;
import org.apache.pig.backend.hadoop.hbase.HBaseTableInputFormat;
import org.apache.pig.builtin.Utf8StorageConverter;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.zookeeper.ZooKeeper;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HBaseStorage
extends LoadFunc
implements StoreFuncInterface,
LoadPushDown,
OrderedLoadFunc {
    private static final Log LOG = LogFactory.getLog(HBaseStorage.class);
    private static final String STRING_CASTER = "UTF8StorageConverter";
    private static final String BYTE_CASTER = "HBaseBinaryConverter";
    private static final String CASTER_PROPERTY = "pig.hbase.caster";
    private static final String ASTERISK = "*";
    private static final String COLON = ":";
    private static final String HBASE_SECURITY_CONF_KEY = "hbase.security.authentication";
    private static final String HBASE_CONFIG_SET = "hbase.config.set";
    private static final String HBASE_TOKEN_SET = "hbase.token.set";
    private List<ColumnInfo> columnInfo_ = Lists.newArrayList();
    private JobConf m_conf;
    private RecordReader reader;
    private RecordWriter writer;
    private TableOutputFormat outputFormat = null;
    private Scan scan;
    private String contextSignature = null;
    private final CommandLine configuredOptions_;
    private static final Options validOptions_ = new Options();
    private static final CommandLineParser parser_ = new GnuParser();
    private boolean loadRowKey_;
    private String delimiter_;
    private boolean ignoreWhitespace_;
    private final long limit_;
    private final int caching_;
    private final boolean noWAL_;
    private final long minTimestamp_;
    private final long maxTimestamp_;
    private final long timestamp_;
    protected transient byte[] gt_;
    protected transient byte[] gte_;
    protected transient byte[] lt_;
    protected transient byte[] lte_;
    private LoadCaster caster_;
    private ResourceSchema schema_;
    private LoadPushDown.RequiredFieldList requiredFieldList;

    private static void populateValidOptions() {
        validOptions_.addOption("loadKey", false, "Load Key");
        validOptions_.addOption("gt", true, "Records must be greater than this value (binary, double-slash-escaped)");
        validOptions_.addOption("lt", true, "Records must be less than this value (binary, double-slash-escaped)");
        validOptions_.addOption("gte", true, "Records must be greater than or equal to this value");
        validOptions_.addOption("lte", true, "Records must be less than or equal to this value");
        validOptions_.addOption("caching", true, "Number of rows scanners should cache");
        validOptions_.addOption("limit", true, "Per-region limit");
        validOptions_.addOption("delim", true, "Column delimiter");
        validOptions_.addOption("ignoreWhitespace", true, "Ignore spaces when parsing columns");
        validOptions_.addOption("caster", true, "Caster to use for converting values. A class name, HBaseBinaryConverter, or Utf8StorageConverter. For storage, casters must implement LoadStoreCaster.");
        validOptions_.addOption("noWAL", false, "Sets the write ahead to false for faster loading. To be used with extreme caution since this could result in data loss (see http://hbase.apache.org/book.html#perf.hbase.client.putwal).");
        validOptions_.addOption("minTimestamp", true, "Record must have timestamp greater or equal to this value");
        validOptions_.addOption("maxTimestamp", true, "Record must have timestamp less then this value");
        validOptions_.addOption("timestamp", true, "Record must have timestamp equal to this value");
    }

    public HBaseStorage(String columnList) throws ParseException, IOException {
        this(columnList, "");
    }

    public HBaseStorage(String columnList, String optString) throws ParseException, IOException {
        String value;
        HBaseStorage.populateValidOptions();
        String[] optsArr = optString.split(" ");
        try {
            this.configuredOptions_ = parser_.parse(validOptions_, optsArr);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("[-loadKey] [-gt] [-gte] [-lt] [-lte] [-columnPrefix] [-caching] [-caster] [-noWAL] [-limit] [-delim] [-ignoreWhitespace] [-minTimestamp] [-maxTimestamp] [-timestamp]", validOptions_);
            throw e;
        }
        this.loadRowKey_ = this.configuredOptions_.hasOption("loadKey");
        this.delimiter_ = ",";
        if (this.configuredOptions_.getOptionValue("delim") != null) {
            this.delimiter_ = this.configuredOptions_.getOptionValue("delim");
        }
        this.ignoreWhitespace_ = true;
        if (this.configuredOptions_.hasOption("ignoreWhitespace") && !"true".equalsIgnoreCase(value = this.configuredOptions_.getOptionValue("ignoreWhitespace"))) {
            this.ignoreWhitespace_ = false;
        }
        this.columnInfo_ = this.parseColumnList(columnList, this.delimiter_, this.ignoreWhitespace_);
        String defaultCaster = UDFContext.getUDFContext().getClientSystemProps().getProperty(CASTER_PROPERTY, STRING_CASTER);
        String casterOption = this.configuredOptions_.getOptionValue("caster", defaultCaster);
        if (STRING_CASTER.equalsIgnoreCase(casterOption)) {
            this.caster_ = new Utf8StorageConverter();
        } else if (BYTE_CASTER.equalsIgnoreCase(casterOption)) {
            this.caster_ = new HBaseBinaryConverter();
        } else {
            try {
                this.caster_ = (LoadCaster)PigContext.instantiateFuncFromSpec(casterOption);
            }
            catch (ClassCastException e) {
                LOG.error((Object)"Configured caster does not implement LoadCaster interface.");
                throw new IOException(e);
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Configured caster class not found.", (Throwable)e);
                throw new IOException(e);
            }
        }
        LOG.debug((Object)("Using caster " + this.caster_.getClass()));
        this.caching_ = Integer.valueOf(this.configuredOptions_.getOptionValue("caching", "100"));
        this.limit_ = Long.valueOf(this.configuredOptions_.getOptionValue("limit", "-1"));
        this.noWAL_ = this.configuredOptions_.hasOption("noWAL");
        this.minTimestamp_ = this.configuredOptions_.hasOption("minTimestamp") ? Long.parseLong(this.configuredOptions_.getOptionValue("minTimestamp")) : 0L;
        this.maxTimestamp_ = this.configuredOptions_.hasOption("maxTimestamp") ? Long.parseLong(this.configuredOptions_.getOptionValue("maxTimestamp")) : Long.MAX_VALUE;
        this.timestamp_ = this.configuredOptions_.hasOption("timestamp") ? Long.parseLong(this.configuredOptions_.getOptionValue("timestamp")) : 0L;
        this.initScan();
    }

    private Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(this.getClass(), new String[]{this.contextSignature});
    }

    private String projectedFieldsName() {
        return this.contextSignature + "_projectedFields";
    }

    private List<ColumnInfo> parseColumnList(String columnList, String delimiter, boolean ignoreWhitespace) {
        ArrayList<ColumnInfo> columnInfo = new ArrayList<ColumnInfo>();
        String[] colNames = columnList.split(delimiter);
        if (ignoreWhitespace) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String colName : colNames) {
                String[] subColNames;
                for (String subColName : subColNames = colName.split(" ")) {
                    if ((subColName = subColName.trim()).length() <= 0) continue;
                    columns.add(subColName);
                }
            }
            colNames = columns.toArray(new String[columns.size()]);
        }
        for (String colName : colNames) {
            columnInfo.add(new ColumnInfo(colName));
        }
        return columnInfo;
    }

    private void initScan() throws IOException {
        this.scan = new Scan();
        this.scan.setCacheBlocks(false);
        this.scan.setCaching(this.caching_);
        if (this.configuredOptions_.hasOption("gt")) {
            this.gt_ = Bytes.toBytesBinary((String)Utils.slashisize(this.configuredOptions_.getOptionValue("gt")));
            this.addRowFilter(CompareFilter.CompareOp.GREATER, this.gt_);
            this.scan.setStartRow(this.gt_);
        }
        if (this.configuredOptions_.hasOption("lt")) {
            this.lt_ = Bytes.toBytesBinary((String)Utils.slashisize(this.configuredOptions_.getOptionValue("lt")));
            this.addRowFilter(CompareFilter.CompareOp.LESS, this.lt_);
            this.scan.setStopRow(this.lt_);
        }
        if (this.configuredOptions_.hasOption("gte")) {
            this.gte_ = Bytes.toBytesBinary((String)Utils.slashisize(this.configuredOptions_.getOptionValue("gte")));
            this.scan.setStartRow(this.gte_);
        }
        if (this.configuredOptions_.hasOption("lte")) {
            this.lte_ = Bytes.toBytesBinary((String)Utils.slashisize(this.configuredOptions_.getOptionValue("lte")));
            byte[] lt = HBaseStorage.increment(this.lte_);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Incrementing lte value of %s from bytes %s to %s to set stop row", Bytes.toString((byte[])this.lte_), HBaseStorage.toString(this.lte_), HBaseStorage.toString(lt)));
            }
            if (lt != null) {
                this.scan.setStopRow(HBaseStorage.increment(this.lte_));
            }
            this.addFilter((Filter)new WhileMatchFilter((Filter)new RowFilter(CompareFilter.CompareOp.LESS_OR_EQUAL, (WritableByteArrayComparable)new BinaryComparator(this.lte_))));
        }
        if (this.configuredOptions_.hasOption("minTimestamp") || this.configuredOptions_.hasOption("maxTimestamp")) {
            this.scan.setTimeRange(this.minTimestamp_, this.maxTimestamp_);
        }
        if (this.configuredOptions_.hasOption("timestamp")) {
            this.scan.setTimeStamp(this.timestamp_);
        }
        boolean columnPrefixExists = false;
        for (ColumnInfo columnInfo : this.columnInfo_) {
            if (columnInfo.getColumnPrefix() == null) continue;
            columnPrefixExists = true;
            break;
        }
        if (!columnPrefixExists) {
            this.addFiltersWithoutColumnPrefix(this.columnInfo_);
        } else {
            this.addFiltersWithColumnPrefix(this.columnInfo_);
        }
    }

    private void addFiltersWithoutColumnPrefix(List<ColumnInfo> columnInfos) {
        Map<String, List<ColumnInfo>> groupedMap = HBaseStorage.groupByFamily(columnInfos);
        for (Map.Entry<String, List<ColumnInfo>> entrySet : groupedMap.entrySet()) {
            boolean onlyColumns = true;
            for (ColumnInfo columnInfo : entrySet.getValue()) {
                if (!columnInfo.isColumnMap()) continue;
                onlyColumns = false;
                break;
            }
            if (onlyColumns) {
                for (ColumnInfo columnInfo : entrySet.getValue()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding column to scan via addColumn with cf:name = " + Bytes.toString((byte[])columnInfo.getColumnFamily()) + COLON + Bytes.toString((byte[])columnInfo.getColumnName())));
                    }
                    this.scan.addColumn(columnInfo.getColumnFamily(), columnInfo.getColumnName());
                }
                continue;
            }
            String family = entrySet.getKey();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding column family to scan via addFamily with cf:name = " + family));
            }
            this.scan.addFamily(Bytes.toBytes((String)family));
        }
    }

    private void addFiltersWithColumnPrefix(List<ColumnInfo> columnInfos) {
        FilterList allColumnFilters = null;
        Map<String, List<ColumnInfo>> groupedMap = HBaseStorage.groupByFamily(columnInfos);
        for (String cfString : groupedMap.keySet()) {
            List<ColumnInfo> columnInfoList = groupedMap.get(cfString);
            byte[] cf = Bytes.toBytes((String)cfString);
            if (allColumnFilters == null) {
                allColumnFilters = new FilterList(FilterList.Operator.MUST_PASS_ONE);
            }
            FilterList thisColumnGroupFilter = new FilterList(FilterList.Operator.MUST_PASS_ALL);
            thisColumnGroupFilter.addFilter((Filter)new FamilyFilter(CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new BinaryComparator(cf)));
            FilterList columnFilters = new FilterList(FilterList.Operator.MUST_PASS_ONE);
            for (ColumnInfo colInfo : columnInfoList) {
                if (colInfo.isColumnMap()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding family:prefix filters with values " + Bytes.toString((byte[])colInfo.getColumnFamily()) + COLON + Bytes.toString((byte[])colInfo.getColumnPrefix())));
                    }
                    if (colInfo.getColumnPrefix() == null) continue;
                    columnFilters.addFilter((Filter)new ColumnPrefixFilter(colInfo.getColumnPrefix()));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding family:descriptor filters with values " + Bytes.toString((byte[])colInfo.getColumnFamily()) + COLON + Bytes.toString((byte[])colInfo.getColumnName())));
                }
                columnFilters.addFilter((Filter)new QualifierFilter(CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new BinaryComparator(colInfo.getColumnName())));
            }
            thisColumnGroupFilter.addFilter((Filter)columnFilters);
            allColumnFilters.addFilter((Filter)thisColumnGroupFilter);
        }
        if (allColumnFilters != null) {
            this.addFilter((Filter)allColumnFilters);
        }
    }

    private void addRowFilter(CompareFilter.CompareOp op, byte[] val) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding filter " + op.toString() + " with value " + Bytes.toStringBinary((byte[])val)));
        }
        this.addFilter((Filter)new RowFilter(op, (WritableByteArrayComparable)new BinaryComparator(val)));
    }

    private void addFilter(Filter filter) {
        FilterList scanFilter = (FilterList)this.scan.getFilter();
        if (scanFilter == null) {
            scanFilter = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        }
        scanFilter.addFilter(filter);
        this.scan.setFilter((Filter)scanFilter);
    }

    public List<ColumnInfo> getColumnInfoList() {
        return this.columnInfo_;
    }

    protected void setColumnInfoList(List<ColumnInfo> columnInfoList) {
        this.columnInfo_ = columnInfoList;
    }

    protected void storeProjectedFieldNames(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        try {
            this.getUDFProperties().setProperty(this.projectedFieldsName(), ObjectSerializer.serialize(requiredFieldList));
        }
        catch (IOException e) {
            throw new FrontendException(e);
        }
    }

    @Override
    public Tuple getNext() throws IOException {
        try {
            if (this.reader.nextKeyValue()) {
                int i;
                ImmutableBytesWritable rowKey = (ImmutableBytesWritable)this.reader.getCurrentKey();
                Result result = (Result)this.reader.getCurrentValue();
                int tupleSize = this.columnInfo_.size();
                NavigableMap resultsMap = result.getNoVersionMap();
                if (this.loadRowKey_) {
                    ++tupleSize;
                }
                Tuple tuple = TupleFactory.getInstance().newTuple(tupleSize);
                int startIndex = 0;
                if (this.loadRowKey_) {
                    tuple.set(0, new DataByteArray(rowKey.get()));
                    ++startIndex;
                }
                for (i = 0; i < this.columnInfo_.size(); ++i) {
                    int currentIndex = startIndex + i;
                    ColumnInfo columnInfo = this.columnInfo_.get(i);
                    if (columnInfo.isColumnMap()) {
                        NavigableMap cfResults = (NavigableMap)resultsMap.get(columnInfo.getColumnFamily());
                        HashMap<String, DataByteArray> cfMap = new HashMap<String, DataByteArray>();
                        if (cfResults != null) {
                            for (byte[] quantifier : cfResults.keySet()) {
                                if (columnInfo.getColumnPrefix() != null && !columnInfo.hasPrefixMatch(quantifier)) continue;
                                byte[] cell = (byte[])cfResults.get(quantifier);
                                DataByteArray value = cell == null ? null : new DataByteArray(cell);
                                cfMap.put(Bytes.toString((byte[])quantifier), value);
                            }
                        }
                        tuple.set(currentIndex, cfMap);
                        continue;
                    }
                    byte[] cell = result.getValue(columnInfo.getColumnFamily(), columnInfo.getColumnName());
                    DataByteArray value = cell == null ? null : new DataByteArray(cell);
                    tuple.set(currentIndex, value);
                }
                if (LOG.isDebugEnabled()) {
                    for (i = 0; i < tuple.size(); ++i) {
                        LOG.debug((Object)("tuple value:" + tuple.get(i)));
                    }
                }
                return tuple;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return null;
    }

    @Override
    public InputFormat getInputFormat() {
        HBaseTableInputFormat inputFormat = new HBaseTableInputFormat.HBaseTableIFBuilder().withLimit(this.limit_).withGt(this.gt_).withGte(this.gte_).withLt(this.lt_).withLte(this.lte_).withConf((Configuration)this.m_conf).build();
        inputFormat.setScan(this.scan);
        return inputFormat;
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.reader = reader;
    }

    @Override
    public void setUDFContextSignature(String signature) {
        this.contextSignature = signature;
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        Properties udfProps = this.getUDFProperties();
        job.getConfiguration().setBoolean("pig.noSplitCombination", true);
        this.initialiseHBaseClassLoaderResources(job);
        this.m_conf = this.initializeLocalJobConfig(job);
        String delegationTokenSet = udfProps.getProperty(HBASE_TOKEN_SET);
        if (delegationTokenSet == null) {
            this.addHBaseDelegationToken((Configuration)this.m_conf, job);
            udfProps.setProperty(HBASE_TOKEN_SET, "true");
        }
        String tablename = location;
        if (location.startsWith("hbase://")) {
            tablename = location.substring(8);
        }
        this.m_conf.set("hbase.mapreduce.inputtable", tablename);
        String projectedFields = udfProps.getProperty(this.projectedFieldsName());
        if (projectedFields != null) {
            this.pushProjection((LoadPushDown.RequiredFieldList)ObjectSerializer.deserialize(projectedFields));
        }
        this.addFiltersWithoutColumnPrefix(this.columnInfo_);
        if (this.requiredFieldList != null) {
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass(), new String[]{this.contextSignature});
            p.setProperty(this.contextSignature + "_projectedFields", ObjectSerializer.serialize(this.requiredFieldList));
        }
    }

    private void initialiseHBaseClassLoaderResources(Job job) throws IOException {
        TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{HTable.class, Lists.class, ZooKeeper.class});
    }

    private JobConf initializeLocalJobConfig(Job job) {
        Properties udfProps = this.getUDFProperties();
        Configuration jobConf = job.getConfiguration();
        JobConf localConf = new JobConf(jobConf);
        if (udfProps.containsKey(HBASE_CONFIG_SET)) {
            for (Map.Entry<Object, Object> entry : udfProps.entrySet()) {
                localConf.set((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            Configuration hbaseConf = HBaseConfiguration.create();
            for (Map.Entry entry : hbaseConf) {
                if (jobConf.get((String)entry.getKey()) != null) continue;
                udfProps.setProperty((String)entry.getKey(), (String)entry.getValue());
                localConf.set((String)entry.getKey(), (String)entry.getValue());
            }
            udfProps.setProperty(HBASE_CONFIG_SET, "true");
        }
        return localConf;
    }

    private void addHBaseDelegationToken(Configuration hbaseConf, Job job) {
        if (!UDFContext.getUDFContext().isFrontend()) {
            return;
        }
        if ("kerberos".equalsIgnoreCase(hbaseConf.get(HBASE_SECURITY_CONF_KEY))) {
            try {
                Method m1 = UserGroupInformation.class.getMethod("getCurrentUser", new Class[0]);
                UserGroupInformation currentUser = (UserGroupInformation)m1.invoke(null, (Object[])null);
                Method m2 = UserGroupInformation.class.getMethod("hasKerberosCredentials", new Class[0]);
                boolean hasKerberosCredentials = (Boolean)m2.invoke((Object)currentUser, (Object[])null);
                if (hasKerberosCredentials) {
                    Class<?> tokenUtilClass = Class.forName("org.apache.hadoop.hbase.security.token.TokenUtil");
                    Method m3 = tokenUtilClass.getMethod("obtainTokenForJob", Configuration.class, UserGroupInformation.class, Job.class);
                    m3.invoke(null, hbaseConf, currentUser, job);
                } else {
                    LOG.info((Object)"Not fetching hbase delegation token as no Kerberos TGT is available");
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Failure loading TokenUtil class, is secure RPC available?", cnfe);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected error calling TokenUtil.obtainTokenForJob()");
            }
        }
    }

    @Override
    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return location;
    }

    @Override
    public LoadCaster getLoadCaster() throws IOException {
        return this.caster_;
    }

    @Override
    public OutputFormat getOutputFormat() throws IOException {
        if (this.outputFormat == null) {
            if (this.m_conf == null) {
                throw new IllegalStateException("setStoreLocation has not been called");
            }
            this.outputFormat = new TableOutputFormat();
            this.outputFormat.setConf((Configuration)this.m_conf);
        }
        return this.outputFormat;
    }

    @Override
    public void checkSchema(ResourceSchema s) throws IOException {
        if (!(this.caster_ instanceof LoadStoreCaster)) {
            LOG.error((Object)"Caster must implement LoadStoreCaster for writing to HBase.");
            throw new IOException("Bad Caster " + this.caster_.getClass());
        }
        this.schema_ = s;
        this.getUDFProperties().setProperty(this.contextSignature + "_schema", ObjectSerializer.serialize(this.schema_));
    }

    @Override
    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
    }

    @Override
    public void putNext(Tuple t) throws IOException {
        ResourceSchema.ResourceFieldSchema[] fieldSchemas = this.schema_ == null ? null : this.schema_.getFields();
        byte type = fieldSchemas == null ? DataType.findType(t.get(0)) : fieldSchemas[0].getType();
        long ts = System.currentTimeMillis();
        Put put = this.createPut(t.get(0), type);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("putNext -- WAL disabled: " + this.noWAL_));
            for (ColumnInfo columnInfo : this.columnInfo_) {
                LOG.debug((Object)("putNext -- col: " + columnInfo));
            }
        }
        for (int i = 1; i < t.size(); ++i) {
            ColumnInfo columnInfo;
            columnInfo = this.columnInfo_.get(i - 1);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("putNext - tuple: " + i + ", value=" + t.get(i) + ", cf:column=" + columnInfo));
            }
            if (!columnInfo.isColumnMap()) {
                put.add(columnInfo.getColumnFamily(), columnInfo.getColumnName(), ts, this.objToBytes(t.get(i), fieldSchemas == null ? DataType.findType(t.get(i)) : fieldSchemas[i].getType()));
                continue;
            }
            Map cfMap = (Map)t.get(i);
            for (String colName : cfMap.keySet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("putNext - colName=" + colName + ", class: " + colName.getClass()));
                }
                put.add(columnInfo.getColumnFamily(), Bytes.toBytes((String)colName.toString()), ts, this.objToBytes(cfMap.get(colName), DataType.findType(cfMap.get(colName))));
            }
        }
        try {
            this.writer.write(null, (Object)put);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public Put createPut(Object key, byte type) throws IOException {
        Put put = new Put(this.objToBytes(key, type));
        if (this.noWAL_) {
            put.setWriteToWAL(false);
        }
        return put;
    }

    private byte[] objToBytes(Object o, byte type) throws IOException {
        LoadStoreCaster caster = (LoadStoreCaster)this.caster_;
        if (o == null) {
            return null;
        }
        switch (type) {
            case 50: {
                return ((DataByteArray)o).get();
            }
            case 120: {
                return caster.toBytes((DataBag)o);
            }
            case 55: {
                return caster.toBytes((String)o);
            }
            case 25: {
                return caster.toBytes((Double)o);
            }
            case 20: {
                return caster.toBytes((Float)o);
            }
            case 10: {
                return caster.toBytes((Integer)o);
            }
            case 15: {
                return caster.toBytes((Long)o);
            }
            case 65: {
                return caster.toBytes((BigInteger)o);
            }
            case 70: {
                return caster.toBytes((BigDecimal)o);
            }
            case 5: {
                return caster.toBytes((Boolean)o);
            }
            case 30: {
                return caster.toBytes((DateTime)o);
            }
            case 100: {
                return caster.toBytes((Map)o);
            }
            case 1: {
                return null;
            }
            case 110: {
                return caster.toBytes((Tuple)o);
            }
            case -1: {
                throw new IOException("Unable to determine type of " + o.getClass());
            }
        }
        throw new IOException("Unable to find a converter for tuple field " + o);
    }

    @Override
    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    @Override
    public void setStoreFuncUDFContextSignature(String signature) {
        this.contextSignature = signature;
    }

    @Override
    public void setStoreLocation(String location, Job job) throws IOException {
        if (location.startsWith("hbase://")) {
            job.getConfiguration().set("hbase.mapred.outputtable", location.substring(8));
        } else {
            job.getConfiguration().set("hbase.mapred.outputtable", location);
        }
        String serializedSchema = this.getUDFProperties().getProperty(this.contextSignature + "_schema");
        if (serializedSchema != null) {
            this.schema_ = (ResourceSchema)ObjectSerializer.deserialize(serializedSchema);
        }
        this.initialiseHBaseClassLoaderResources(job);
        this.m_conf = this.initializeLocalJobConfig(job);
        this.addHBaseDelegationToken((Configuration)this.m_conf, job);
    }

    @Override
    public void cleanupOnFailure(String location, Job job) throws IOException {
    }

    @Override
    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    @Override
    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    @Override
    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        int colOffset;
        List<LoadPushDown.RequiredField> requiredFields = requiredFieldList.getFields();
        ArrayList newColumns = Lists.newArrayListWithExpectedSize((int)requiredFields.size());
        if (this.requiredFieldList != null) {
            LOG.debug((Object)"projection is already set. skipping.");
            return new LoadPushDown.RequiredFieldResponse(true);
        }
        int projOffset = colOffset = this.loadRowKey_ ? 1 : 0;
        this.requiredFieldList = requiredFieldList;
        if (requiredFieldList != null && requiredFields.size() > this.columnInfo_.size() + colOffset) {
            throw new FrontendException("The list of columns to project from HBase is larger than HBaseStorage is configured to load.");
        }
        this.storeProjectedFieldNames(requiredFieldList);
        if (this.loadRowKey_ && (requiredFields.size() < 1 || requiredFields.get(0).getIndex() != 0)) {
            this.loadRowKey_ = false;
            projOffset = 0;
        }
        for (int i = projOffset; i < requiredFields.size(); ++i) {
            int fieldIndex = requiredFields.get(i).getIndex();
            newColumns.add(this.columnInfo_.get(fieldIndex - colOffset));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pushProjection After Projection: loadRowKey is " + this.loadRowKey_));
            for (ColumnInfo colInfo : newColumns) {
                LOG.debug((Object)("pushProjection -- col: " + colInfo));
            }
        }
        this.setColumnInfoList(newColumns);
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public WritableComparable<InputSplit> getSplitComparable(InputSplit split) throws IOException {
        return new WritableComparable<InputSplit>(){
            TableSplit tsplit = new TableSplit();

            public void readFields(DataInput in) throws IOException {
                this.tsplit.readFields(in);
            }

            public void write(DataOutput out) throws IOException {
                this.tsplit.write(out);
            }

            public int compareTo(InputSplit split) {
                return this.tsplit.compareTo((TableSplit)split);
            }
        };
    }

    static Map<String, List<ColumnInfo>> groupByFamily(List<ColumnInfo> columnInfos) {
        HashMap<String, List<ColumnInfo>> groupedMap = new HashMap<String, List<ColumnInfo>>();
        for (ColumnInfo columnInfo : columnInfos) {
            String cf = Bytes.toString((byte[])columnInfo.getColumnFamily());
            ArrayList<ColumnInfo> columnInfoList = (ArrayList<ColumnInfo>)groupedMap.get(cf);
            if (columnInfoList == null) {
                columnInfoList = new ArrayList<ColumnInfo>();
            }
            columnInfoList.add(columnInfo);
            groupedMap.put(cf, columnInfoList);
        }
        return groupedMap;
    }

    static String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(bytes[i]);
        }
        return sb.toString();
    }

    static byte[] increment(byte[] bytes) {
        boolean allAtMax = true;
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[bytes.length - i - 1] & 0xFF) == 255) continue;
            allAtMax = false;
            break;
        }
        if (allAtMax) {
            return Arrays.copyOf(bytes, bytes.length + 1);
        }
        byte[] incremented = (byte[])bytes.clone();
        for (int i = bytes.length - 1; i >= 0; --i) {
            boolean carry = false;
            int val = bytes[i] & 0xFF;
            int total = val + 1;
            if (total > 255) {
                carry = true;
                total %= 256;
            } else if (total < 0) {
                carry = true;
            }
            incremented[i] = (byte)total;
            if (carry) continue;
            return incremented;
        }
        return incremented;
    }

    public class ColumnInfo {
        final String originalColumnName;
        final byte[] columnFamily;
        final byte[] columnName;
        final byte[] columnPrefix;

        public ColumnInfo(String colName) {
            this.originalColumnName = colName;
            String[] cfAndColumn = colName.split(HBaseStorage.COLON, 2);
            this.columnFamily = Bytes.toBytes((String)cfAndColumn[0]);
            if (cfAndColumn.length > 1 && cfAndColumn[1].length() > 0 && !HBaseStorage.ASTERISK.equals(cfAndColumn[1])) {
                if (cfAndColumn[1].endsWith(HBaseStorage.ASTERISK)) {
                    this.columnPrefix = Bytes.toBytes((String)cfAndColumn[1].substring(0, cfAndColumn[1].length() - 1));
                    this.columnName = null;
                } else {
                    this.columnName = Bytes.toBytes((String)cfAndColumn[1]);
                    this.columnPrefix = null;
                }
            } else {
                this.columnPrefix = null;
                this.columnName = null;
            }
        }

        public byte[] getColumnFamily() {
            return this.columnFamily;
        }

        public byte[] getColumnName() {
            return this.columnName;
        }

        public byte[] getColumnPrefix() {
            return this.columnPrefix;
        }

        public boolean isColumnMap() {
            return this.columnName == null;
        }

        public boolean hasPrefixMatch(byte[] qualifier) {
            return Bytes.startsWith((byte[])qualifier, (byte[])this.columnPrefix);
        }

        public String toString() {
            return this.originalColumnName;
        }
    }
}

