/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODemux;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMultiQueryPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPhysicalPlanPrinter<P extends OperatorPlan<PhysicalOperator>>
extends PhyPlanVisitor {
    private Document doc = null;
    private Element parent = null;

    public XMLPhysicalPlanPrinter(PhysicalPlan plan, Document doc, Element parent) {
        super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        this.doc = doc;
        this.parent = parent;
    }

    @Override
    public void visit() throws VisitorException {
        try {
            this.depthFirstPP(this.parent);
        }
        catch (IOException ioe) {
            int errCode = 2079;
            String msg = "Unexpected error while printing physical plan.";
            throw new VisitorException(msg, errCode, 4, (Throwable)ioe);
        }
    }

    public void print(OutputStream printer) throws VisitorException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(this.doc);
            transformer.transform(source, result);
            printer.write(sw.toString().getBytes("UTF-8"));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private Element createAlias(PhysicalOperator po) {
        Element aliasNode = null;
        String alias = po.getAlias();
        if (alias != null) {
            aliasNode = this.doc.createElement("alias");
            aliasNode.setTextContent(alias);
        }
        return aliasNode;
    }

    protected void depthFirstPP(Element parentNode) throws VisitorException {
        List leaves = ((PhysicalPlan)this.mPlan).getLeaves();
        Collections.sort(leaves);
        for (PhysicalOperator leaf : leaves) {
            this.depthFirst(leaf, parentNode);
        }
    }

    private void visitPlan(PhysicalPlan pp, Element parentNode) throws VisitorException {
        if (pp != null) {
            XMLPhysicalPlanPrinter<P> ppp = new XMLPhysicalPlanPrinter<P>(pp, this.doc, parentNode);
            ppp.visit();
        }
    }

    private void visitPlan(List<PhysicalPlan> lep, Element parentNode) throws VisitorException {
        if (lep != null) {
            for (PhysicalPlan ep : lep) {
                this.visitPlan(ep, parentNode);
            }
        }
    }

    private Element createPONode(PhysicalOperator node) {
        Element PONode = this.doc.createElement(node.getClass().getSimpleName());
        PONode.setAttribute("scope", "" + node.getOperatorKey().id);
        Element alias = this.createAlias(node);
        if (alias != null) {
            PONode.appendChild(alias);
        }
        if (node instanceof POStore) {
            Element storeFile = this.doc.createElement("storeFile");
            storeFile.setTextContent(((POStore)node).getSFile().getFileName());
            PONode.appendChild(storeFile);
            Element isTmpStore = this.doc.createElement("isTmpStore");
            isTmpStore.setTextContent(Boolean.valueOf(((POStore)node).isTmpStore()).toString());
            PONode.appendChild(isTmpStore);
        }
        if (node instanceof POLoad) {
            Element loadFile = this.doc.createElement("loadFile");
            loadFile.setTextContent(((POLoad)node).getLFile().getFileName());
            PONode.appendChild(loadFile);
            Element isTmpLoad = this.doc.createElement("isTmpLoad");
            isTmpLoad.setTextContent(Boolean.valueOf(((POLoad)node).isTmpLoad()).toString());
            PONode.appendChild(isTmpLoad);
        }
        return PONode;
    }

    private void depthFirst(PhysicalOperator node, Element parentNode) throws VisitorException {
        Object joinPlans;
        Element childNode = null;
        List<Object> subPlans = new ArrayList<PhysicalPlan>();
        if (node instanceof POFilter) {
            subPlans.add(((POFilter)node).getPlan());
        } else if (node instanceof POLocalRearrange) {
            subPlans = ((POLocalRearrange)node).getPlans();
        } else if (node instanceof POCollectedGroup) {
            subPlans = ((POCollectedGroup)node).getPlans();
        } else if (node instanceof POSort) {
            subPlans = ((POSort)node).getSortPlans();
        } else if (node instanceof POForEach) {
            subPlans = ((POForEach)node).getInputPlans();
        } else if (node instanceof POSplit) {
            subPlans = ((POSplit)node).getPlans();
        } else if (node instanceof PODemux) {
            subPlans = ((PODemux)node).getPlans();
        } else if (node instanceof POMultiQueryPackage) {
            childNode = this.createPONode(node);
            List<POPackage> pkgs = ((POMultiQueryPackage)node).getPackages();
            for (POPackage pkg : pkgs) {
                childNode.appendChild(this.createPONode(pkg));
            }
        } else if (node instanceof POFRJoin) {
            childNode = this.createPONode(node);
            POFRJoin frj = (POFRJoin)node;
            joinPlans = frj.getJoinPlans();
            if (joinPlans != null) {
                Iterator<Object> i$ = joinPlans.iterator();
                while (i$.hasNext()) {
                    List list = (List)i$.next();
                    this.visitPlan(list, childNode);
                }
            }
        } else if (node instanceof POSkewedJoin) {
            childNode = this.createPONode(node);
            POSkewedJoin skewed = (POSkewedJoin)node;
            joinPlans = skewed.getJoinPlans();
            if (joinPlans != null) {
                ArrayList<PhysicalPlan> inner_plans = new ArrayList<PhysicalPlan>();
                inner_plans.addAll(((MultiMap)joinPlans).values());
                this.visitPlan(inner_plans, childNode);
            }
        }
        if (childNode == null) {
            childNode = this.createPONode(node);
            if (subPlans.size() > 0) {
                this.visitPlan(subPlans, childNode);
            }
        }
        parentNode.appendChild(childNode);
        List<PhysicalOperator> originalPredecessors = ((PhysicalPlan)this.mPlan).getPredecessors(node);
        if (originalPredecessors == null) {
            return;
        }
        ArrayList<PhysicalOperator> predecessors = new ArrayList<PhysicalOperator>(originalPredecessors);
        Collections.sort(predecessors);
        for (PhysicalOperator pred : predecessors) {
            this.depthFirst(pred, childNode);
        }
    }
}

