/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigLogger;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public final class PigHadoopLogger
implements PigLogger {
    private static PigHadoopLogger instance = new PigHadoopLogger();
    private static Log log = LogFactory.getLog(PigHadoopLogger.class);
    private PigStatusReporter reporter = null;
    private boolean aggregate = false;

    public static synchronized PigHadoopLogger getInstance() {
        if (instance == null) {
            instance = new PigHadoopLogger();
        }
        return instance;
    }

    private PigHadoopLogger() {
    }

    public void warn(Object o, String msg, Enum warningEnum) {
        String displayMessage = o.getClass().getName() + ": " + msg;
        if (this.getAggregate()) {
            if (this.reporter != null) {
                this.reporter.getCounter(warningEnum).increment(1L);
            } else {
                log.warn((Object)displayMessage);
            }
        } else {
            log.warn((Object)displayMessage);
        }
    }

    public synchronized void setReporter(PigStatusReporter rep) {
        this.reporter = rep;
    }

    public synchronized boolean getAggregate() {
        return this.aggregate;
    }

    public synchronized void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }
}

