/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.finance;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gf", nsUri="http://schemas.google.com/finance/2007", localName="symbol")
public class Symbol
extends ExtensionPoint {
    static final String XML_NAME = "symbol";
    private static final String EXCHANGE = "exchange";
    private static final String FULLNAME = "fullName";
    private static final String SYMBOL = "symbol";
    private String exchange = null;
    private String fullName = null;
    private String symbol = null;

    public Symbol() {
    }

    public Symbol(String exchange, String fullName, String symbol) {
        this.setExchange(exchange);
        this.setFullName(fullName);
        this.setSymbol(symbol);
        this.setImmutable(true);
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.throwExceptionIfImmutable();
        this.exchange = exchange;
    }

    public boolean hasExchange() {
        return this.getExchange() != null;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.throwExceptionIfImmutable();
        this.fullName = fullName;
    }

    public boolean hasFullName() {
        return this.getFullName() != null;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.throwExceptionIfImmutable();
        this.symbol = symbol;
    }

    public boolean hasSymbol() {
        return this.getSymbol() != null;
    }

    protected void validate() {
        if (this.exchange == null) {
            Symbol.throwExceptionForMissingAttribute(EXCHANGE);
        }
        if (this.fullName == null) {
            Symbol.throwExceptionForMissingAttribute(FULLNAME);
        }
        if (this.symbol == null) {
            Symbol.throwExceptionForMissingAttribute("symbol");
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Symbol.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(EXCHANGE, this.exchange);
        generator.put(FULLNAME, this.fullName);
        generator.put("symbol", this.symbol);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.exchange = helper.consume(EXCHANGE, true);
        this.fullName = helper.consume(FULLNAME, true);
        this.symbol = helper.consume("symbol", true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Symbol other = (Symbol)obj;
        return Symbol.eq(this.exchange, other.exchange) && Symbol.eq(this.fullName, other.fullName) && Symbol.eq(this.symbol, other.symbol);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.exchange != null) {
            result = 37 * result + this.exchange.hashCode();
        }
        if (this.fullName != null) {
            result = 37 * result + this.fullName.hashCode();
        }
        if (this.symbol != null) {
            result = 37 * result + this.symbol.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Symbol exchange=" + this.exchange + " fullName=" + this.fullName + " symbol=" + this.symbol + "}";
    }
}

