/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.appsforyourdomain.adminsettings;

import com.google.gdata.client.appsforyourdomain.AppsPropertyService;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainException;
import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import com.google.gdata.data.appsforyourdomain.generic.GenericFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class EmailManagementService
extends AppsPropertyService {
    protected String domainUrlBase = null;
    protected String emailBaseUrl;

    public EmailManagementService(String domain, String applicationName) {
        super(applicationName);
        this.domainUrlBase = "https://apps-apis.google.com/a/feeds/domain/2.0/" + domain + "/";
        this.emailBaseUrl = this.domainUrlBase + "email/";
    }

    public EmailManagementService(String adminEmail, String password, String domain, String applicationName) throws AuthenticationException {
        this(domain, applicationName);
        this.setUserCredentials(adminEmail, password);
    }

    public boolean isUserMigrationEnabled() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL(this.emailBaseUrl + "migration"), GenericEntry.class).getProperty("enableUserMigration").equalsIgnoreCase("true");
    }

    public void setUserMigrationAccess(boolean enableUserMigration) throws AppsForYourDomainException, IOException, ServiceException {
        GenericEntry entry = new GenericEntry();
        entry.addProperty("enableUserMigration", String.valueOf(enableUserMigration));
        this.update(new URL(this.emailBaseUrl + "migration"), entry);
    }

    public GenericEntry retrieveOutboundGatewaySettings() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL(this.emailBaseUrl + "gateway"), GenericEntry.class);
    }

    public GenericEntry updateOutboundGatewaySettings(String smartHost, String smtpMode) throws AppsForYourDomainException, IOException, ServiceException {
        GenericEntry entry = new GenericEntry();
        entry.addProperty("smartHost", smartHost);
        entry.addProperty("smtpMode", smtpMode);
        return this.update(new URL(this.emailBaseUrl + "gateway"), entry);
    }

    public GenericFeed retrieveEmailRoutingSettings() throws AppsForYourDomainException, IOException, ServiceException {
        return this.getFeed(new URL(this.domainUrlBase + "emailrouting"), GenericFeed.class);
    }
}

