/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.KeyRange;

public class RegionSplitCalculator<R extends KeyRange> {
    static final Log LOG = LogFactory.getLog(RegionSplitCalculator.class);
    private final Comparator<R> rangeCmp;
    private final TreeSet<byte[]> splits = new TreeSet<byte[]>(BYTES_COMPARATOR);
    private final Multimap<byte[], R> starts = ArrayListMultimap.create();
    private static final byte[] ENDKEY = null;
    public static final Comparator<byte[]> BYTES_COMPARATOR = new Bytes.ByteArrayComparator(){

        @Override
        public int compare(byte[] l, byte[] r) {
            if (l == null && r == null) {
                return 0;
            }
            if (l == null) {
                return 1;
            }
            if (r == null) {
                return -1;
            }
            return super.compare(l, r);
        }
    };

    public RegionSplitCalculator(Comparator<R> cmp) {
        this.rangeCmp = cmp;
    }

    private static <R extends KeyRange> byte[] specialEndKey(R range) {
        byte[] end = range.getEndKey();
        if (end.length == 0) {
            return ENDKEY;
        }
        return end;
    }

    public boolean add(R range) {
        byte[] start = range.getStartKey();
        byte[] end = RegionSplitCalculator.specialEndKey(range);
        if (end != ENDKEY && Bytes.compareTo(start, end) > 0) {
            LOG.debug((Object)("attempted to add backwards edge: " + Bytes.toString(start) + " " + Bytes.toString(end)));
            return false;
        }
        this.splits.add(start);
        this.splits.add(end);
        this.starts.put((Object)start, range);
        return true;
    }

    public Multimap<byte[], R> calcCoverage() {
        TreeMultimap regions = TreeMultimap.create(BYTES_COMPARATOR, this.rangeCmp);
        for (Map.Entry start : this.starts.asMap().entrySet()) {
            byte[] key = (byte[])start.getKey();
            for (KeyRange r : (Collection)start.getValue()) {
                regions.put((Object)key, (Object)r);
                for (byte[] coveredSplit : this.splits.subSet(r.getStartKey(), RegionSplitCalculator.specialEndKey(r))) {
                    regions.put((Object)coveredSplit, (Object)r);
                }
            }
        }
        return regions;
    }

    public TreeSet<byte[]> getSplits() {
        return this.splits;
    }

    public Multimap<byte[], R> getStarts() {
        return this.starts;
    }

    public static <R extends KeyRange> List<R> findBigRanges(Collection<R> bigOverlap, int count) {
        ArrayList bigRanges = new ArrayList();
        TreeMap<Integer, ArrayList<KeyRange>> overlapRangeMap = new TreeMap<Integer, ArrayList<KeyRange>>();
        for (KeyRange r : bigOverlap) {
            byte[] startKey = r.getStartKey();
            byte[] endKey = RegionSplitCalculator.specialEndKey(r);
            int overlappedRegions = 0;
            for (KeyRange rr : bigOverlap) {
                byte[] start = rr.getStartKey();
                byte[] end = RegionSplitCalculator.specialEndKey(rr);
                if (BYTES_COMPARATOR.compare(startKey, end) >= 0 || BYTES_COMPARATOR.compare(endKey, start) <= 0) continue;
                ++overlappedRegions;
            }
            if (overlappedRegions <= true) continue;
            Integer key = overlappedRegions;
            ArrayList<KeyRange> ranges = (ArrayList<KeyRange>)overlapRangeMap.get(key);
            if (ranges == null) {
                ranges = new ArrayList<KeyRange>();
                overlapRangeMap.put(key, ranges);
            }
            ranges.add(r);
        }
        int toBeAdded = count;
        for (Integer key : overlapRangeMap.descendingKeySet()) {
            List chunk = (List)overlapRangeMap.get(key);
            int chunkSize = chunk.size();
            if (chunkSize <= toBeAdded) {
                bigRanges.addAll(chunk);
                if ((toBeAdded -= chunkSize) <= 0) break;
                continue;
            }
            int start = (chunkSize - toBeAdded) / 2;
            int end = start + toBeAdded;
            for (int i = start; i < end; ++i) {
                bigRanges.add(chunk.get(i));
            }
        }
        return bigRanges;
    }
}

