/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.io.WritableWithSize;
import org.apache.hadoop.hbase.ipc.CallerDisconnectedException;
import org.apache.hadoop.hbase.ipc.ConnectionHeader;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.HBaseRpcMetrics;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.ipc.ResponseFlag;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.ipc.Status;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.ByteBufferOutputStream;
import org.apache.hadoop.hbase.util.SizeBasedThrottler;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.cliffc.high_scale_lib.Counter;

public abstract class HBaseServer
implements RpcServer {
    public static final ByteBuffer HEADER = ByteBuffer.wrap("hrpc".getBytes());
    public static final byte CURRENT_VERSION = 3;
    private static final int DEFAULT_MAX_CALLQUEUE_LENGTH_PER_HANDLER = 10;
    private static final int DEFAULT_MAX_CALLQUEUE_SIZE = 0x40000000;
    static final int BUFFER_INITIAL_SIZE = 1024;
    private static final String WARN_DELAYED_CALLS = "hbase.ipc.warn.delayedrpc.number";
    private static final int DEFAULT_WARN_DELAYED_CALLS = 1000;
    private final int warnDelayedCalls;
    private AtomicInteger delayedCalls;
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.HBaseServer");
    protected static final Log TRACELOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.HBaseServer.trace");
    protected static final ThreadLocal<RpcServer> SERVER = new ThreadLocal();
    private volatile boolean started = false;
    private static final Map<String, Class<? extends VersionedProtocol>> PROTOCOL_CACHE = new ConcurrentHashMap<String, Class<? extends VersionedProtocol>>();
    protected static final ThreadLocal<Call> CurCall = new ThreadLocal();
    protected String bindAddress;
    protected int port;
    private int handlerCount;
    private int priorityHandlerCount;
    private int readThreads;
    protected Class<? extends Writable> paramClass;
    protected int maxIdleTime;
    protected int thresholdIdleConnections;
    int maxConnectionsToNuke;
    protected HBaseRpcMetrics rpcMetrics;
    protected Configuration conf;
    private int maxQueueLength;
    private int maxQueueSize;
    protected int socketSendBufferSize;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected final long purgeTimeout;
    final SizeBasedThrottler responseQueuesSizeThrottler;
    private static final long DEFAULT_RESPONSE_QUEUES_MAX_SIZE = 0x40000000L;
    private static final String RESPONSE_QUEUES_MAX_SIZE = "ipc.server.response.queue.maxsize";
    protected volatile boolean running = true;
    protected BlockingQueue<Call> callQueue;
    protected final Counter callQueueSize = new Counter();
    protected BlockingQueue<Call> priorityCallQueue;
    protected int highPriorityLevel;
    protected final List<Connection> connectionList = Collections.synchronizedList(new LinkedList());
    private Listener listener = null;
    protected Responder responder = null;
    protected int numConnections = 0;
    private Handler[] handlers = null;
    private Handler[] priorityHandlers = null;
    protected BlockingQueue<Call> replicationQueue;
    private int numOfReplicationHandlers = 0;
    private Handler[] replicationHandlers = null;
    protected HBaseRPCErrorHandler errorHandler = null;
    private Function<Writable, Integer> qosFunction = null;
    private static int NIO_BUFFER_LIMIT = 65536;

    static Class<? extends VersionedProtocol> getProtocolClass(String protocolName, Configuration conf) throws ClassNotFoundException {
        Class protocol = PROTOCOL_CACHE.get(protocolName);
        if (protocol == null) {
            protocol = conf.getClassByName(protocolName);
            PROTOCOL_CACHE.put(protocolName, protocol);
        }
        return protocol;
    }

    public static RpcServer get() {
        return SERVER.get();
    }

    public static InetAddress getRemoteIp() {
        Call call = CurCall.get();
        if (call != null) {
            return call.connection.socket.getInetAddress();
        }
        return null;
    }

    public static String getRemoteAddress() {
        Call call = CurCall.get();
        if (call != null) {
            return call.connection.getHostAddress();
        }
        return null;
    }

    public static void bind(ServerSocket socket, InetSocketAddress address, int backlog) throws IOException {
        try {
            socket.bind(address, backlog);
        }
        catch (BindException e) {
            BindException bindException = new BindException("Problem binding to " + address + " : " + e.getMessage());
            bindException.initCause(e);
            throw bindException;
        }
        catch (SocketException e) {
            if ("Unresolved address".equals(e.getMessage())) {
                throw new UnknownHostException("Invalid hostname for server: " + address.getHostName());
            }
            throw e;
        }
    }

    protected void updateCallQueueLenMetrics(BlockingQueue<Call> queue) {
        if (queue == this.callQueue) {
            this.rpcMetrics.callQueueLen.set(this.callQueue.size());
        } else if (queue == this.priorityCallQueue) {
            this.rpcMetrics.priorityCallQueueLen.set(this.priorityCallQueue.size());
        } else if (queue == this.replicationQueue) {
            this.rpcMetrics.replicationCallQueueLen.set(this.replicationQueue.size());
        } else {
            LOG.warn((Object)"Unknown call queue");
        }
    }

    @Override
    public void setQosFunction(Function<Writable, Integer> newFunc) {
        this.qosFunction = newFunc;
    }

    protected int getQosLevel(Writable param) {
        if (this.qosFunction == null) {
            return 0;
        }
        Integer res = (Integer)this.qosFunction.apply((Object)param);
        if (res == null) {
            return 0;
        }
        return res;
    }

    protected HBaseServer(String bindAddress, int port, Class<? extends Writable> paramClass, int handlerCount, int priorityHandlerCount, Configuration conf, String serverName, int highPriorityLevel) throws IOException {
        this.bindAddress = bindAddress;
        this.conf = conf;
        this.port = port;
        this.paramClass = paramClass;
        this.handlerCount = handlerCount;
        this.priorityHandlerCount = priorityHandlerCount;
        this.socketSendBufferSize = 0;
        String oldMaxQueueSize = this.conf.get("ipc.server.max.queue.size");
        if (oldMaxQueueSize == null) {
            this.maxQueueLength = this.conf.getInt("ipc.server.max.callqueue.length", handlerCount * 10);
        } else {
            LOG.warn((Object)"ipc.server.max.queue.size was renamed ipc.server.max.callqueue.length, please update your configuration");
            this.maxQueueLength = Integer.getInteger(oldMaxQueueSize);
        }
        this.maxQueueSize = this.conf.getInt("ipc.server.max.callqueue.size", 0x40000000);
        this.readThreads = conf.getInt("ipc.server.read.threadpool.size", 10);
        this.callQueue = new LinkedBlockingQueue<Call>(this.maxQueueLength);
        this.priorityCallQueue = priorityHandlerCount > 0 ? new LinkedBlockingQueue<Call>(this.maxQueueLength) : null;
        this.highPriorityLevel = highPriorityLevel;
        this.maxIdleTime = 2 * conf.getInt("ipc.client.connection.maxidletime", 1000);
        this.maxConnectionsToNuke = conf.getInt("ipc.client.kill.max", 10);
        this.thresholdIdleConnections = conf.getInt("ipc.client.idlethreshold", 4000);
        this.purgeTimeout = conf.getLong("ipc.client.call.purge.timeout", (long)(2 * HConstants.DEFAULT_HBASE_RPC_TIMEOUT));
        this.numOfReplicationHandlers = conf.getInt("hbase.regionserver.replication.handler.count", 3);
        if (this.numOfReplicationHandlers > 0) {
            this.replicationQueue = new LinkedBlockingQueue<Call>(this.maxQueueLength);
        }
        this.listener = new Listener();
        this.port = this.listener.getAddress().getPort();
        this.rpcMetrics = new HBaseRpcMetrics(serverName, Integer.toString(this.port));
        this.tcpNoDelay = conf.getBoolean("ipc.server.tcpnodelay", false);
        this.tcpKeepAlive = conf.getBoolean("ipc.server.tcpkeepalive", true);
        this.warnDelayedCalls = conf.getInt(WARN_DELAYED_CALLS, 1000);
        this.delayedCalls = new AtomicInteger(0);
        this.responseQueuesSizeThrottler = new SizeBasedThrottler(conf.getLong(RESPONSE_QUEUES_MAX_SIZE, 0x40000000L));
        this.responder = new Responder();
    }

    protected Connection getConnection(SocketChannel channel, long time) {
        return new Connection(channel, time);
    }

    private void setupResponse(ByteArrayOutputStream response, Call call, Status status, Writable rv, String errorClass, String error) throws IOException {
        response.reset();
        DataOutputStream out = new DataOutputStream(response);
        if (status == Status.SUCCESS) {
            try {
                rv.write((DataOutput)out);
                call.setResponse(rv, status, null, null);
            }
            catch (Throwable t) {
                LOG.warn((Object)("Error serializing call response for call " + call), t);
                call.setResponse(null, Status.ERROR, t.getClass().getName(), StringUtils.stringifyException((Throwable)t));
            }
        } else {
            call.setResponse(rv, status, errorClass, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(Connection connection) {
        List<Connection> list = this.connectionList;
        synchronized (list) {
            if (this.connectionList.remove(connection)) {
                --this.numConnections;
            }
        }
        connection.close();
        long bytes = 0L;
        LinkedList<Call> linkedList = connection.responseQueue;
        synchronized (linkedList) {
            for (Call c : connection.responseQueue) {
                bytes += (long)c.response.limit();
            }
            connection.responseQueue.clear();
        }
        this.responseQueuesSizeThrottler.decrease(bytes);
        this.rpcMetrics.numOpenConnections.set(this.numConnections);
    }

    @Override
    public void setSocketSendBufSize(int size) {
        this.socketSendBufferSize = size;
    }

    @Override
    public void start() {
        this.startThreads();
        this.openServer();
    }

    @Override
    public void openServer() {
        this.started = true;
    }

    @Override
    public synchronized void startThreads() {
        this.responder.start();
        this.listener.start();
        this.handlers = this.startHandlers(this.callQueue, this.handlerCount);
        this.priorityHandlers = this.startHandlers(this.priorityCallQueue, this.priorityHandlerCount);
        this.replicationHandlers = this.startHandlers(this.replicationQueue, this.numOfReplicationHandlers);
    }

    private Handler[] startHandlers(BlockingQueue<Call> queue, int numOfHandlers) {
        if (numOfHandlers <= 0) {
            return null;
        }
        Handler[] handlers = new Handler[numOfHandlers];
        for (int i = 0; i < numOfHandlers; ++i) {
            handlers[i] = new Handler(queue, i);
            handlers[i].start();
        }
        return handlers;
    }

    @Override
    public synchronized void stop() {
        LOG.info((Object)("Stopping server on " + this.port));
        this.running = false;
        this.stopHandlers(this.handlers);
        this.stopHandlers(this.priorityHandlers);
        this.stopHandlers(this.replicationHandlers);
        this.listener.interrupt();
        this.listener.doStop();
        this.responder.interrupt();
        this.notifyAll();
        if (this.rpcMetrics != null) {
            this.rpcMetrics.shutdown();
        }
    }

    private void stopHandlers(Handler[] handlers) {
        if (handlers != null) {
            for (Handler handler : handlers) {
                if (handler == null) continue;
                handler.interrupt();
            }
        }
    }

    @Override
    public synchronized void join() throws InterruptedException {
        while (this.running) {
            this.wait();
        }
    }

    @Override
    public synchronized InetSocketAddress getListenerAddress() {
        return this.listener.getAddress();
    }

    @Override
    public void setErrorHandler(HBaseRPCErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public HBaseRpcMetrics getRpcMetrics() {
        return this.rpcMetrics;
    }

    protected int channelWrite(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        int count;
        int n = count = buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.write(buffer) : HBaseServer.channelIO(null, channel, buffer);
        if (count > 0) {
            this.rpcMetrics.sentBytes.inc((long)count);
        }
        return count;
    }

    protected int channelRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int count;
        int n = count = buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.read(buffer) : HBaseServer.channelIO(channel, null, buffer);
        if (count > 0) {
            this.rpcMetrics.receivedBytes.inc((long)count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int channelIO(ReadableByteChannel readCh, WritableByteChannel writeCh, ByteBuffer buf) throws IOException {
        int nBytes;
        int originalLimit = buf.limit();
        int initialRemaining = buf.remaining();
        int ret = 0;
        while (buf.remaining() > 0) {
            try {
                int ioSize = Math.min(buf.remaining(), NIO_BUFFER_LIMIT);
                buf.limit(buf.position() + ioSize);
                ret = readCh == null ? writeCh.write(buf) : readCh.read(buf);
                if (ret >= ioSize) continue;
                break;
            }
            finally {
                buf.limit(originalLimit);
            }
        }
        return (nBytes = initialRemaining - buf.remaining()) > 0 ? nBytes : ret;
    }

    public static RpcCallContext getCurrentCall() {
        return CurCall.get();
    }

    public long getResponseQueueSize() {
        return this.responseQueuesSizeThrottler.getCurrentValue();
    }

    private class Handler
    extends Thread {
        private final BlockingQueue<Call> myCallQueue;
        private MonitoredRPCHandler status;

        public Handler(BlockingQueue<Call> cq, int instanceNumber) {
            this.myCallQueue = cq;
            this.setDaemon(true);
            String threadName = "IPC Server handler " + instanceNumber + " on " + HBaseServer.this.port;
            if (cq == HBaseServer.this.priorityCallQueue) {
                threadName = "PRI " + threadName;
            } else if (cq == HBaseServer.this.replicationQueue) {
                threadName = "REPL " + threadName;
            }
            this.setName(threadName);
            this.status = TaskMonitor.get().createRPCStatus(threadName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            this.status.setStatus("starting");
            SERVER.set(HBaseServer.this);
            while (HBaseServer.this.running) {
                try {
                    this.status.pause("Waiting for a call");
                    Call call = this.myCallQueue.take();
                    HBaseServer.this.updateCallQueueLenMetrics(this.myCallQueue);
                    this.status.setStatus("Setting up call");
                    this.status.setConnection(call.connection.getHostAddress(), call.connection.getRemotePort());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": has #" + call.id + " from " + call.connection));
                    }
                    String errorClass = null;
                    String error = null;
                    Writable value = null;
                    CurCall.set(call);
                    try {
                        if (!HBaseServer.this.started) {
                            throw new ServerNotRunningYetException("Server is not running yet");
                        }
                        if (LOG.isDebugEnabled()) {
                            User remoteUser = call.connection.ticket;
                            LOG.debug((Object)(this.getName() + ": call #" + call.id + " executing as " + (remoteUser == null ? "NULL principal" : remoteUser.getName())));
                        }
                        RequestContext.set(call.connection.ticket, HBaseServer.getRemoteIp(), call.connection.protocol);
                        value = HBaseServer.this.call(call.connection.protocol, call.param, call.timestamp, this.status);
                    }
                    catch (Throwable e) {
                        LOG.debug((Object)(this.getName() + ", call " + call + ": error: " + e), e);
                        errorClass = e.getClass().getName();
                        error = StringUtils.stringifyException((Throwable)e);
                    }
                    finally {
                        RequestContext.clear();
                    }
                    CurCall.set(null);
                    HBaseServer.this.callQueueSize.add(call.getSize() * -1L);
                    if (!call.isDelayed() || !call.isReturnValueDelayed()) {
                        call.setResponse(value, errorClass == null ? Status.SUCCESS : Status.ERROR, errorClass, error);
                    }
                    call.sendResponseIfReady();
                    this.status.markComplete("Sent response");
                }
                catch (InterruptedException e) {
                    if (!HBaseServer.this.running) continue;
                    LOG.info((Object)(this.getName() + " caught: " + StringUtils.stringifyException((Throwable)e)));
                }
                catch (OutOfMemoryError e) {
                    if (HBaseServer.this.errorHandler != null) {
                        if (!HBaseServer.this.errorHandler.checkOOME(e)) continue;
                        LOG.info((Object)(this.getName() + ": exiting on OOME"));
                        return;
                    }
                    throw e;
                }
                catch (ClosedChannelException cce) {
                    LOG.warn((Object)(this.getName() + " caught a ClosedChannelException, " + "this means that the server was processing a " + "request but the client went away. The error message was: " + cce.getMessage()));
                }
                catch (Exception e) {
                    LOG.warn((Object)(this.getName() + " caught: " + StringUtils.stringifyException((Throwable)e)));
                }
            }
            LOG.info((Object)(this.getName() + ": exiting"));
        }
    }

    protected class Connection {
        private boolean versionRead = false;
        private boolean headerRead = false;
        protected volatile boolean closed = false;
        protected SocketChannel channel;
        private ByteBuffer data;
        private ByteBuffer dataLengthBuffer;
        protected final LinkedList<Call> responseQueue;
        private volatile int rpcCount = 0;
        private long lastContact;
        private int dataLength;
        protected Socket socket;
        protected String hostAddress;
        protected int remotePort;
        ConnectionHeader header = new ConnectionHeader();
        Class<? extends VersionedProtocol> protocol;
        protected User ticket = null;

        public Connection(SocketChannel channel, long lastContact) {
            this.channel = channel;
            this.lastContact = lastContact;
            this.data = null;
            this.dataLengthBuffer = ByteBuffer.allocate(4);
            this.socket = channel.socket();
            InetAddress addr = this.socket.getInetAddress();
            this.hostAddress = addr == null ? "*Unknown*" : addr.getHostAddress();
            this.remotePort = this.socket.getPort();
            this.responseQueue = new LinkedList();
            if (HBaseServer.this.socketSendBufferSize != 0) {
                try {
                    this.socket.setSendBufferSize(HBaseServer.this.socketSendBufferSize);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Connection: unable to set socket send buffer size to " + HBaseServer.this.socketSendBufferSize));
                }
            }
        }

        public String toString() {
            return this.getHostAddress() + ":" + this.remotePort;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public int getRemotePort() {
            return this.remotePort;
        }

        public void setLastContact(long lastContact) {
            this.lastContact = lastContact;
        }

        public long getLastContact() {
            return this.lastContact;
        }

        private boolean isIdle() {
            return this.rpcCount == 0;
        }

        protected void decRpcCount() {
            --this.rpcCount;
        }

        protected void incRpcCount() {
            ++this.rpcCount;
        }

        protected boolean timedOut(long currentTime) {
            return this.isIdle() && currentTime - this.lastContact > (long)HBaseServer.this.maxIdleTime;
        }

        public int readAndProcess() throws IOException, InterruptedException {
            int count;
            while (true) {
                if (this.dataLengthBuffer.remaining() > 0 && ((count = HBaseServer.this.channelRead(this.channel, this.dataLengthBuffer)) < 0 || this.dataLengthBuffer.remaining() > 0)) {
                    return count;
                }
                if (!this.versionRead) {
                    ByteBuffer versionBuffer = ByteBuffer.allocate(1);
                    count = HBaseServer.this.channelRead(this.channel, versionBuffer);
                    if (count <= 0) {
                        return count;
                    }
                    byte version = versionBuffer.get(0);
                    this.dataLengthBuffer.flip();
                    if (!HEADER.equals(this.dataLengthBuffer) || version != 3) {
                        LOG.warn((Object)("Incorrect header or version mismatch from " + this.hostAddress + ":" + this.remotePort + " got version " + version + " expected version " + 3));
                        this.setupBadVersionResponse(version);
                        return -1;
                    }
                    this.dataLengthBuffer.clear();
                    this.versionRead = true;
                    continue;
                }
                if (this.data == null) {
                    this.dataLengthBuffer.flip();
                    this.dataLength = this.dataLengthBuffer.getInt();
                    if (this.dataLength == -1) {
                        this.dataLengthBuffer.clear();
                        return 0;
                    }
                    this.data = ByteBuffer.allocate(this.dataLength);
                    this.incRpcCount();
                }
                count = HBaseServer.this.channelRead(this.channel, this.data);
                if (this.data.remaining() != 0) break;
                this.dataLengthBuffer.clear();
                this.data.flip();
                if (this.headerRead) {
                    this.processData(this.data.array());
                    this.data = null;
                    return count;
                }
                this.processHeader();
                this.headerRead = true;
                this.data = null;
            }
            return count;
        }

        private void setupBadVersionResponse(int clientVersion) throws IOException {
            String errMsg = "Server IPC version 3 cannot communicate with client version " + clientVersion;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            if (clientVersion >= 3) {
                Call fakeCall = new Call(0, null, this, HBaseServer.this.responder, 0L);
                HBaseServer.this.setupResponse(buffer, fakeCall, Status.FATAL, null, RPC.VersionMismatch.class.getName(), errMsg);
                HBaseServer.this.responder.doRespond(fakeCall);
            }
        }

        private void processHeader() throws IOException {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data.array()));
            this.header.readFields(in);
            try {
                String protocolClassName = this.header.getProtocol();
                if (protocolClassName == null) {
                    protocolClassName = "org.apache.hadoop.hbase.ipc.HRegionInterface";
                }
                this.protocol = HBaseServer.getProtocolClass(protocolClassName, HBaseServer.this.conf);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("Unknown protocol: " + this.header.getProtocol());
            }
            this.ticket = this.header.getUser();
        }

        protected void processData(byte[] buf) throws IOException, InterruptedException {
            Writable param;
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
            int id = dis.readInt();
            long callSize = buf.length;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" got call #" + id + ", " + callSize + " bytes"));
            }
            if (callSize + HBaseServer.this.callQueueSize.get() > (long)HBaseServer.this.maxQueueSize) {
                Call callTooBig = new Call(id, null, this, HBaseServer.this.responder, callSize);
                ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream();
                HBaseServer.this.setupResponse(responseBuffer, callTooBig, Status.FATAL, null, IOException.class.getName(), "Call queue is full, is ipc.server.max.callqueue.size too small?");
                HBaseServer.this.responder.doRespond(callTooBig);
                return;
            }
            try {
                param = (Writable)ReflectionUtils.newInstance(HBaseServer.this.paramClass, (Configuration)HBaseServer.this.conf);
                param.readFields((DataInput)dis);
            }
            catch (Throwable t) {
                LOG.warn((Object)("Unable to read call parameters for client " + this.getHostAddress()), t);
                Call readParamsFailedCall = new Call(id, null, this, HBaseServer.this.responder, callSize);
                ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream();
                HBaseServer.this.setupResponse(responseBuffer, readParamsFailedCall, Status.FATAL, null, t.getClass().getName(), "IPC server unable to read call parameters: " + t.getMessage());
                HBaseServer.this.responder.doRespond(readParamsFailedCall);
                return;
            }
            Call call = new Call(id, param, this, HBaseServer.this.responder, callSize);
            HBaseServer.this.callQueueSize.add(callSize);
            if (HBaseServer.this.priorityCallQueue != null && HBaseServer.this.getQosLevel(param) > HBaseServer.this.highPriorityLevel) {
                HBaseServer.this.priorityCallQueue.put(call);
                HBaseServer.this.updateCallQueueLenMetrics(HBaseServer.this.priorityCallQueue);
            } else if (HBaseServer.this.replicationQueue != null && HBaseServer.this.getQosLevel(param) == 5) {
                HBaseServer.this.replicationQueue.put(call);
                HBaseServer.this.updateCallQueueLenMetrics(HBaseServer.this.replicationQueue);
            } else {
                HBaseServer.this.callQueue.put(call);
                HBaseServer.this.updateCallQueueLenMetrics(HBaseServer.this.callQueue);
            }
        }

        protected synchronized void close() {
            this.closed = true;
            this.data = null;
            this.dataLengthBuffer = null;
            if (!this.channel.isOpen()) {
                return;
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class Responder
    extends Thread {
        private final Selector writeSelector;
        private int pending;

        Responder() throws IOException {
            this.setName("IPC Server Responder");
            this.setDaemon(true);
            this.writeSelector = Selector.open();
            this.pending = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(HBaseServer.this);
            try {
                this.doRunLoop();
            }
            finally {
                LOG.info((Object)("Stopping " + this.getName()));
                try {
                    this.writeSelector.close();
                }
                catch (IOException ioe) {
                    LOG.error((Object)("Couldn't close write selector in " + this.getName()), (Throwable)ioe);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRunLoop() {
            long lastPurgeTime = 0L;
            while (HBaseServer.this.running) {
                try {
                    ArrayList<Call> calls;
                    this.waitPending();
                    this.writeSelector.select(HBaseServer.this.purgeTimeout);
                    Iterator<SelectionKey> iter = this.writeSelector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = iter.next();
                        iter.remove();
                        try {
                            if (!key.isValid() || !key.isWritable()) continue;
                            this.doAsyncWrite(key);
                        }
                        catch (IOException e) {
                            LOG.info((Object)(this.getName() + ": doAsyncWrite threw exception " + e));
                        }
                    }
                    long now = System.currentTimeMillis();
                    if (now < lastPurgeTime + HBaseServer.this.purgeTimeout) continue;
                    lastPurgeTime = now;
                    LOG.debug((Object)"Checking for old call responses.");
                    Set<SelectionKey> set = this.writeSelector.keys();
                    synchronized (set) {
                        calls = new ArrayList<Call>(this.writeSelector.keys().size());
                        for (SelectionKey key : this.writeSelector.keys()) {
                            Call call = (Call)key.attachment();
                            if (call == null || key.channel() != call.connection.channel) continue;
                            calls.add(call);
                        }
                    }
                    for (Call call : calls) {
                        try {
                            this.doPurge(call, now);
                        }
                        catch (IOException e) {
                            LOG.warn((Object)("Error in purging old calls " + e));
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    if (HBaseServer.this.errorHandler != null) {
                        if (!HBaseServer.this.errorHandler.checkOOME(e)) continue;
                        LOG.info((Object)(this.getName() + ": exiting on OOME"));
                        return;
                    }
                    LOG.warn((Object)"Out of Memory in server select", (Throwable)e);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception ignored) {}
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception in Responder " + StringUtils.stringifyException((Throwable)e)));
                }
            }
            LOG.info((Object)("Stopping " + this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAsyncWrite(SelectionKey key) throws IOException {
            Call call = (Call)key.attachment();
            if (call == null) {
                return;
            }
            if (key.channel() != call.connection.channel) {
                throw new IOException("doAsyncWrite: bad channel");
            }
            LinkedList<Call> linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                if (this.processResponse(call.connection.responseQueue, false)) {
                    try {
                        key.interestOps(0);
                    }
                    catch (CancelledKeyException e) {
                        LOG.warn((Object)("Exception while changing ops : " + e));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPurge(Call call, long now) throws IOException {
            LinkedList<Call> linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                ListIterator<Call> iter = call.connection.responseQueue.listIterator(0);
                while (iter.hasNext()) {
                    Call nextCall = (Call)iter.next();
                    if (now <= nextCall.timestamp + HBaseServer.this.purgeTimeout) continue;
                    HBaseServer.this.closeConnection(nextCall.connection);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private boolean processResponse(LinkedList<Call> responseQueue, boolean inHandler) throws IOException {
            int numBytes;
            int numElements;
            Call call;
            boolean done;
            boolean error;
            block17: {
                error = true;
                done = false;
                call = null;
                LinkedList<Call> linkedList = responseQueue;
                // MONITORENTER : linkedList
                numElements = responseQueue.size();
                if (numElements != 0) break block17;
                error = false;
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                done = true;
                HBaseServer.this.closeConnection(call.connection);
                return bl;
            }
            call = responseQueue.peek();
            SocketChannel channel = call.connection.channel;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection));
            }
            if ((numBytes = HBaseServer.this.channelWrite(channel, call.response)) < 0) {
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                done = true;
                HBaseServer.this.closeConnection(call.connection);
                return bl;
            }
            try {
                if (!call.response.hasRemaining()) {
                    responseQueue.poll();
                    HBaseServer.this.responseQueuesSizeThrottler.decrease(call.response.limit());
                    call.connection.decRpcCount();
                    done = numElements == 1;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection + " Wrote " + numBytes + " bytes."));
                    }
                } else {
                    if (inHandler) {
                        call.timestamp = System.currentTimeMillis();
                        if (this.enqueueInSelector(call)) {
                            done = true;
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection + " Wrote partial " + numBytes + " bytes."));
                    }
                }
                error = false;
                // MONITOREXIT : linkedList
                return done;
            }
            finally {
                if (error && call != null) {
                    LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                    done = true;
                    HBaseServer.this.closeConnection(call.connection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean enqueueInSelector(Call call) throws IOException {
            boolean done = false;
            this.incPending();
            try {
                SocketChannel channel = call.connection.channel;
                this.writeSelector.wakeup();
                channel.register(this.writeSelector, 4, call);
            }
            catch (ClosedChannelException e) {
                done = true;
            }
            finally {
                this.decPending();
            }
            return done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRespond(Call call) throws IOException {
            boolean closed;
            call.timestamp = System.currentTimeMillis();
            boolean doRegister = false;
            try {
                HBaseServer.this.responseQueuesSizeThrottler.increase(call.response.remaining());
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException(ie.getMessage());
            }
            LinkedList<Call> linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                closed = call.connection.closed;
                if (!closed) {
                    call.connection.responseQueue.addLast(call);
                    if (call.connection.responseQueue.size() == 1) {
                        doRegister = !this.processResponse(call.connection.responseQueue, false);
                    }
                }
            }
            if (doRegister) {
                this.enqueueInSelector(call);
            }
            if (closed) {
                HBaseServer.this.responseQueuesSizeThrottler.decrease(call.response.remaining());
            }
        }

        private synchronized void incPending() {
            ++this.pending;
        }

        private synchronized void decPending() {
            --this.pending;
            this.notify();
        }

        private synchronized void waitPending() throws InterruptedException {
            while (this.pending > 0) {
                this.wait();
            }
        }
    }

    private class Listener
    extends Thread {
        private ServerSocketChannel acceptChannel = null;
        private Selector selector = null;
        private Reader[] readers = null;
        private int currentReader = 0;
        private InetSocketAddress address;
        private Random rand = new Random();
        private long lastCleanupRunTime = 0L;
        private long cleanupInterval = 10000L;
        private int backlogLength;
        private ExecutorService readPool;

        public Listener() throws IOException {
            this.backlogLength = HBaseServer.this.conf.getInt("ipc.server.listen.queue.size", 128);
            this.address = new InetSocketAddress(HBaseServer.this.bindAddress, HBaseServer.this.port);
            this.acceptChannel = ServerSocketChannel.open();
            this.acceptChannel.configureBlocking(false);
            HBaseServer.bind(this.acceptChannel.socket(), this.address, this.backlogLength);
            HBaseServer.this.port = this.acceptChannel.socket().getLocalPort();
            this.selector = Selector.open();
            this.readers = new Reader[HBaseServer.this.readThreads];
            this.readPool = Executors.newFixedThreadPool(HBaseServer.this.readThreads, new ThreadFactoryBuilder().setNameFormat("IPC Reader %d on port " + HBaseServer.this.port).setDaemon(true).build());
            for (int i = 0; i < HBaseServer.this.readThreads; ++i) {
                Reader reader;
                this.readers[i] = reader = new Reader();
                this.readPool.execute(reader);
            }
            this.acceptChannel.register(this.selector, 16);
            this.setName("IPC Server listener on " + HBaseServer.this.port);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupConnections(boolean force) {
            if (force || HBaseServer.this.numConnections > HBaseServer.this.thresholdIdleConnections) {
                long currentTime = System.currentTimeMillis();
                if (!force && currentTime - this.lastCleanupRunTime < this.cleanupInterval) {
                    return;
                }
                int start = 0;
                int end = HBaseServer.this.numConnections - 1;
                if (!force) {
                    start = this.rand.nextInt() % HBaseServer.this.numConnections;
                    end = this.rand.nextInt() % HBaseServer.this.numConnections;
                    if (end < start) {
                        int temp = start;
                        start = end;
                        end = temp;
                    }
                }
                int i = start;
                int numNuked = 0;
                while (i <= end) {
                    Connection c;
                    List<Connection> list = HBaseServer.this.connectionList;
                    synchronized (list) {
                        try {
                            c = HBaseServer.this.connectionList.get(i);
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    if (c.timedOut(currentTime)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress()));
                        }
                        HBaseServer.this.closeConnection(c);
                        --end;
                        c = null;
                        if (force || ++numNuked != HBaseServer.this.maxConnectionsToNuke) continue;
                        break;
                    }
                    ++i;
                }
                this.lastCleanupRunTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(HBaseServer.this);
            while (HBaseServer.this.running) {
                SelectionKey key = null;
                try {
                    this.selector.select();
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        key = iter.next();
                        iter.remove();
                        try {
                            if (key.isValid() && key.isAcceptable()) {
                                this.doAccept(key);
                            }
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        key = null;
                    }
                }
                catch (OutOfMemoryError e) {
                    if (HBaseServer.this.errorHandler != null) {
                        if (HBaseServer.this.errorHandler.checkOOME(e)) {
                            LOG.info((Object)(this.getName() + ": exiting on OOME"));
                            this.closeCurrentConnection(key, e);
                            this.cleanupConnections(true);
                            return;
                        }
                    } else {
                        LOG.warn((Object)"Out of Memory in server select", (Throwable)e);
                        this.closeCurrentConnection(key, e);
                        this.cleanupConnections(true);
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    this.closeCurrentConnection(key, e);
                }
                this.cleanupConnections(false);
            }
            LOG.info((Object)("Stopping " + this.getName()));
            Listener listener = this;
            synchronized (listener) {
                try {
                    this.acceptChannel.close();
                    this.selector.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.selector = null;
                this.acceptChannel = null;
                while (!HBaseServer.this.connectionList.isEmpty()) {
                    HBaseServer.this.closeConnection(HBaseServer.this.connectionList.remove(0));
                }
            }
        }

        private void closeCurrentConnection(SelectionKey key, Throwable e) {
            Connection c;
            if (key != null && (c = (Connection)key.attachment()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress() + (e != null ? " on error " + e.getMessage() : "")));
                }
                HBaseServer.this.closeConnection(c);
                key.attach(null);
            }
        }

        InetSocketAddress getAddress() {
            return (InetSocketAddress)this.acceptChannel.socket().getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doAccept(SelectionKey key) throws IOException, OutOfMemoryError {
            SocketChannel channel;
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            while ((channel = server.accept()) != null) {
                channel.configureBlocking(false);
                channel.socket().setTcpNoDelay(HBaseServer.this.tcpNoDelay);
                channel.socket().setKeepAlive(HBaseServer.this.tcpKeepAlive);
                Reader reader = this.getReader();
                try {
                    reader.startAdd();
                    SelectionKey readKey = reader.registerChannel(channel);
                    Connection c = HBaseServer.this.getConnection(channel, System.currentTimeMillis());
                    readKey.attach(c);
                    List<Connection> list = HBaseServer.this.connectionList;
                    synchronized (list) {
                        HBaseServer.this.connectionList.add(HBaseServer.this.numConnections, c);
                        ++HBaseServer.this.numConnections;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Server connection from " + c.toString() + "; # active connections: " + HBaseServer.this.numConnections + "; # queued calls: " + HBaseServer.this.callQueue.size()));
                }
                finally {
                    reader.finishAdd();
                }
            }
            HBaseServer.this.rpcMetrics.numOpenConnections.set(HBaseServer.this.numConnections);
        }

        void doRead(SelectionKey key) throws InterruptedException {
            int count = 0;
            Connection c = (Connection)key.attachment();
            if (c == null) {
                return;
            }
            c.setLastContact(System.currentTimeMillis());
            try {
                count = c.readAndProcess();
            }
            catch (InterruptedException ieo) {
                throw ieo;
            }
            catch (Exception e) {
                LOG.warn((Object)(this.getName() + ": readAndProcess threw exception " + e + ". Count of bytes read: " + count), (Throwable)e);
                count = -1;
            }
            if (count < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress() + ". Number of active connections: " + HBaseServer.this.numConnections));
                }
                HBaseServer.this.closeConnection(c);
            } else {
                c.setLastContact(System.currentTimeMillis());
            }
        }

        synchronized void doStop() {
            if (this.selector != null) {
                this.selector.wakeup();
                Thread.yield();
            }
            if (this.acceptChannel != null) {
                try {
                    this.acceptChannel.socket().close();
                }
                catch (IOException e) {
                    LOG.info((Object)(this.getName() + ":Exception in closing listener socket. " + e));
                }
            }
            this.readPool.shutdownNow();
        }

        Reader getReader() {
            this.currentReader = (this.currentReader + 1) % this.readers.length;
            return this.readers[this.currentReader];
        }

        private class Reader
        implements Runnable {
            private volatile boolean adding = false;
            private final Selector readSelector = Selector.open();

            Reader() throws IOException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOG.info((Object)("Starting " + Listener.this.getName()));
                try {
                    this.doRunLoop();
                }
                finally {
                    try {
                        this.readSelector.close();
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)("Error closing read selector in " + Listener.this.getName()), (Throwable)ioe);
                    }
                }
            }

            private synchronized void doRunLoop() {
                while (HBaseServer.this.running) {
                    SelectionKey key = null;
                    try {
                        this.readSelector.select();
                        while (this.adding) {
                            this.wait(1000L);
                        }
                        Iterator<SelectionKey> iter = this.readSelector.selectedKeys().iterator();
                        while (iter.hasNext()) {
                            key = iter.next();
                            iter.remove();
                            if (key.isValid() && key.isReadable()) {
                                Listener.this.doRead(key);
                            }
                            key = null;
                        }
                    }
                    catch (InterruptedException e) {
                        if (!HBaseServer.this.running) continue;
                        LOG.info((Object)(Listener.this.getName() + " unexpectedly interrupted: " + StringUtils.stringifyException((Throwable)e)));
                    }
                    catch (IOException ex) {
                        LOG.error((Object)"Error in Reader", (Throwable)ex);
                    }
                }
            }

            public void startAdd() {
                this.adding = true;
                this.readSelector.wakeup();
            }

            public synchronized SelectionKey registerChannel(SocketChannel channel) throws IOException {
                return channel.register(this.readSelector, 1);
            }

            public synchronized void finishAdd() {
                this.adding = false;
                this.notify();
            }
        }
    }

    protected class Call
    implements RpcCallContext {
        protected int id;
        protected Writable param;
        protected Connection connection;
        protected long timestamp;
        protected ByteBuffer response;
        protected boolean delayResponse;
        protected Responder responder;
        protected boolean delayReturnValue;
        protected long size;
        protected boolean isError;

        public Call(int id, Writable param, Connection connection, Responder responder, long size) {
            this.id = id;
            this.param = param;
            this.connection = connection;
            this.timestamp = System.currentTimeMillis();
            this.response = null;
            this.delayResponse = false;
            this.responder = responder;
            this.isError = false;
            this.size = size;
        }

        public String toString() {
            return this.param.toString() + " from " + this.connection.toString();
        }

        protected synchronized void setResponse(Object value, Status status, String errorClass, String error) {
            if (this.isError) {
                return;
            }
            if (errorClass != null) {
                this.isError = true;
            }
            Writable result = null;
            if (value instanceof Writable) {
                result = (Writable)value;
            } else if (value != null) {
                result = new HbaseObjectWritable(value);
            }
            int size = 1024;
            if (result instanceof WritableWithSize) {
                WritableWithSize ohint = (WritableWithSize)result;
                long hint = ohint.getWritableSize() + 1L + 8L;
                if (hint > Integer.MAX_VALUE) {
                    IOException ioe = new IOException("Result buffer size too large: " + hint);
                    errorClass = ioe.getClass().getName();
                    error = StringUtils.stringifyException((Throwable)ioe);
                } else {
                    size = (int)hint;
                }
            }
            ByteBufferOutputStream buf = new ByteBufferOutputStream(size);
            DataOutputStream out = new DataOutputStream(buf);
            try {
                out.writeInt(this.id);
                byte flag = error != null ? ResponseFlag.getErrorAndLengthSet() : ResponseFlag.getLengthSetOnly();
                out.writeByte(flag);
                out.writeInt(-559038737);
                out.writeInt(status.state);
            }
            catch (IOException e) {
                errorClass = e.getClass().getName();
                error = StringUtils.stringifyException((Throwable)e);
            }
            try {
                if (error == null) {
                    result.write((DataOutput)out);
                } else {
                    WritableUtils.writeString((DataOutput)out, (String)errorClass);
                    WritableUtils.writeString((DataOutput)out, (String)error);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Error sending response to call: ", (Throwable)e);
            }
            ByteBuffer bb = buf.getByteBuffer();
            int bufSiz = bb.remaining();
            bb.position(5);
            bb.putInt(bufSiz);
            bb.position(0);
            this.response = bb;
        }

        @Override
        public synchronized void endDelay(Object result) throws IOException {
            assert (this.delayResponse);
            assert (this.delayReturnValue || result == null);
            this.delayResponse = false;
            HBaseServer.this.delayedCalls.decrementAndGet();
            if (this.delayReturnValue) {
                this.setResponse(result, Status.SUCCESS, null, null);
            }
            this.responder.doRespond(this);
        }

        @Override
        public synchronized void endDelay() throws IOException {
            this.endDelay(null);
        }

        @Override
        public synchronized void startDelay(boolean delayReturnValue) {
            assert (!this.delayResponse);
            this.delayResponse = true;
            this.delayReturnValue = delayReturnValue;
            int numDelayed = HBaseServer.this.delayedCalls.incrementAndGet();
            if (numDelayed > HBaseServer.this.warnDelayedCalls) {
                LOG.warn((Object)("Too many delayed calls: limit " + HBaseServer.this.warnDelayedCalls + " current " + numDelayed));
            }
        }

        @Override
        public synchronized void endDelayThrowing(Throwable t) throws IOException {
            this.setResponse(null, Status.ERROR, t.getClass().toString(), StringUtils.stringifyException((Throwable)t));
            this.delayResponse = false;
            this.sendResponseIfReady();
        }

        @Override
        public synchronized boolean isDelayed() {
            return this.delayResponse;
        }

        @Override
        public synchronized boolean isReturnValueDelayed() {
            return this.delayReturnValue;
        }

        @Override
        public void throwExceptionIfCallerDisconnected() throws CallerDisconnectedException {
            if (!this.connection.channel.isOpen()) {
                long afterTime = System.currentTimeMillis() - this.timestamp;
                throw new CallerDisconnectedException("Aborting call " + this + " after " + afterTime + " ms, since " + "caller disconnected");
            }
        }

        public long getSize() {
            return this.size;
        }

        public synchronized void sendResponseIfReady() throws IOException {
            if (!this.delayResponse) {
                this.responder.doRespond(this);
            }
        }
    }
}

