/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.Decoder;
import org.apache.hadoop.hbase.codec.Encoder;

public class KeyValueCodec
implements Codec {
    @Override
    public Decoder getDecoder(InputStream is) {
        return new KeyValueDecoder((DataInputStream)is);
    }

    @Override
    public Encoder getEncoder(OutputStream os) {
        return new KeyValueEncoder((DataOutputStream)os);
    }

    public static class KeyValueDecoder
    extends BaseDecoder {
        public KeyValueDecoder(DataInputStream in) {
            super(in);
        }

        @Override
        protected KeyValue parseCell() throws IOException {
            KeyValue kv = new KeyValue();
            kv.readFields((DataInputStream)this.in);
            return kv;
        }
    }

    public static class KeyValueEncoder
    extends BaseEncoder {
        public KeyValueEncoder(DataOutputStream out) {
            super(out);
        }

        @Override
        public void write(KeyValue kv) throws IOException {
            this.checkFlushed();
            kv.write((DataOutputStream)this.out);
        }
    }
}

