/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.mapr;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public abstract class AbstractHTable {
    public abstract void batch(List<? extends Row> var1, Object[] var2) throws IOException, InterruptedException;

    public abstract Object[] batch(List<? extends Row> var1) throws IOException, InterruptedException;

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public HRegionLocation getRegionLocation(String row) throws IOException {
        return this.getRegionLocation(Bytes.toBytes(row));
    }

    public abstract HRegionLocation getRegionLocation(byte[] var1) throws IOException;

    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        return this.getRegionLocation(row);
    }

    public byte[][] getStartKeys() throws IOException {
        return this.getStartEndKeys().getFirst();
    }

    public byte[][] getEndKeys() throws IOException {
        return this.getStartEndKeys().getSecond();
    }

    public abstract Pair<byte[][], byte[][]> getStartEndKeys() throws IOException;

    public abstract NavigableMap<HRegionInfo, ServerName> getRegionLocations() throws IOException;

    public long getWriteBufferSize() {
        return 0L;
    }

    public void setWriteBufferSize(long writeBufferSize) throws IOException {
    }

    public RowLock lockRow(byte[] row) throws IOException {
        return null;
    }

    public void unlockRow(RowLock rl) throws IOException {
    }

    public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol, byte[] row) {
        return null;
    }

    public <T extends CoprocessorProtocol, R> Map<byte[], R> coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws IOException, Throwable {
        return null;
    }

    public <T extends CoprocessorProtocol, R> void coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws IOException, Throwable {
    }

    public void clearRegionCache() {
    }

    public int getOperationTimeout() {
        return 0;
    }

    public void setOperationTimeout(int operationTimeout) {
    }

    public abstract byte[] getTableName();

    public abstract Configuration getConfiguration();

    public abstract HTableDescriptor getTableDescriptor() throws IOException;

    public abstract boolean exists(Get var1) throws IOException;

    public abstract Result get(Get var1) throws IOException;

    public abstract Result[] get(List<Get> var1) throws IOException;

    public abstract Result getRowOrBefore(byte[] var1, byte[] var2) throws IOException;

    public abstract ResultScanner getScanner(Scan var1) throws IOException;

    public abstract void put(Put var1) throws IOException;

    public abstract void put(List<Put> var1) throws IOException;

    public abstract boolean checkAndPut(byte[] var1, byte[] var2, byte[] var3, byte[] var4, Put var5) throws IOException;

    public abstract void delete(Delete var1) throws IOException;

    public abstract void delete(List<Delete> var1) throws IOException;

    public abstract boolean checkAndDelete(byte[] var1, byte[] var2, byte[] var3, byte[] var4, Delete var5) throws IOException;

    public abstract void mutateRow(RowMutations var1) throws IOException;

    public abstract Result append(Append var1) throws IOException;

    public abstract Result increment(Increment var1) throws IOException;

    public abstract long incrementColumnValue(byte[] var1, byte[] var2, byte[] var3, long var4) throws IOException;

    public abstract long incrementColumnValue(byte[] var1, byte[] var2, byte[] var3, long var4, boolean var6) throws IOException;

    public abstract boolean isAutoFlush();

    public abstract void flushCommits() throws IOException;

    public abstract void close() throws IOException;

    public abstract void setAutoFlush(boolean var1);

    public abstract void setAutoFlush(boolean var1, boolean var2);
}

