/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.mapr.AbstractHBaseAdmin;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.GenericHFactory;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.ipc.MasterExecRPCInvoker;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.HSnapshotDescription;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;

public class HBaseAdmin
implements Abortable,
Closeable {
    public static final String HBASE_ADMIN_CONNECT_AT_CONSTRUCTION = "hbase.admin.connect.at.construction";
    private static final GenericHFactory<AbstractHBaseAdmin> adminFactory_ = new GenericHFactory();
    private static final AtomicBoolean balancer_ = new AtomicBoolean();
    private volatile boolean connected_ = false;
    private volatile boolean isHbaseAvailable_ = true;
    private volatile AbstractHBaseAdmin maprHBaseAdmin_ = null;
    private volatile Throwable hbaseException_ = null;
    private BaseTableMappingRules tableMappingRule_;
    private final HBaseConnector hbaseConnector_;
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private HConnection connection;
    private volatile Configuration conf;
    private long pause;
    private int numRetries;
    private int retryLongerMultiplier;
    private boolean aborted;
    private static volatile boolean synchronousBalanceSwitchSupported = true;
    private boolean cleanupConnectionOnClose;

    public HBaseAdmin(final Configuration c) throws MasterNotRunningException, ZooKeeperConnectionException {
        this.hbaseConnector_ = new HBaseConnector(){

            @Override
            void connect() throws ZooKeeperConnectionException, MasterNotRunningException {
                HBaseAdmin.this.connectWithConfiguration(c);
            }
        };
        this.commonInit(c);
    }

    void connectWithConfiguration(Configuration c) throws ZooKeeperConnectionException, MasterNotRunningException {
        this.conf = HBaseConfiguration.create(c);
        this.connection = HConnectionManager.getConnection(this.conf);
        this.pause = this.conf.getLong("hbase.client.pause", 1000L);
        this.numRetries = this.conf.getInt("hbase.client.retries.number", 10);
        this.retryLongerMultiplier = this.conf.getInt("hbase.client.retries.longer.multiplier", 10);
        this.cleanupConnectionOnClose = true;
        int tries = 0;
        while (true) {
            try {
                this.connection.getMaster();
                return;
            }
            catch (MasterNotRunningException mnre) {
                HConnectionManager.deleteStaleConnection(this.connection);
                this.connection = HConnectionManager.getConnection(this.conf);
                if (++tries >= this.numRetries) {
                    HConnectionManager.deleteStaleConnection(this.connection);
                    throw new MasterNotRunningException("Retried " + this.numRetries + " times");
                }
                try {
                    Thread.sleep(this.getPauseTime(tries));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    HConnectionManager.deleteStaleConnection(this.connection);
                    throw new MasterNotRunningException("Interrupted after " + tries + " tries");
                }
            }
        }
    }

    public HBaseAdmin(final HConnection connection) throws MasterNotRunningException, ZooKeeperConnectionException {
        this.hbaseConnector_ = new HBaseConnector(){

            @Override
            void connect() throws ZooKeeperConnectionException, MasterNotRunningException {
                HBaseAdmin.this.connectWithHConnection(connection);
            }
        };
        this.commonInit(connection.getConfiguration());
    }

    private void connectWithHConnection(HConnection connection) throws MasterNotRunningException, ZooKeeperConnectionException {
        this.conf = connection.getConfiguration();
        this.connection = connection;
        this.cleanupConnectionOnClose = false;
        this.pause = this.conf.getLong("hbase.client.pause", 1000L);
        this.numRetries = this.conf.getInt("hbase.client.retries.number", 10);
        this.retryLongerMultiplier = this.conf.getInt("hbase.client.retries.longer.multiplier", 10);
        this.connection.getMaster();
    }

    private synchronized boolean ensureConnectedToHBase() throws ZooKeeperConnectionException, MasterNotRunningException {
        return this.ensureConnectedToHBase(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean ensureConnectedToHBase(boolean throwException) throws ZooKeeperConnectionException, MasterNotRunningException {
        if (!this.connected_) {
            if (this.tableMappingRule_.getClusterType() == BaseTableMappingRules.ClusterType.MAPR_ONLY) {
                if (throwException) {
                    throw new MasterNotRunningException("This client is configured as MapR only.");
                }
                return false;
            }
            if (this.isHbaseAvailable_) {
                try {
                    this.hbaseConnector_.connect();
                    this.connected_ = true;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable e) {
                    this.hbaseException_ = e;
                }
                finally {
                    this.isHbaseAvailable_ = this.connected_;
                }
            }
            if (throwException) {
                if (this.hbaseException_ instanceof RuntimeException) {
                    throw (RuntimeException)this.hbaseException_;
                }
                if (this.hbaseException_ instanceof ZooKeeperConnectionException) {
                    throw (ZooKeeperConnectionException)this.hbaseException_;
                }
                if (!(this.hbaseException_ instanceof MasterNotRunningException)) {
                    this.hbaseException_ = new MasterNotRunningException().initCause(this.hbaseException_);
                }
                throw (MasterNotRunningException)this.hbaseException_;
            }
            return false;
        }
        return true;
    }

    private boolean checkIfMapRDefault(boolean connectToHBaseOtherwise) throws ZooKeeperConnectionException, MasterNotRunningException {
        if (this.tableMappingRule_.isMapRDefault()) {
            return true;
        }
        if (connectToHBaseOtherwise) {
            this.ensureConnectedToHBase();
        }
        return false;
    }

    private boolean checkIfMapRTable(String tableName, boolean connectToHBaseOtherwise) throws ZooKeeperConnectionException, MasterNotRunningException {
        if (this.tableMappingRule_.isMapRTable(HRegionInfo.getTableName(tableName))) {
            return true;
        }
        if (connectToHBaseOtherwise) {
            this.ensureConnectedToHBase();
        }
        return false;
    }

    private boolean checkIfMapRTable(byte[] tableName, boolean connectToHBaseOtherwise) throws ZooKeeperConnectionException, MasterNotRunningException {
        return this.checkIfMapRTable(Bytes.toString(tableName), connectToHBaseOtherwise);
    }

    private void commonInit(Configuration c) throws ZooKeeperConnectionException, MasterNotRunningException {
        this.conf = c;
        try {
            this.tableMappingRule_ = TableMappingRulesFactory.create(this.conf);
            if (this.tableMappingRule_.getClusterType() != BaseTableMappingRules.ClusterType.HBASE_ONLY) {
                this.maprHBaseAdmin_ = adminFactory_.getImplementorInstance(this.conf.get("hbaseadmin.impl.mapr", "com.mapr.fs.HBaseAdminImpl"), new Object[]{this.conf, this.tableMappingRule_}, Configuration.class, BaseTableMappingRules.class);
            }
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        if (c.getBoolean(HBASE_ADMIN_CONNECT_AT_CONSTRUCTION, false)) {
            this.ensureConnectedToHBase();
        }
    }

    private synchronized CatalogTracker getCatalogTracker() throws ZooKeeperConnectionException, IOException {
        CatalogTracker ct = null;
        try {
            ct = new CatalogTracker(this.conf);
            ct.start();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted", e);
        }
        return ct;
    }

    private void cleanupCatalogTracker(CatalogTracker ct) {
        ct.stop();
    }

    @Override
    public void abort(String why, Throwable e) {
        this.aborted = true;
        throw new RuntimeException(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    public HConnection getConnection() {
        try {
            this.ensureConnectedToHBase();
        }
        catch (IOException e) {
            this.connection = null;
        }
        return this.connection;
    }

    @Deprecated
    public HMasterInterface getMaster() throws MasterNotRunningException, ZooKeeperConnectionException {
        this.ensureConnectedToHBase();
        return this.connection.getMaster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        int numRetries = this.conf.getInt("hbase.client.retries.number", 10);
        try {
            this.conf.setInt("hbase.client.retries.number", this.conf.getInt("hbase.client.retries.number.alternate", 1));
            this.ensureConnectedToHBase();
        }
        finally {
            this.conf.setInt("hbase.client.retries.number", numRetries);
            this.numRetries = numRetries;
        }
        return this.connection.isMasterRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.tableExists(tableName);
        }
        boolean b = false;
        CatalogTracker ct = this.getCatalogTracker();
        try {
            b = MetaReader.tableExists(ct, FSUtils.adjustTableNameString(tableName));
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
        return b;
    }

    public boolean tableExists(byte[] tableName) throws IOException {
        return this.tableExists(Bytes.toString(tableName));
    }

    public HTableDescriptor[] listTables() throws IOException {
        if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.listTables();
        }
        return this.connection.listTables();
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        HTableDescriptor[] tables;
        String regex = pattern.pattern();
        if (this.checkIfMapRTable(regex, false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.listTables(regex);
        }
        if (!(regex = FSUtils.adjustTableNameString(regex)).equals(pattern.pattern())) {
            pattern = Pattern.compile(regex);
        }
        LinkedList<HTableDescriptor> matched = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : tables = this.listTables()) {
            if (!pattern.matcher(table.getNameAsString()).matches()) continue;
            matched.add(table);
        }
        return matched.toArray(new HTableDescriptor[matched.size()]);
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(Pattern.compile(regex));
    }

    public String[] getTableNames() throws IOException {
        if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.getTableNames();
        }
        return this.connection.getTableNames();
    }

    public String[] getTableNames(Pattern pattern) throws IOException {
        if (this.checkIfMapRTable(pattern.pattern(), true)) {
            return this.maprHBaseAdmin_.getTableNames(pattern.pattern());
        }
        ArrayList<String> matched = new ArrayList<String>();
        for (String name : this.connection.getTableNames()) {
            if (!pattern.matcher(name).matches()) continue;
            matched.add(name);
        }
        return matched.toArray(new String[matched.size()]);
    }

    public String[] getTableNames(String regex) throws IOException {
        if (this.checkIfMapRTable(regex, true)) {
            return this.maprHBaseAdmin_.getTableNames(regex);
        }
        return this.getTableNames(Pattern.compile(regex));
    }

    public HTableDescriptor getTableDescriptor(byte[] tableName) throws TableNotFoundException, IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.getTableDescriptor(Bytes.toString(tableName));
        }
        return this.connection.getHTableDescriptor(FSUtils.adjustTableName(tableName));
    }

    private long getPauseTime(int tries) {
        int triesCount = tries;
        if (triesCount >= HConstants.RETRY_BACKOFF.length) {
            triesCount = HConstants.RETRY_BACKOFF.length - 1;
        }
        return this.pause * (long)HConstants.RETRY_BACKOFF[triesCount];
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo(startKey, endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split(startKey, endKey, numRegions - 3);
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(final HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        try {
            this.createTableAsync(desc, splitKeys);
            if (this.checkIfMapRTable(desc.getAlias(), false)) {
                return;
            }
        }
        catch (SocketTimeoutException ste) {
            this.LOG.warn((Object)("Creating " + desc.getNameAsString() + " took too long"), (Throwable)ste);
        }
        int numRegs = splitKeys == null ? 1 : splitKeys.length + 1;
        int prevRegCount = 0;
        boolean doneWithMetaScan = false;
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            if (!doneWithMetaScan) {
                final AtomicInteger actualRegCount = new AtomicInteger(0);
                MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                    @Override
                    public boolean processRow(Result rowResult) throws IOException {
                        if (rowResult == null || rowResult.size() <= 0) {
                            return true;
                        }
                        HRegionInfo info = MetaReader.parseHRegionInfoFromCatalogResult(rowResult, HConstants.REGIONINFO_QUALIFIER);
                        if (info == null) {
                            HBaseAdmin.this.LOG.warn((Object)("No serialized HRegionInfo in " + rowResult));
                            return true;
                        }
                        if (!Bytes.equals(info.getTableName(), desc.getName())) {
                            return false;
                        }
                        String hostAndPort = null;
                        byte[] value = rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                        if (value != null && value.length > 0) {
                            hostAndPort = Bytes.toString(value);
                        }
                        if (!info.isOffline() && !info.isSplit() && hostAndPort != null) {
                            actualRegCount.incrementAndGet();
                        }
                        return true;
                    }
                };
                MetaScanner.metaScan(this.conf, this.connection, visitor, desc.getName());
                if (actualRegCount.get() != numRegs) {
                    if (tries == this.numRetries * this.retryLongerMultiplier - 1) {
                        throw new RegionOfflineException("Only " + actualRegCount.get() + " of " + numRegs + " regions are online; retries exhausted.");
                    }
                    try {
                        Thread.sleep(this.getPauseTime(tries));
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException("Interrupted when opening regions; " + actualRegCount.get() + " of " + numRegs + " regions processed so far");
                    }
                    if (actualRegCount.get() <= prevRegCount) continue;
                    prevRegCount = actualRegCount.get();
                    tries = -1;
                    continue;
                }
                doneWithMetaScan = true;
                tries = -1;
                continue;
            }
            if (this.isTableEnabled(desc.getName())) {
                return;
            }
            try {
                Thread.sleep(this.getPauseTime(tries));
                continue;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted when waiting for table to be enabled; meta scan was done");
            }
        }
        throw new TableNotEnabledException("Retries exhausted while still waiting for table: " + desc.getNameAsString() + " to be enabled");
    }

    public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        desc.validate();
        if (this.checkIfMapRTable(desc.getAlias(), true)) {
            this.maprHBaseAdmin_.createTable(desc, splitKeys);
            return;
        }
        HTableDescriptor.isLegalTableName(desc.getName());
        if (splitKeys != null && splitKeys.length > 0) {
            Arrays.sort(splitKeys, Bytes.BYTES_COMPARATOR);
            byte[] lastKey = null;
            for (byte[] splitKey : splitKeys) {
                if (Bytes.compareTo(splitKey, HConstants.EMPTY_BYTE_ARRAY) == 0) {
                    throw new IllegalArgumentException("Empty split key must not be passed in the split keys.");
                }
                if (lastKey != null && Bytes.equals(splitKey, lastKey)) {
                    throw new IllegalArgumentException("All split keys must be unique, found duplicate: " + Bytes.toStringBinary(splitKey) + ", " + Bytes.toStringBinary(lastKey));
                }
                lastKey = splitKey;
            }
        }
        try {
            this.getMaster().createTable(desc, splitKeys);
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException();
        }
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(Bytes.toBytes(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTable(byte[] tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.deleteTable(Bytes.toString(tableName));
            return;
        }
        this.isMasterRunning();
        tableName = FSUtils.adjustTableName(tableName);
        HTableDescriptor.isLegalTableName(tableName);
        HRegionLocation firstMetaServer = this.getFirstMetaServerForTable(tableName);
        boolean tableExists = true;
        try {
            this.getMaster().deleteTable(tableName);
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
        HRegionInterface server = this.connection.getHRegionConnection(firstMetaServer.getHostname(), firstMetaServer.getPort());
        ArrayList<String> tableNameAsList = new ArrayList<String>(1);
        tableNameAsList.add(Bytes.toString(tableName));
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            long scannerId = -1L;
            try {
                Scan scan = MetaReader.getScanForTableName(tableName);
                scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                scannerId = server.openScanner(firstMetaServer.getRegionInfo().getRegionName(), scan);
                Result values = server.next(scannerId);
                if (values == null) {
                    tableExists = false;
                    HTableDescriptor[] htds = this.getMaster().getHTableDescriptors(tableNameAsList);
                    boolean bl = tableExists = htds != null && htds.length > 0;
                    if (!tableExists) {
                        break;
                    }
                }
            }
            catch (IOException ex) {
                if (tries == this.numRetries - 1) {
                    if (ex instanceof RemoteException) {
                        ex = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)ex));
                    }
                    throw ex;
                }
            }
            finally {
                if (scannerId != -1L) {
                    try {
                        server.close(scannerId);
                    }
                    catch (Exception ex) {
                        this.LOG.warn((Object)ex);
                    }
                }
            }
            try {
                Thread.sleep(this.getPauseTime(tries));
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (tableExists) {
            throw new IOException("Retries exhausted, it took too long to wait for the table " + Bytes.toString(tableName) + " to be deleted.");
        }
        this.connection.clearRegionCache(tableName);
        this.LOG.info((Object)("Deleted " + Bytes.toString(tableName)));
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.deleteTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        if (this.checkIfMapRTable(pattern.pattern(), true)) {
            return this.maprHBaseAdmin_.deleteTables(pattern.pattern());
        }
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            try {
                this.deleteTable(table.getName());
            }
            catch (IOException ex) {
                this.LOG.info((Object)("Failed to delete table " + table.getNameAsString()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void enableTable(String tableName) throws IOException {
        this.enableTable(Bytes.toBytes(tableName));
    }

    public void enableTable(byte[] tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.enableTable(Bytes.toString(tableName));
            return;
        }
        tableName = FSUtils.adjustTableName(tableName);
        this.enableTableAsync(tableName);
        this.waitUntilTableIsEnabled(tableName);
        this.LOG.info((Object)("Enabled table " + Bytes.toString(tableName)));
    }

    private void waitUntilTableIsEnabled(byte[] tableName) throws IOException {
        boolean enabled = false;
        long start = EnvironmentEdgeManager.currentTimeMillis();
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            boolean bl = enabled = this.isTableEnabled(tableName) && this.isTableAvailable(tableName);
            if (enabled) break;
            long sleep = this.getPauseTime(tries);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Sleeping= " + sleep + "ms, waiting for all regions to be " + "enabled in " + Bytes.toString(tableName)));
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted", e);
            }
        }
        if (!enabled) {
            long msec = EnvironmentEdgeManager.currentTimeMillis() - start;
            throw new IOException("Table '" + Bytes.toString(tableName) + "' not yet enabled, after " + msec + "ms.");
        }
    }

    public void enableTableAsync(String tableName) throws IOException {
        this.enableTableAsync(Bytes.toBytes(tableName));
    }

    public void enableTableAsync(byte[] tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.enableTable(Bytes.toString(tableName));
            return;
        }
        tableName = FSUtils.adjustTableName(tableName);
        HTableDescriptor.isLegalTableName(tableName);
        this.isMasterRunning();
        try {
            this.getMaster().enableTable(tableName);
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException();
        }
        this.LOG.info((Object)("Started enable of " + Bytes.toString(tableName)));
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.enableTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        if (this.checkIfMapRTable(pattern.pattern(), true)) {
            return this.maprHBaseAdmin_.enableTables(pattern.pattern());
        }
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableDisabled(table.getName())) continue;
            try {
                this.enableTable(table.getName());
            }
            catch (IOException ex) {
                this.LOG.info((Object)("Failed to enable table " + table.getNameAsString()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void disableTableAsync(String tableName) throws IOException {
        this.disableTableAsync(Bytes.toBytes(tableName));
    }

    public void disableTableAsync(byte[] tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.disableTable(Bytes.toString(tableName));
            return;
        }
        tableName = FSUtils.adjustTableName(tableName);
        HTableDescriptor.isLegalTableName(tableName);
        this.isMasterRunning();
        try {
            this.getMaster().disableTable(tableName);
        }
        catch (RemoteException e) {
            throw e.unwrapRemoteException();
        }
        this.LOG.info((Object)("Started disable of " + Bytes.toString(tableName)));
    }

    public void disableTable(String tableName) throws IOException {
        this.disableTable(Bytes.toBytes(tableName));
    }

    public void disableTable(byte[] tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.disableTable(Bytes.toString(tableName));
            return;
        }
        tableName = FSUtils.adjustTableName(tableName);
        this.disableTableAsync(tableName);
        boolean disabled = false;
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier && !(disabled = this.isTableDisabled(tableName)); ++tries) {
            long sleep = this.getPauseTime(tries);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Sleeping= " + sleep + "ms, waiting for all regions to be " + "disabled in " + Bytes.toString(tableName)));
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted", e);
            }
        }
        if (!disabled) {
            throw new RegionException("Retries exhausted, it took too long to wait for the table " + Bytes.toString(tableName) + " to be disabled.");
        }
        this.LOG.info((Object)("Disabled " + Bytes.toString(tableName)));
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.disableTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        if (this.checkIfMapRTable(pattern.pattern(), true)) {
            return this.maprHBaseAdmin_.disableTables(pattern.pattern());
        }
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableEnabled(table.getName())) continue;
            try {
                this.disableTable(table.getName());
            }
            catch (IOException ex) {
                this.LOG.info((Object)("Failed to disable table " + table.getNameAsString()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    private void checkTableExistence(byte[] tableName) throws IOException {
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException(Bytes.toString(tableName));
        }
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(Bytes.toBytes(tableName));
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableEnabled(Bytes.toString(tableName));
        }
        if (!HTableDescriptor.isMetaTable(tableName = FSUtils.adjustTableName(tableName))) {
            HTableDescriptor.isLegalTableName(tableName);
        }
        this.checkTableExistence(tableName);
        return this.connection.isTableEnabled(tableName);
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(Bytes.toBytes(tableName));
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableDisabled(Bytes.toString(tableName));
        }
        if (!HTableDescriptor.isMetaTable(tableName = FSUtils.adjustTableName(tableName))) {
            HTableDescriptor.isLegalTableName(tableName);
        }
        this.checkTableExistence(tableName);
        return this.connection.isTableDisabled(tableName);
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableAvailable(Bytes.toString(tableName));
        }
        return this.connection.isTableAvailable(FSUtils.adjustTableName(tableName));
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableAvailable(tableName);
        }
        return this.connection.isTableAvailable(FSUtils.adjustTableName(tableName));
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return new Pair<Integer, Integer>(0, 0);
        }
        tableName = FSUtils.adjustTableName(tableName);
        HTableDescriptor.isLegalTableName(tableName);
        try {
            return this.getMaster().getAlterStatus(tableName);
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(Bytes.toBytes(tableName), column);
    }

    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        column.validate();
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.addColumn(Bytes.toString(tableName), column);
            return;
        }
        tableName = FSUtils.adjustTableName(tableName);
        HTableDescriptor.isLegalTableName(tableName);
        try {
            this.getMaster().addColumn(tableName, column);
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(Bytes.toBytes(tableName), Bytes.toBytes(columnName));
    }

    public void deleteColumn(byte[] tableName, byte[] columnName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.deleteColumn(Bytes.toString(tableName), Bytes.toString(columnName));
            return;
        }
        try {
            this.getMaster().deleteColumn(FSUtils.adjustTableName(tableName), columnName);
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(Bytes.toBytes(tableName), descriptor);
    }

    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        descriptor.validate();
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.modifyColumn(Bytes.toString(tableName), descriptor);
            return;
        }
        try {
            this.getMaster().modifyColumn(FSUtils.adjustTableName(tableName), descriptor);
        }
        catch (RemoteException re) {
            throw RemoteExceptionHandler.decodeRemoteException(re);
        }
    }

    public void closeRegion(String regionname, String serverName) throws IOException {
        this.closeRegion(Bytes.toBytes(regionname), serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        if (this.checkIfMapRTable(regionname, true)) {
            this.maprHBaseAdmin_.closeRegion(regionname, serverName);
            return;
        }
        CatalogTracker ct = this.getCatalogTracker();
        try {
            if (serverName != null) {
                Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(ct, regionname);
                if (pair == null || pair.getFirst() == null) {
                    throw new UnknownRegionException(Bytes.toStringBinary(regionname));
                }
                this.closeRegion(new ServerName(serverName), pair.getFirst());
            } else {
                Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(ct, regionname);
                if (pair == null) {
                    throw new UnknownRegionException(Bytes.toStringBinary(regionname));
                }
                if (pair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary(regionname));
                }
                this.closeRegion(pair.getSecond(), pair.getFirst());
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        if (this.checkIfMapRTable(encodedRegionName, true)) {
            this.maprHBaseAdmin_.closeRegionWithEncodedRegionName(encodedRegionName, serverName);
            return true;
        }
        byte[] encodedRegionNameInBytes = Bytes.toBytes(encodedRegionName);
        if (null == serverName || "".equals(serverName.trim())) {
            throw new IllegalArgumentException("The servername cannot be null or empty.");
        }
        ServerName sn = new ServerName(serverName);
        HRegionInterface rs = this.connection.getHRegionConnection(sn.getHostname(), sn.getPort());
        boolean isRegionClosed = rs.closeRegion(encodedRegionNameInBytes, false);
        if (!isRegionClosed) {
            this.LOG.error((Object)("Not able to close the region " + encodedRegionName + "."));
        }
        return isRegionClosed;
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        if (this.checkIfMapRTable(hri.getRegionName(), true)) {
            this.maprHBaseAdmin_.closeRegion(sn, hri);
            return;
        }
        HRegionInterface rs = this.connection.getHRegionConnection(sn.getHostname(), sn.getPort());
        rs.closeRegion(hri, false);
    }

    public void flush(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.flush(Bytes.toBytes(tableNameOrRegionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        if (this.checkIfMapRTable(tableNameOrRegionName, true)) {
            this.maprHBaseAdmin_.flush(tableNameOrRegionName);
            return;
        }
        CatalogTracker ct = this.getCatalogTracker();
        tableNameOrRegionName = FSUtils.adjustTableName(tableNameOrRegionName);
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(tableNameOrRegionName, ct);
            if (regionServerPair != null) {
                if (regionServerPair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary(tableNameOrRegionName));
                }
                this.flush(regionServerPair.getSecond(), regionServerPair.getFirst());
            } else {
                String tableName = this.tableNameString(tableNameOrRegionName, ct);
                List<Pair<HRegionInfo, ServerName>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, ServerName> pair : pairs) {
                    if (pair.getFirst().isOffline() || pair.getSecond() == null) continue;
                    try {
                        this.flush(pair.getSecond(), pair.getFirst());
                    }
                    catch (NotServingRegionException e) {
                        if (!this.LOG.isDebugEnabled()) continue;
                        this.LOG.debug((Object)("Trying to flush " + (Object)((Object)pair.getFirst()) + ": " + StringUtils.stringifyException((Throwable)e)));
                    }
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void flush(ServerName sn, HRegionInfo hri) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(sn.getHostname(), sn.getPort());
        rs.flushRegion(hri);
    }

    public void compact(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(Bytes.toBytes(tableNameOrRegionName));
    }

    public void compact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, null, false);
    }

    public void compact(String tableOrRegionName, String columnFamily) throws IOException, InterruptedException {
        this.compact(Bytes.toBytes(tableOrRegionName), Bytes.toBytes(columnFamily));
    }

    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, columnFamily, false);
    }

    public void majorCompact(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.majorCompact(Bytes.toBytes(tableNameOrRegionName));
    }

    public void majorCompact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, null, true);
    }

    public void majorCompact(String tableNameOrRegionName, String columnFamily) throws IOException, InterruptedException {
        this.majorCompact(Bytes.toBytes(tableNameOrRegionName), Bytes.toBytes(columnFamily));
    }

    public void majorCompact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, columnFamily, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(byte[] tableNameOrRegionName, byte[] columnFamily, boolean major) throws IOException, InterruptedException {
        if (this.checkIfMapRTable(tableNameOrRegionName, true)) {
            this.maprHBaseAdmin_.compact(tableNameOrRegionName, columnFamily, major);
            return;
        }
        CatalogTracker ct = this.getCatalogTracker();
        tableNameOrRegionName = FSUtils.adjustTableName(tableNameOrRegionName);
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(tableNameOrRegionName, ct);
            if (regionServerPair != null) {
                if (regionServerPair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary(tableNameOrRegionName));
                }
                this.compact(regionServerPair.getSecond(), regionServerPair.getFirst(), major, columnFamily);
            } else {
                String tableName = this.tableNameString(tableNameOrRegionName, ct);
                List<Pair<HRegionInfo, ServerName>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, ServerName> pair : pairs) {
                    if (pair.getFirst().isOffline() || pair.getSecond() == null) continue;
                    try {
                        this.compact(pair.getSecond(), pair.getFirst(), major, columnFamily);
                    }
                    catch (NotServingRegionException e) {
                        if (!this.LOG.isDebugEnabled()) continue;
                        this.LOG.debug((Object)("Trying to" + (major ? " major" : "") + " compact " + (Object)((Object)pair.getFirst()) + ": " + StringUtils.stringifyException((Throwable)e)));
                    }
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void compact(ServerName sn, HRegionInfo hri, boolean major, byte[] family) throws IOException {
        if (this.checkIfMapRTable(hri.getRegionName(), true)) {
            this.maprHBaseAdmin_.compact(sn, hri, major, family);
            return;
        }
        HRegionInterface rs = this.connection.getHRegionConnection(sn.getHostname(), sn.getPort());
        if (family != null) {
            try {
                rs.compactRegion(hri, major, family);
            }
            catch (IOException ioe) {
                String notFoundMsg = "java.lang.NoSuchMethodException: org.apache.hadoop.hbase.ipc.HRegionInterface.compactRegion(org.apache.hadoop.hbase.HRegionInfo, boolean, [B)";
                if (ioe.getMessage().contains(notFoundMsg)) {
                    throw new IOException("per-column family compaction not supported on this version of the HBase server.  You may still compact at the table or region level by omitting the column family name.  Alternatively, you can upgrade the HBase server");
                }
                throw ioe;
            }
        } else {
            rs.compactRegion(hri, major);
        }
    }

    public void move(byte[] encodedRegionName, byte[] destServerName) throws UnknownRegionException, MasterNotRunningException, ZooKeeperConnectionException {
        if (this.checkIfMapRTable(encodedRegionName, true)) {
            this.maprHBaseAdmin_.move(encodedRegionName, destServerName);
            return;
        }
        this.getMaster().move(encodedRegionName, destServerName);
    }

    public void assign(byte[] regionName) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        if (this.checkIfMapRTable(regionName, true)) {
            this.maprHBaseAdmin_.assign(regionName);
            return;
        }
        this.getMaster().assign(regionName);
    }

    public void unassign(byte[] regionName, boolean force) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        if (this.checkIfMapRTable(regionName, true)) {
            this.maprHBaseAdmin_.unassign(regionName, force);
            return;
        }
        this.getMaster().unassign(regionName, force);
    }

    @Deprecated
    public boolean balanceSwitch(boolean b) throws MasterNotRunningException, ZooKeeperConnectionException {
        if (this.checkIfMapRDefault(true)) {
            return balancer_.getAndSet(b);
        }
        return this.getMaster().balanceSwitch(b);
    }

    public boolean setBalancerRunning(boolean on, boolean synchronous) throws MasterNotRunningException, ZooKeeperConnectionException {
        if (this.checkIfMapRDefault(true)) {
            return balancer_.getAndSet(on);
        }
        if (synchronous && synchronousBalanceSwitchSupported) {
            try {
                return this.getMaster().synchronousBalanceSwitch(on);
            }
            catch (UndeclaredThrowableException ute) {
                String error = ute.getCause().getMessage();
                if (error != null && error.matches("(?s).+NoSuchMethodException:.+synchronousBalanceSwitch.+")) {
                    this.LOG.info((Object)"HMaster doesn't support synchronousBalanceSwitch");
                    synchronousBalanceSwitchSupported = false;
                }
                throw ute;
            }
        }
        return this.balanceSwitch(on);
    }

    public boolean balancer() throws MasterNotRunningException, ZooKeeperConnectionException {
        if (this.checkIfMapRDefault(true)) {
            return true;
        }
        return this.getMaster().balance();
    }

    public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(Bytes.toBytes(tableNameOrRegionName));
    }

    public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(tableNameOrRegionName, null);
    }

    public void split(String tableNameOrRegionName, String splitPoint) throws IOException, InterruptedException {
        this.split(Bytes.toBytes(tableNameOrRegionName), Bytes.toBytes(splitPoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException, InterruptedException {
        if (this.checkIfMapRTable(tableNameOrRegionName, true)) {
            this.maprHBaseAdmin_.split(tableNameOrRegionName, splitPoint);
            return;
        }
        CatalogTracker ct = this.getCatalogTracker();
        tableNameOrRegionName = FSUtils.adjustTableName(tableNameOrRegionName);
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(tableNameOrRegionName, ct);
            if (regionServerPair != null) {
                if (regionServerPair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary(tableNameOrRegionName));
                }
                this.split(regionServerPair.getSecond(), regionServerPair.getFirst(), splitPoint);
            } else {
                String tableName = this.tableNameString(tableNameOrRegionName, ct);
                List<Pair<HRegionInfo, ServerName>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, ServerName> pair : pairs) {
                    HRegionInfo r;
                    if (pair.getSecond() == null || (r = pair.getFirst()).isSplitParent() || splitPoint != null && !r.containsRow(splitPoint)) continue;
                    this.split(pair.getSecond(), pair.getFirst(), splitPoint);
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void split(ServerName sn, HRegionInfo hri, byte[] splitPoint) throws IOException {
        HRegionInterface rs = this.connection.getHRegionConnection(sn.getHostname(), sn.getPort());
        rs.splitRegion(hri, splitPoint);
    }

    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.modifyTable(Bytes.toString(tableName), htd);
            return;
        }
        try {
            this.getMaster().modifyTable(FSUtils.adjustTableName(tableName), htd);
        }
        catch (RemoteException re) {
            throw RemoteExceptionHandler.decodeRemoteException(re);
        }
    }

    Pair<HRegionInfo, ServerName> getRegion(byte[] tableNameOrRegionName, CatalogTracker ct) throws IOException {
        if (tableNameOrRegionName == null) {
            throw new IllegalArgumentException("Pass a table name or region name");
        }
        Pair pair = MetaReader.getRegion(ct, tableNameOrRegionName);
        if (pair == null) {
            final AtomicReference<Object> result = new AtomicReference<Object>(null);
            final String encodedName = Bytes.toString(tableNameOrRegionName);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result data) throws IOException {
                    if (data == null || data.size() <= 0) {
                        return true;
                    }
                    HRegionInfo info = MetaReader.parseHRegionInfoFromCatalogResult(data, HConstants.REGIONINFO_QUALIFIER);
                    if (info == null) {
                        HBaseAdmin.this.LOG.warn((Object)("No serialized HRegionInfo in " + data));
                        return true;
                    }
                    if (!encodedName.equals(info.getEncodedName())) {
                        return true;
                    }
                    ServerName sn = MetaReader.getServerNameFromCatalogResult(data);
                    result.set(new Pair<HRegionInfo, ServerName>(info, sn));
                    return false;
                }
            };
            MetaScanner.metaScan(this.conf, this.connection, visitor, null);
            pair = result.get();
        }
        return pair;
    }

    private String tableNameString(byte[] tableNameBytes, CatalogTracker ct) throws IOException {
        String tableNameString = FSUtils.adjustTableNameString(Bytes.toString(tableNameBytes));
        if (!MetaReader.tableExists(ct, tableNameString)) {
            throw new TableNotFoundException(tableNameString);
        }
        return tableNameString;
    }

    public synchronized void shutdown() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.LOG.warn((Object)"shutdown() called for a MapR cluster, silently ignoring.");
            return;
        }
        this.isMasterRunning();
        try {
            this.getMaster().shutdown();
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public synchronized void stopMaster() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.LOG.warn((Object)"stopMaster() called for a MapR cluster, silently ignoring.");
            return;
        }
        this.isMasterRunning();
        try {
            this.getMaster().stopMaster();
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public synchronized void stopRegionServer(String hostnamePort) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            this.LOG.warn((Object)"stopRegionServer() called for a MapR cluster, silently ignoring.");
            return;
        }
        String hostname = Addressing.parseHostname(hostnamePort);
        int port = Addressing.parsePort(hostnamePort);
        HRegionInterface rs = this.connection.getHRegionConnection(hostname, port);
        rs.stop("Called by admin client " + this.connection.toString());
    }

    public ClusterStatus getClusterStatus() throws IOException {
        if (!this.ensureConnectedToHBase(false)) {
            return null;
        }
        return this.getMaster().getClusterStatus();
    }

    private HRegionLocation getFirstMetaServerForTable(byte[] tableName) throws IOException {
        return this.connection.locateRegion(HConstants.META_TABLE_NAME, HRegionInfo.createRegionName(tableName, null, "99999999999999", false));
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public static void checkHBaseAvailable(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException {
        try {
            if (TableMappingRulesFactory.create(conf).getClusterType() == BaseTableMappingRules.ClusterType.MAPR_ONLY) {
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Configuration copyOfConf = HBaseConfiguration.create(conf);
        copyOfConf.setInt("hbase.client.retries.number", 1);
        copyOfConf.setBoolean(HBASE_ADMIN_CONNECT_AT_CONSTRUCTION, true);
        HBaseAdmin admin = new HBaseAdmin(copyOfConf);
        try {
            admin.close();
        }
        catch (IOException ioe) {
            admin.LOG.info((Object)"Failed to close connection", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.getTableRegions(tableName);
        }
        CatalogTracker ct = this.getCatalogTracker();
        List<HRegionInfo> Regions = null;
        try {
            Regions = MetaReader.getTableRegions(ct, FSUtils.adjustTableName(tableName), true);
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
        return Regions;
    }

    @Override
    public void close() throws IOException {
        if (this.cleanupConnectionOnClose && this.connection != null) {
            this.connection.close();
        }
    }

    public HTableDescriptor[] getTableDescriptors(List<String> tableNames) throws IOException {
        ArrayList<HTableDescriptor> list = new ArrayList<HTableDescriptor>();
        for (String table : tableNames) {
            list.add(this.getTableDescriptor(Bytes.toBytes(table)));
        }
        return list.toArray(new HTableDescriptor[list.size()]);
    }

    public synchronized byte[][] rollHLogWriter(String serverName) throws IOException, FailedLogCloseException {
        if (this.checkIfMapRDefault(true)) {
            this.LOG.warn((Object)"rollHLogWriter() called for a MapR cluster, returning null.");
            return null;
        }
        ServerName sn = new ServerName(serverName);
        HRegionInterface rs = this.connection.getHRegionConnection(sn.getHostname(), sn.getPort());
        return rs.rollHLogWriter();
    }

    public String[] getMasterCoprocessors() {
        try {
            if (this.checkIfMapRDefault(true)) {
                this.LOG.warn((Object)"getMasterCoprocessors() called for a MapR cluster, returning empty.");
                return new String[0];
            }
            return this.getClusterStatus().getMasterCoprocessors();
        }
        catch (IOException e) {
            this.LOG.error((Object)"Could not getClusterStatus()", (Throwable)e);
            return null;
        }
    }

    public CompactionRequest.CompactionState getCompactionState(String tableNameOrRegionName) throws IOException, InterruptedException {
        return this.getCompactionState(Bytes.toBytes(tableNameOrRegionName));
    }

    /*
     * Exception decompiling
     */
    public CompactionRequest.CompactionState getCompactionState(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 8[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol) {
        try {
            if (this.checkIfMapRDefault(true)) {
                this.LOG.warn((Object)"getMasterCoprocessors() called for a MapR cluster, returning null.");
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)((CoprocessorProtocol)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{protocol}, (InvocationHandler)new MasterExecRPCInvoker(this.conf, this.connection, protocol)));
    }

    public void snapshot(String snapshotName, String tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, tableName, HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(byte[] snapshotName, byte[] tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString(snapshotName), Bytes.toString(tableName));
    }

    public void snapshot(String snapshotName, String tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        if (this.checkIfMapRTable(tableName, true)) {
            throw new IllegalArgumentException("snapshot() called for a MapR Table.");
        }
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        builder.setTable(tableName);
        builder.setName(snapshotName);
        builder.setType(type);
        this.snapshot(builder.build());
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        if (this.checkIfMapRTable(snapshot.getTable(), true)) {
            throw new IllegalArgumentException("snapshot() called for a MapR Table.");
        }
        HSnapshotDescription snapshotWritable = new HSnapshotDescription(snapshot);
        try {
            long max = this.takeSnapshotAsync(snapshot);
            long start = EnvironmentEdgeManager.currentTimeMillis();
            long maxPauseTime = max / (long)this.numRetries;
            boolean done = false;
            int tries = 0;
            this.LOG.debug((Object)("Waiting a max of " + max + " ms for snapshot '" + SnapshotDescriptionUtils.toString(snapshot) + "' to complete. (max " + maxPauseTime + " ms per retry)"));
            while (tries == 0 || EnvironmentEdgeManager.currentTimeMillis() - start < max && !done) {
                try {
                    long sleep = this.getPauseTime(tries++);
                    sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                    this.LOG.debug((Object)("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for snapshot completion."));
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    this.LOG.debug((Object)("Interrupted while waiting for snapshot " + snapshot + " to complete"));
                    Thread.currentThread().interrupt();
                }
                this.LOG.debug((Object)"Getting current status of snapshot from master...");
                done = this.getMaster().isSnapshotDone(snapshotWritable);
            }
            if (!done) {
                throw new SnapshotCreationException("Snapshot '" + snapshot.getName() + "' wasn't completed in expectedTime:" + max + " ms", snapshot);
            }
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public long takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        if (this.checkIfMapRTable(snapshot.getTable(), true)) {
            throw new IllegalArgumentException("takeSnapshotAsync() called for a MapR Table.");
        }
        SnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        HSnapshotDescription snapshotWritable = new HSnapshotDescription(snapshot);
        return this.getMaster().snapshot(snapshotWritable);
    }

    public boolean isSnapshotFinished(HBaseProtos.SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        if (this.checkIfMapRTable(snapshot.getTable(), true)) {
            throw new UnsupportedOperationException("isSnapshotFinished() called for a MapR Table.");
        }
        try {
            return this.getMaster().isSnapshotDone(new HSnapshotDescription(snapshot));
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public void restoreSnapshot(byte[] snapshotName) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(Bytes.toString(snapshotName));
    }

    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        this.ensureConnectedToHBase();
        String rollbackSnapshot = snapshotName + "-" + EnvironmentEdgeManager.currentTimeMillis();
        String tableName = null;
        for (HBaseProtos.SnapshotDescription snapshotInfo : this.listSnapshots()) {
            if (!snapshotInfo.getName().equals(snapshotName)) continue;
            tableName = snapshotInfo.getTable();
            break;
        }
        if (tableName == null) {
            throw new RestoreSnapshotException("Unable to find the table name for snapshot=" + snapshotName);
        }
        if (this.checkIfMapRTable(tableName, true)) {
            throw new UnsupportedOperationException("restoreSnapshot called for a MapR Table.");
        }
        this.snapshot(rollbackSnapshot, tableName);
        try {
            this.internalRestoreSnapshot(snapshotName, tableName);
        }
        catch (IOException e) {
            try {
                String msg = "Restore snapshot=" + snapshotName + " failed. Rollback to snapshot=" + rollbackSnapshot + " succeeded.";
                this.LOG.error((Object)msg, (Throwable)e);
                this.internalRestoreSnapshot(rollbackSnapshot, tableName);
                throw new RestoreSnapshotException(msg, e);
            }
            catch (IOException ex) {
                String msg = "Failed to restore and rollback to snapshot=" + rollbackSnapshot;
                this.LOG.error((Object)msg, (Throwable)ex);
                throw new RestoreSnapshotException(msg, ex);
            }
        }
    }

    public void cloneSnapshot(byte[] snapshotName, byte[] tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        this.cloneSnapshot(Bytes.toString(snapshotName), Bytes.toString(tableName));
    }

    public void cloneSnapshot(String snapshotName, String tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        if (this.tableExists(tableName)) {
            throw new TableExistsException("Table '" + tableName + " already exists");
        }
        this.internalRestoreSnapshot(snapshotName, tableName);
        this.waitUntilTableIsEnabled(Bytes.toBytes(tableName));
    }

    private void internalRestoreSnapshot(String snapshotName, String tableName) throws IOException, RestoreSnapshotException {
        HSnapshotDescription snapshot = new HSnapshotDescription(HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).setTable(tableName).build());
        if (this.checkIfMapRTable(tableName, true)) {
            throw new UnsupportedOperationException("restoreSnapshot called for a MapR Table.");
        }
        try {
            this.getMaster().restoreSnapshot(snapshot);
            long maxPauseTime = 5000L;
            boolean done = false;
            int tries = 0;
            while (!done) {
                try {
                    long sleep = this.getPauseTime(tries++);
                    sleep = sleep > 5000L ? 5000L : sleep;
                    this.LOG.debug((Object)(tries + ") Sleeping: " + sleep + " ms while we wait for snapshot restore to complete."));
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    this.LOG.debug((Object)("Interrupted while waiting for snapshot " + snapshot + " restore to complete"));
                    Thread.currentThread().interrupt();
                }
                this.LOG.debug((Object)"Getting current status of snapshot restore from master...");
                done = this.getMaster().isRestoreSnapshotDone(snapshot);
            }
            if (!done) {
                throw new RestoreSnapshotException("Snapshot '" + snapshot.getName() + "' wasn't restored.");
            }
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        this.ensureConnectedToHBase();
        LinkedList<HBaseProtos.SnapshotDescription> snapshots = new LinkedList<HBaseProtos.SnapshotDescription>();
        try {
            for (HSnapshotDescription snapshot : this.getMaster().getCompletedSnapshots()) {
                snapshots.add(snapshot.getProto());
            }
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
        return snapshots;
    }

    public void deleteSnapshot(byte[] snapshotName) throws IOException {
        this.ensureConnectedToHBase();
        HTableDescriptor.isLegalTableName(snapshotName);
        HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName(Bytes.toString(snapshotName)).build();
        try {
            this.getMaster().deleteSnapshot(new HSnapshotDescription(snapshot));
        }
        catch (RemoteException e) {
            throw RemoteExceptionHandler.decodeRemoteException(e);
        }
    }

    public void deleteSnapshot(String snapshotName) throws IOException {
        this.ensureConnectedToHBase();
        this.deleteSnapshot(Bytes.toBytes(snapshotName));
    }

    static class 5 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$hadoop$hbase$regionserver$compactions$CompactionRequest$CompactionState;

        static {
            $SwitchMap$org$apache$hadoop$hbase$regionserver$compactions$CompactionRequest$CompactionState = new int[CompactionRequest.CompactionState.values().length];
            try {
                5.$SwitchMap$org$apache$hadoop$hbase$regionserver$compactions$CompactionRequest$CompactionState[CompactionRequest.CompactionState.MAJOR_AND_MINOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$apache$hadoop$hbase$regionserver$compactions$CompactionRequest$CompactionState[CompactionRequest.CompactionState.MAJOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$apache$hadoop$hbase$regionserver$compactions$CompactionRequest$CompactionState[CompactionRequest.CompactionState.MINOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$apache$hadoop$hbase$regionserver$compactions$CompactionRequest$CompactionState[CompactionRequest.CompactionState.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    abstract class HBaseConnector {
        HBaseConnector() {
        }

        abstract void connect() throws ZooKeeperConnectionException, MasterNotRunningException;
    }
}

