/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;

public class CoprocessorHConnection
extends HConnectionManager.HConnectionImplementation {
    private ServerName serverName;
    private HRegionServer server;

    public static HConnection getConnectionForEnvironment(CoprocessorEnvironment env) throws IOException {
        RegionCoprocessorEnvironment e;
        RegionServerServices services;
        Configuration conf = env.getConfiguration();
        HConnection connection = null;
        if (env instanceof RegionCoprocessorEnvironment && (services = (e = (RegionCoprocessorEnvironment)env).getRegionServerServices()) instanceof HRegionServer) {
            connection = new CoprocessorHConnection(conf, (HRegionServer)services);
        }
        if (connection == null) {
            connection = HConnectionManager.createConnection(conf);
        }
        return connection;
    }

    CoprocessorHConnection(Configuration conf, HRegionServer server) throws IOException {
        super(conf, false, null);
        this.server = server;
        this.serverName = server.getServerName();
    }

    @Override
    HRegionInterface getHRegionConnection(String hostname, int port, InetSocketAddress isa, boolean master) throws IOException {
        boolean isRemote = false;
        isRemote = isa != null ? this.checkRemote(isa.getHostName(), isa.getPort()) : this.checkRemote(hostname, port);
        if (isRemote) {
            return super.getHRegionConnection(hostname, port, isa, master);
        }
        return this.server;
    }

    private boolean checkRemote(String hostName, int port) {
        return !this.serverName.getHostname().equals(hostName) || this.serverName.getPort() != port;
    }
}

