/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class HColumnDescriptor
implements WritableComparable<HColumnDescriptor> {
    private static final byte COLUMN_DESCRIPTOR_VERSION = 9;
    public static final String COMPRESSION = "COMPRESSION";
    public static final String COMPRESSION_COMPACT = "COMPRESSION_COMPACT";
    public static final String ENCODE_ON_DISK = "ENCODE_ON_DISK";
    public static final String DATA_BLOCK_ENCODING = "DATA_BLOCK_ENCODING";
    public static final String BLOCKCACHE = "BLOCKCACHE";
    public static final String CACHE_DATA_ON_WRITE = "CACHE_DATA_ON_WRITE";
    public static final String CACHE_INDEX_ON_WRITE = "CACHE_INDEX_ON_WRITE";
    public static final String CACHE_BLOOMS_ON_WRITE = "CACHE_BLOOMS_ON_WRITE";
    public static final String EVICT_BLOCKS_ON_CLOSE = "EVICT_BLOCKS_ON_CLOSE";
    public static final String BLOCKSIZE = "BLOCKSIZE";
    public static final String LENGTH = "LENGTH";
    public static final String TTL = "TTL";
    public static final String BLOOMFILTER = "BLOOMFILTER";
    public static final String FOREVER = "FOREVER";
    public static final String REPLICATION_SCOPE = "REPLICATION_SCOPE";
    public static final String MIN_VERSIONS = "MIN_VERSIONS";
    public static final String KEEP_DELETED_CELLS = "KEEP_DELETED_CELLS";
    public static final String DEFAULT_COMPRESSION = Compression.Algorithm.NONE.getName();
    public static final boolean DEFAULT_ENCODE_ON_DISK = true;
    public static final String DEFAULT_DATA_BLOCK_ENCODING = DataBlockEncoding.NONE.toString();
    public static final int DEFAULT_VERSIONS = 3;
    public static final int DEFAULT_MIN_VERSIONS = 0;
    private volatile Integer blocksize = null;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final boolean DEFAULT_KEEP_DELETED = false;
    public static final boolean DEFAULT_BLOCKCACHE = true;
    public static final boolean DEFAULT_CACHE_DATA_ON_WRITE = false;
    public static final boolean DEFAULT_CACHE_INDEX_ON_WRITE = false;
    public static final int DEFAULT_BLOCKSIZE = 65536;
    public static final String DEFAULT_BLOOMFILTER = StoreFile.BloomType.NONE.toString();
    public static final boolean DEFAULT_CACHE_BLOOMS_ON_WRITE = false;
    public static final int DEFAULT_TTL = Integer.MAX_VALUE;
    public static final int DEFAULT_REPLICATION_SCOPE = 0;
    public static final boolean DEFAULT_EVICT_BLOCKS_ON_CLOSE = false;
    private static final Map<String, String> DEFAULT_VALUES = new HashMap<String, String>();
    private static final Set<ImmutableBytesWritable> RESERVED_KEYWORDS = new HashSet<ImmutableBytesWritable>();
    private byte[] name;
    protected final Map<ImmutableBytesWritable, ImmutableBytesWritable> values = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();

    public HColumnDescriptor() {
        this.name = null;
    }

    public HColumnDescriptor(String familyName) {
        this(Bytes.toBytes(familyName));
    }

    public HColumnDescriptor(byte[] familyName) {
        this(familyName == null || familyName.length <= 0 ? HConstants.EMPTY_BYTE_ARRAY : familyName, 3, null, false, true, Integer.MAX_VALUE, DEFAULT_BLOOMFILTER);
    }

    public HColumnDescriptor(HColumnDescriptor desc) {
        this.name = (byte[])desc.name.clone();
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : desc.values.entrySet()) {
            this.values.put(e.getKey(), e.getValue());
        }
        this.setMaxVersions(desc.getMaxVersions());
    }

    @Deprecated
    public HColumnDescriptor(byte[] familyName, int maxVersions, String compression, boolean inMemory, boolean blockCacheEnabled, int timeToLive, String bloomFilter) {
        this(familyName, maxVersions, compression, inMemory, blockCacheEnabled, 65536, timeToLive, bloomFilter, 0);
    }

    @Deprecated
    public HColumnDescriptor(byte[] familyName, int maxVersions, String compression, boolean inMemory, boolean blockCacheEnabled, int blocksize, int timeToLive, String bloomFilter, int scope) {
        this(familyName, 0, maxVersions, false, compression, true, DEFAULT_DATA_BLOCK_ENCODING, inMemory, blockCacheEnabled, blocksize, timeToLive, bloomFilter, scope);
    }

    @Deprecated
    public HColumnDescriptor(byte[] familyName, int minVersions, int maxVersions, boolean keepDeletedCells, String compression, boolean encodeOnDisk, String dataBlockEncoding, boolean inMemory, boolean blockCacheEnabled, int blocksize, int timeToLive, String bloomFilter, int scope) {
        HColumnDescriptor.isLegalFamilyName(familyName);
        this.name = familyName;
        if (maxVersions <= 0) {
            throw new IllegalArgumentException("Maximum versions must be positive");
        }
        if (minVersions > 0) {
            if (timeToLive == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Minimum versions requires TTL.");
            }
            if (minVersions >= maxVersions) {
                throw new IllegalArgumentException("Minimum versions must be < maximum versions.");
            }
        }
        this.setMaxVersions(maxVersions);
        this.setMinVersions(minVersions);
        this.setKeepDeletedCells(keepDeletedCells);
        this.setInMemory(inMemory);
        this.setBlockCacheEnabled(blockCacheEnabled);
        this.setTimeToLive(timeToLive);
        if (compression != null) {
            this.setCompressionType(Compression.Algorithm.valueOf(compression.toUpperCase()));
        }
        this.setEncodeOnDisk(encodeOnDisk);
        this.setDataBlockEncoding(DataBlockEncoding.valueOf(dataBlockEncoding.toUpperCase()));
        this.setBloomFilterType(StoreFile.BloomType.valueOf(bloomFilter.toUpperCase()));
        this.setBlocksize(blocksize);
        this.setScope(scope);
    }

    public static byte[] isLegalFamilyName(byte[] b) {
        if (b == null) {
            return b;
        }
        if (b[0] == 46) {
            throw new IllegalArgumentException("Family names cannot start with a period: " + Bytes.toString(b));
        }
        for (int i = 0; i < b.length; ++i) {
            if (!Character.isISOControl(b[i]) && b[i] != 58 && b[i] != 92 && b[i] != 47) continue;
            throw new IllegalArgumentException("Illegal character <" + b[i] + ">. Family names cannot contain control characters or colons: " + Bytes.toString(b));
        }
        byte[] recoveredEdit = Bytes.toBytes("recovered.edits");
        if (Bytes.equals(recoveredEdit, b)) {
            throw new IllegalArgumentException("Family name cannot be: recovered.edits");
        }
        return b;
    }

    public byte[] getName() {
        return this.name;
    }

    public String getNameAsString() {
        return Bytes.toString(this.name);
    }

    public byte[] getValue(byte[] key) {
        ImmutableBytesWritable ibw = this.values.get(new ImmutableBytesWritable(key));
        if (ibw == null) {
            return null;
        }
        return ibw.get();
    }

    public String getValue(String key) {
        byte[] value = this.getValue(Bytes.toBytes(key));
        if (value == null) {
            return null;
        }
        return Bytes.toString(value);
    }

    public Map<ImmutableBytesWritable, ImmutableBytesWritable> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public HColumnDescriptor setValue(byte[] key, byte[] value) {
        this.values.put(new ImmutableBytesWritable(key), new ImmutableBytesWritable(value));
        return this;
    }

    public void remove(byte[] key) {
        this.values.remove(new ImmutableBytesWritable(key));
    }

    public HColumnDescriptor setValue(String key, String value) {
        if (value == null) {
            this.remove(Bytes.toBytes(key));
        } else {
            this.setValue(Bytes.toBytes(key), Bytes.toBytes(value));
        }
        return this;
    }

    public Compression.Algorithm getCompression() {
        String n = this.getValue(COMPRESSION);
        if (n == null) {
            return Compression.Algorithm.NONE;
        }
        return Compression.Algorithm.valueOf(n.toUpperCase());
    }

    public Compression.Algorithm getCompactionCompression() {
        String n = this.getValue(COMPRESSION_COMPACT);
        if (n == null) {
            return this.getCompression();
        }
        return Compression.Algorithm.valueOf(n.toUpperCase());
    }

    public int getMaxVersions() {
        String value = this.getValue("VERSIONS");
        return value != null ? Integer.valueOf(value) : 0;
    }

    public HColumnDescriptor setMaxVersions(int maxVersions) {
        this.setValue("VERSIONS", Integer.toString(maxVersions));
        return this;
    }

    public synchronized int getBlocksize() {
        if (this.blocksize == null) {
            String value = this.getValue(BLOCKSIZE);
            this.blocksize = value != null ? Integer.decode(value) : Integer.valueOf(65536);
        }
        return this.blocksize;
    }

    public HColumnDescriptor setBlocksize(int s) {
        this.setValue(BLOCKSIZE, Integer.toString(s));
        this.blocksize = null;
        return this;
    }

    public Compression.Algorithm getCompressionType() {
        return this.getCompression();
    }

    public HColumnDescriptor setCompressionType(Compression.Algorithm type) {
        return this.setValue(COMPRESSION, type.getName().toUpperCase());
    }

    public DataBlockEncoding getDataBlockEncodingOnDisk() {
        String encodeOnDiskStr = this.getValue(ENCODE_ON_DISK);
        boolean encodeOnDisk = encodeOnDiskStr == null ? true : Boolean.valueOf(encodeOnDiskStr);
        if (!encodeOnDisk) {
            return DataBlockEncoding.NONE;
        }
        return this.getDataBlockEncoding();
    }

    public HColumnDescriptor setEncodeOnDisk(boolean encodeOnDisk) {
        return this.setValue(ENCODE_ON_DISK, String.valueOf(encodeOnDisk));
    }

    public DataBlockEncoding getDataBlockEncoding() {
        String type = this.getValue(DATA_BLOCK_ENCODING);
        if (type == null) {
            type = DEFAULT_DATA_BLOCK_ENCODING;
        }
        return DataBlockEncoding.valueOf(type);
    }

    public HColumnDescriptor setDataBlockEncoding(DataBlockEncoding type) {
        String name = type != null ? type.toString() : DataBlockEncoding.NONE.toString();
        return this.setValue(DATA_BLOCK_ENCODING, name);
    }

    public Compression.Algorithm getCompactionCompressionType() {
        return this.getCompactionCompression();
    }

    public HColumnDescriptor setCompactionCompressionType(Compression.Algorithm type) {
        return this.setValue(COMPRESSION_COMPACT, type.getName().toUpperCase());
    }

    public boolean isInMemory() {
        String value = this.getValue("IN_MEMORY");
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setInMemory(boolean inMemory) {
        return this.setValue("IN_MEMORY", Boolean.toString(inMemory));
    }

    public boolean getKeepDeletedCells() {
        String value = this.getValue(KEEP_DELETED_CELLS);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setKeepDeletedCells(boolean keepDeletedCells) {
        return this.setValue(KEEP_DELETED_CELLS, Boolean.toString(keepDeletedCells));
    }

    public int getTimeToLive() {
        String value = this.getValue(TTL);
        return value != null ? Integer.valueOf(value) : Integer.MAX_VALUE;
    }

    public HColumnDescriptor setTimeToLive(int timeToLive) {
        return this.setValue(TTL, Integer.toString(timeToLive));
    }

    public int getMinVersions() {
        String value = this.getValue(MIN_VERSIONS);
        return value != null ? Integer.valueOf(value) : 0;
    }

    public HColumnDescriptor setMinVersions(int minVersions) {
        return this.setValue(MIN_VERSIONS, Integer.toString(minVersions));
    }

    public boolean isBlockCacheEnabled() {
        String value = this.getValue(BLOCKCACHE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public HColumnDescriptor setBlockCacheEnabled(boolean blockCacheEnabled) {
        return this.setValue(BLOCKCACHE, Boolean.toString(blockCacheEnabled));
    }

    public StoreFile.BloomType getBloomFilterType() {
        String n = this.getValue(BLOOMFILTER);
        if (n == null) {
            n = DEFAULT_BLOOMFILTER;
        }
        return StoreFile.BloomType.valueOf(n.toUpperCase());
    }

    public HColumnDescriptor setBloomFilterType(StoreFile.BloomType bt) {
        return this.setValue(BLOOMFILTER, bt.toString());
    }

    public int getScope() {
        String value = this.getValue(REPLICATION_SCOPE);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return 0;
    }

    public HColumnDescriptor setScope(int scope) {
        return this.setValue(REPLICATION_SCOPE, Integer.toString(scope));
    }

    public boolean shouldCacheDataOnWrite() {
        String value = this.getValue(CACHE_DATA_ON_WRITE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setCacheDataOnWrite(boolean value) {
        return this.setValue(CACHE_DATA_ON_WRITE, Boolean.toString(value));
    }

    public boolean shouldCacheIndexesOnWrite() {
        String value = this.getValue(CACHE_INDEX_ON_WRITE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setCacheIndexesOnWrite(boolean value) {
        return this.setValue(CACHE_INDEX_ON_WRITE, Boolean.toString(value));
    }

    public boolean shouldCacheBloomsOnWrite() {
        String value = this.getValue(CACHE_BLOOMS_ON_WRITE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setCacheBloomsOnWrite(boolean value) {
        return this.setValue(CACHE_BLOOMS_ON_WRITE, Boolean.toString(value));
    }

    public boolean shouldEvictBlocksOnClose() {
        String value = this.getValue(EVICT_BLOCKS_ON_CLOSE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setEvictBlocksOnClose(boolean value) {
        return this.setValue(EVICT_BLOCKS_ON_CLOSE, Boolean.toString(value));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(Bytes.toString(this.name));
        s.append("'");
        s.append((CharSequence)this.getValues(true));
        s.append('}');
        return s.toString();
    }

    public String toStringCustomizedValues() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(Bytes.toString(this.name));
        s.append("'");
        s.append((CharSequence)this.getValues(false));
        s.append('}');
        return s.toString();
    }

    private StringBuilder getValues(boolean printDefaults) {
        StringBuilder s = new StringBuilder();
        boolean hasConfigKeys = false;
        for (ImmutableBytesWritable k : this.values.keySet()) {
            if (!RESERVED_KEYWORDS.contains(k)) {
                hasConfigKeys = true;
                continue;
            }
            String key = Bytes.toString(k.get());
            String value = Bytes.toString(this.values.get(k).get());
            if (!printDefaults && DEFAULT_VALUES.containsKey(key) && DEFAULT_VALUES.get(key).equalsIgnoreCase(value)) continue;
            s.append(", ");
            s.append(key);
            s.append(" => ");
            s.append('\'').append(value).append('\'');
        }
        if (hasConfigKeys) {
            s.append(", ");
            s.append("CONFIG").append(" => ");
            s.append('{');
            boolean printComma = false;
            for (ImmutableBytesWritable k : this.values.keySet()) {
                if (RESERVED_KEYWORDS.contains(k)) continue;
                String key = Bytes.toString(k.get());
                String value = Bytes.toString(this.values.get(k).get());
                if (printComma) {
                    s.append(", ");
                }
                printComma = true;
                s.append('\'').append(key).append('\'');
                s.append(" => ");
                s.append('\'').append(value).append('\'');
            }
            s.append('}');
        }
        return s;
    }

    public static Map<String, String> getDefaultValues() {
        return Collections.unmodifiableMap(DEFAULT_VALUES);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HColumnDescriptor)) {
            return false;
        }
        return this.compareTo((HColumnDescriptor)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.name);
        result ^= Byte.valueOf((byte)9).hashCode();
        return result ^= ((Object)this.values).hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version < 6) {
            if (version <= 2) {
                Text t = new Text();
                t.readFields(in);
                this.name = t.getBytes();
            } else {
                this.name = Bytes.readByteArray(in);
            }
            this.values.clear();
            this.setMaxVersions(in.readInt());
            int ordinal = in.readInt();
            this.setCompressionType(Compression.Algorithm.values()[ordinal]);
            this.setInMemory(in.readBoolean());
            this.setBloomFilterType(in.readBoolean() ? StoreFile.BloomType.ROW : StoreFile.BloomType.NONE);
            if (this.getBloomFilterType() != StoreFile.BloomType.NONE && version < 5) {
                throw new UnsupportedClassVersionError(this.getClass().getName() + " does not support backward compatibility with versions older " + "than version 5");
            }
            if (version > 1) {
                this.setBlockCacheEnabled(in.readBoolean());
            }
            if (version > 2) {
                this.setTimeToLive(in.readInt());
            }
        } else {
            this.name = Bytes.readByteArray(in);
            this.values.clear();
            int numValues = in.readInt();
            for (int i = 0; i < numValues; ++i) {
                ImmutableBytesWritable key = new ImmutableBytesWritable();
                ImmutableBytesWritable value = new ImmutableBytesWritable();
                key.readFields(in);
                value.readFields(in);
                if (version < 8 && Bytes.toString(key.get()).equals(BLOOMFILTER)) {
                    value.set(Bytes.toBytes(Boolean.getBoolean(Bytes.toString(value.get())) ? StoreFile.BloomType.ROW.toString() : StoreFile.BloomType.NONE.toString()));
                }
                this.values.put(key, value);
            }
            if (version == 6) {
                this.setValue(COMPRESSION, Compression.Algorithm.NONE.getName());
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(9);
        Bytes.writeByteArray(out, this.name);
        out.writeInt(this.values.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            e.getKey().write(out);
            e.getValue().write(out);
        }
    }

    public int compareTo(HColumnDescriptor o) {
        int result = Bytes.compareTo(this.name, o.getName());
        if (result == 0) {
            result = ((Object)this.values).hashCode() - ((Object)o.values).hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        return result;
    }

    public void validate() {
        if (this.getMinVersions() > this.getMaxVersions()) {
            throw new IllegalArgumentException(String.format("Min versions (%d) can not be greater than Max versions (%d).", this.getMinVersions(), this.getMaxVersions()));
        }
    }

    public HColumnDescriptor setValueBool(String key, boolean value) {
        this.setValue(key, Boolean.toString(value));
        return this;
    }

    public HColumnDescriptor setValueInt(String key, int value) {
        this.setValue(key, Integer.toString(value));
        return this;
    }

    public HColumnDescriptor setValueStr(String key, String value) {
        this.setValue(key, value);
        return this;
    }

    static {
        DEFAULT_VALUES.put(BLOOMFILTER, DEFAULT_BLOOMFILTER);
        DEFAULT_VALUES.put(REPLICATION_SCOPE, String.valueOf(0));
        DEFAULT_VALUES.put("VERSIONS", String.valueOf(3));
        DEFAULT_VALUES.put(MIN_VERSIONS, String.valueOf(0));
        DEFAULT_VALUES.put(COMPRESSION, DEFAULT_COMPRESSION);
        DEFAULT_VALUES.put(TTL, String.valueOf(Integer.MAX_VALUE));
        DEFAULT_VALUES.put(BLOCKSIZE, String.valueOf(65536));
        DEFAULT_VALUES.put("IN_MEMORY", String.valueOf(false));
        DEFAULT_VALUES.put(BLOCKCACHE, String.valueOf(true));
        DEFAULT_VALUES.put(KEEP_DELETED_CELLS, String.valueOf(false));
        DEFAULT_VALUES.put(ENCODE_ON_DISK, String.valueOf(true));
        DEFAULT_VALUES.put(DATA_BLOCK_ENCODING, String.valueOf(DEFAULT_DATA_BLOCK_ENCODING));
        DEFAULT_VALUES.put(CACHE_DATA_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(CACHE_INDEX_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(CACHE_BLOOMS_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(EVICT_BLOCKS_ON_CLOSE, String.valueOf(false));
        for (String s : DEFAULT_VALUES.keySet()) {
            RESERVED_KEYWORDS.add(new ImmutableBytesWritable(Bytes.toBytes(s)));
        }
    }
}

