/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.session;

import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import pt.webdetails.cpf.session.IUserSession;

public class PentahoSession
implements IUserSession {
    private IPentahoSession userSession;

    public PentahoSession() {
        this(null);
    }

    public PentahoSession(IPentahoSession userSession) {
        this.userSession = userSession == null ? PentahoSessionHolder.getSession() : userSession;
    }

    public String getUserName() {
        return this.userSession.getName();
    }

    public boolean isAdministrator() {
        return SecurityHelper.getInstance().isPentahoAdministrator(this.userSession);
    }

    public IPentahoSession getPentahoSession() {
        return this.userSession;
    }

    public String[] getAuthorities() {
        Authentication auth = SecurityHelper.getInstance().getAuthentication(PentahoSessionHolder.getSession(), true);
        GrantedAuthority[] authorities = auth.getAuthorities();
        String[] result = new String[authorities.length];
        int i = 0;
        for (GrantedAuthority authority : authorities) {
            result[i++] = authority.getAuthority();
        }
        return result;
    }

    public Object getParameter(String name) {
        if (name != null) {
            return this.userSession.getAttribute(name.toString());
        }
        return null;
    }

    public String getStringParameter(String name) {
        Object r = this.getParameter(name);
        if (r != null) {
            return r.toString();
        }
        return null;
    }

    public void setParameter(String key, Object value) {
        this.userSession.setAttribute(key.toString(), value);
    }
}

