/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cpf.persistence.Filter;
import pt.webdetails.cpf.persistence.ISimplePersistence;
import pt.webdetails.cpf.persistence.Persistable;
import pt.webdetails.cpf.persistence.PersistenceEngine;

public class SimplePersistence
implements ISimplePersistence {
    private static SimplePersistence instance;
    private static final Log logger;

    private SimplePersistence() {
    }

    public static synchronized SimplePersistence getInstance() {
        if (instance == null) {
            instance = new SimplePersistence();
        }
        return instance;
    }

    @Override
    public <T extends Persistable> List<T> loadAll(Class<T> klass) {
        return this.load(klass, null);
    }

    @Override
    public void storeAll(Collection<? extends Persistable> items) {
        PersistenceEngine pe = PersistenceEngine.getInstance();
        for (Persistable persistable : items) {
            pe.store(persistable);
        }
    }

    @Override
    public void deleteAll(Collection<? extends Persistable> items) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void delete(Class<? extends Persistable> klass, Filter filter) {
        PersistenceEngine pe = PersistenceEngine.getInstance();
        String query = "delete from " + klass.getName();
        if (filter != null) {
            query = query + " where " + filter.toString();
        }
        try {
            pe.command(query, null);
        }
        catch (JSONException jse) {
            logger.error((Object)jse);
        }
    }

    @Override
    public <T extends Persistable> List<T> load(Class<T> klass, Filter filter) {
        ArrayList<Persistable> list = new ArrayList<Persistable>();
        PersistenceEngine pe = PersistenceEngine.getInstance();
        try {
            JSONObject json;
            String query = "select from " + klass.getName();
            if (filter != null) {
                query = query + " where " + filter.toString();
            }
            try {
                json = pe.query(query, null);
            }
            catch (RuntimeException e) {
                if (!pe.classExists(klass.getName())) {
                    pe.initializeClass(klass.getName());
                    json = pe.query(query, null);
                }
                json = null;
            }
            JSONArray arr = json.getJSONArray("object");
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject o = arr.getJSONObject(i);
                Persistable inst = (Persistable)klass.newInstance();
                try {
                    inst.fromJSON(o);
                    inst.setKey(o.getString("@rid"));
                    list.add(inst);
                    continue;
                }
                catch (JSONException e) {
                    // empty catch block
                }
            }
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (JSONException e) {
            return null;
        }
        return list;
    }

    static {
        logger = LogFactory.getLog(SimplePersistence.class);
    }
}

