/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.html.tags.transmenu;

import java.util.List;
import java.util.Map;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.containers.XulMenu;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.html.AbstractHtmlContainer;
import org.pentaho.ui.xul.html.tags.transmenu.HtmlMenubar;
import org.pentaho.ui.xul.html.tags.transmenu.HtmlMenuitem;
import org.pentaho.ui.xul.html.tags.transmenu.HtmlMenupopup;

public class HtmlMenu
extends AbstractHtmlContainer
implements XulMenu {
    private String label;

    public HtmlMenu(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super(tagName);
    }

    @Override
    public void getHtml(StringBuilder sb) {
        if (this.getParent() instanceof HtmlMenubar) {
            sb.append("<a id=\"").append(this.getId()).append("\" href=\"");
            if (this.getChildNodes().size() > 0) {
                XulComponent child = (XulComponent)this.getChildNodes().get(0);
                if (child instanceof HtmlMenuitem) {
                    sb.append(((HtmlMenuitem)child).getCommand());
                    sb.append("\">");
                } else {
                    sb.append("#\">");
                }
            }
            sb.append(this.getLabel()).append("</a>\n");
        }
    }

    @Override
    public void getScript(Map<String, String> properties, StringBuilder sb) {
        String parentJscriptVar = "menu";
        if (this.getParent() instanceof HtmlMenubar) {
            sb.append("var menu").append(" = ms.addMenu(document.getElementById(\"").append(this.getId()).append("\"));\n");
        } else if (this.getParent() instanceof HtmlMenupopup) {
            parentJscriptVar = "submenu";
            HtmlMenupopup parent = (HtmlMenupopup)this.getParent();
            List siblings = parent.getChildNodes();
            int index = 0;
            for (XulComponent component : siblings) {
                if (component == this) {
                    sb.append("menu.addItem(\"").append(this.getLabel()).append("\", \"\" );\n");
                    sb.append("var submenu").append(" = menu.addMenu( menu.items[").append(index).append("] );\n");
                }
                ++index;
            }
        }
        XulComponent child = (XulComponent)this.getChildNodes().get(0);
        if (child instanceof HtmlMenupopup) {
            properties.put("parentJscriptVar", parentJscriptVar);
            ((HtmlMenupopup)child).getScript(properties, sb);
            properties.put("parentJscriptVar", "menu");
            sb.append("menu.onactivate = function() { document.getElementById(\"").append(this.getId()).append("\").className = \"hover\"; };\n").append("menu.ondeactivate = function() { document.getElementById(\"").append(this.getId()).append("\").className = \"\"; };\n");
        } else {
            sb.append("topLevelMenuItems[topLevelMenuItems.length] = '").append(this.getId()).append("';\n");
        }
    }

    public String getAcceltext() {
        return null;
    }

    public String getAccesskey() {
        return null;
    }

    public String getLabel() {
        XulComponent child;
        if (this.getChildNodes().size() > 0 && (child = (XulComponent)this.getChildNodes().get(0)) instanceof HtmlMenuitem) {
            return ((HtmlMenuitem)child).getLabel();
        }
        return this.label;
    }

    public void setAcceltext(String accel) {
    }

    public void setAccesskey(String accessKey) {
    }

    public void setLabel(String label) {
        XulComponent child;
        if (this.getChildNodes().size() > 0 && (child = (XulComponent)this.getChildNodes().get(0)) instanceof HtmlMenuitem && !label.equals(((HtmlMenuitem)child).getLabel())) {
            this.label = label;
            ((HtmlMenuitem)child).setLabel(label);
            return;
        }
        this.label = label;
    }

    @Override
    public void adoptAttributes(XulComponent component) {
    }
}

