/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.optimizer.AllSameRalationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LOForEach
extends LogicalRelationalOperator {
    private static final long serialVersionUID = 2L;
    private LogicalPlan innerPlan;

    public LOForEach(OperatorPlan plan) {
        super("LOForEach", plan);
    }

    public LogicalPlan getInnerPlan() {
        return this.innerPlan;
    }

    public void setInnerPlan(LogicalPlan p) {
        this.innerPlan = p;
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (!(other instanceof LOForEach)) {
            return false;
        }
        return this.innerPlan.isEqual(((LOForEach)other).innerPlan);
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        List<Operator> ll = this.innerPlan.getSinks();
        if (ll != null) {
            this.schema = ((LogicalRelationalOperator)ll.get(0)).getSchema();
        }
        return this.schema;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2222);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    public static Pair<List<LOInnerLoad>, Boolean> findReacheableInnerLoadFromBoundaryProject(ProjectExpression project) throws FrontendException {
        boolean needNewUid = false;
        LogicalRelationalOperator referred = project.findReferent();
        if (referred instanceof LOForEach) {
            needNewUid = true;
        }
        List<Operator> srcs = referred.getPlan().getSources();
        ArrayList<LOInnerLoad> innerLoads = new ArrayList<LOInnerLoad>();
        block0: for (Operator src : srcs) {
            if (!(src instanceof LOInnerLoad)) continue;
            if (src == referred) {
                innerLoads.add((LOInnerLoad)src);
                continue;
            }
            LinkedList<Operator> stack = new LinkedList<Operator>();
            List<Operator> succs = referred.getPlan().getSuccessors(src);
            if (succs != null) {
                for (Operator succ : succs) {
                    stack.push(succ);
                }
            }
            while (!stack.isEmpty()) {
                Operator op = (Operator)stack.pop();
                if (op == referred) {
                    innerLoads.add((LOInnerLoad)src);
                    continue block0;
                }
                List<Operator> ops = referred.getPlan().getSuccessors(op);
                if (ops == null) continue;
                for (Operator o : ops) {
                    stack.push(o);
                }
            }
        }
        return new Pair<List<LOInnerLoad>, Boolean>(innerLoads, needNewUid);
    }

    public LogicalSchema dumpNestedSchema(String alias, String nestedAlias) throws FrontendException {
        NestedRelationalOperatorFinder opFinder = new NestedRelationalOperatorFinder(this.innerPlan, nestedAlias);
        opFinder.visit();
        if (opFinder.getMatchedOperator() != null) {
            LogicalSchema nestedSc = opFinder.getMatchedOperator().getSchema();
            return nestedSc;
        }
        return null;
    }

    private static class NestedRelationalOperatorFinder
    extends AllSameRalationalNodesVisitor {
        String aliasOfOperator;
        LogicalRelationalOperator opFound = null;

        public NestedRelationalOperatorFinder(LogicalPlan plan, String alias) throws FrontendException {
            super(plan, new ReverseDependencyOrderWalker(plan));
            this.aliasOfOperator = alias;
        }

        public LogicalRelationalOperator getMatchedOperator() {
            return this.opFound;
        }

        @Override
        public void execute(LogicalRelationalOperator op) throws FrontendException {
            if (op.getAlias() != null && op.getAlias().equals(this.aliasOfOperator)) {
                this.opFound = op;
            }
        }
    }
}

