/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.beans;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.action.IVarArgsAction;
import org.pentaho.platform.util.beans.BeanUtil;
import org.pentaho.platform.util.beans.PropertyNameFormatter;
import org.pentaho.platform.util.beans.ValueSetErrorCallback;
import org.pentaho.platform.util.messages.Messages;

public class ActionHarness
extends BeanUtil {
    private VarArgsWrapperCallback varArgsCallback;
    private static final Log logger = LogFactory.getLog(ActionHarness.class);

    public ActionHarness(IAction actionBean) {
        super(actionBean);
        this.setDefaultCallback(new DefaultActionCallback());
        if (actionBean instanceof IVarArgsAction) {
            HashMap<String, Object> varArgsMap = new HashMap<String, Object>();
            ((IVarArgsAction)actionBean).setVarArgs(varArgsMap);
            this.varArgsCallback = new VarArgsWrapperCallback(varArgsMap);
        }
    }

    @Override
    public void setValue(String propertyName, Object value, ValueSetErrorCallback callback, PropertyNameFormatter ... formatters) throws Exception {
        if (this.varArgsCallback != null) {
            this.varArgsCallback.setWrappedCallback(callback);
            this.varArgsCallback.setValue(value);
            callback = this.varArgsCallback;
        }
        super.setValue(propertyName, value, callback, formatters);
    }

    public static class DefaultActionCallback
    extends BeanUtil.EagerFailingCallback {
        @Override
        public void propertyNotWritable(Object bean, String propertyName) throws Exception {
            String beanType;
            String string = beanType = bean != null ? bean.getClass().getName() : "[ClassNameNotAvailable]";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getInstance().getString("ActionHarness.WARN_NO_METHOD_FOR_PROPERTY", propertyName, beanType));
            }
        }
    }

    public static class VarArgsWrapperCallback
    implements ValueSetErrorCallback {
        private Map<String, Object> varArgsMap;
        private ValueSetErrorCallback wrappedCallback;
        private Object curValue;

        public VarArgsWrapperCallback(Map<String, Object> varArgsMap) {
            this.varArgsMap = varArgsMap;
        }

        public void setWrappedCallback(ValueSetErrorCallback wrappedCallback) {
            this.wrappedCallback = wrappedCallback;
        }

        public void setValue(Object value) throws Exception {
            this.curValue = value;
        }

        @Override
        public void failedToSetValue(Object targetBean, String propertyName, Object value, String beanPropertyType, Throwable cause) throws Exception {
            this.wrappedCallback.failedToSetValue(targetBean, propertyName, value, beanPropertyType, cause);
        }

        @Override
        public void propertyNotWritable(Object targetBean, String propertyName) throws Exception {
            if (this.varArgsMap != null) {
                this.varArgsMap.put(propertyName, this.curValue);
            }
        }
    }
}

