/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.util.ManifestUtil;
import org.pentaho.platform.util.VersionInfo;

public class VersionHelper
implements IVersionHelper {
    public String getVersionInformation() {
        return this.getVersionInformation(VersionHelper.class);
    }

    public String getVersionInformation(Class clazz) {
        ResourceBundle assemblyBundle = null;
        try {
            assemblyBundle = ResourceBundle.getBundle("server-assembly");
        }
        catch (MissingResourceException ignored) {
            // empty catch block
        }
        if (assemblyBundle != null) {
            return this.getVersionInformationFromProperties(assemblyBundle);
        }
        String implTitle = clazz.getPackage().getImplementationTitle();
        String implVersion = clazz.getPackage().getImplementationVersion();
        if (implVersion != null) {
            return implTitle + " " + implVersion;
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("build-res.version");
            StringBuffer buff = new StringBuffer();
            buff.append(bundle.getString("impl.title")).append(' ').append(bundle.getString("release.major.number")).append('.').append(bundle.getString("release.minor.number"));
            buff.append('.').append(bundle.getString("release.milestone.number")).append('.').append(bundle.getString("release.build.number")).append(" (class)");
            return buff.toString();
        }
        catch (Exception ex) {
            return "Pentaho BI Platform - No Version Information Available";
        }
    }

    public String getVersionInformationFromProperties(ResourceBundle assemblyBundle) {
        StringBuffer buff = new StringBuffer();
        buff.append(assemblyBundle.getString("assembly.title")).append(' ').append(assemblyBundle.getString("assembly.version"));
        return buff.toString();
    }

    public static VersionInfo getVersionInfo() {
        return VersionHelper.getVersionInfo(VersionHelper.class);
    }

    public static VersionInfo getVersionInfo(Class clazz) {
        ResourceBundle assemblyBundle = null;
        try {
            assemblyBundle = ResourceBundle.getBundle("server-assembly");
        }
        catch (MissingResourceException ignored) {
            // empty catch block
        }
        if (assemblyBundle != null) {
            return VersionHelper.getVersionInfoFromProperties(assemblyBundle);
        }
        Manifest manifest = ManifestUtil.getManifest(clazz);
        if (manifest != null) {
            return VersionHelper.createVersionInfo(manifest);
        }
        return VersionHelper.createVersionInfo();
    }

    protected static VersionInfo createVersionInfo(Manifest manifest) {
        VersionInfo versionInfo = new VersionInfo();
        Attributes mainAttributes = manifest.getMainAttributes();
        versionInfo.setFromManifest(true);
        versionInfo.setProductID(mainAttributes.getValue("Implementation-ProductID"));
        versionInfo.setTitle(mainAttributes.getValue("Implementation-Title"));
        versionInfo.setVersion(mainAttributes.getValue("Implementation-Version"));
        return versionInfo;
    }

    protected static VersionInfo createVersionInfo() {
        VersionInfo versionInfo = new VersionInfo();
        try {
            String[] parts;
            ResourceBundle bundle = ResourceBundle.getBundle("build-res.version");
            versionInfo.setFromManifest(false);
            versionInfo.setProductID(bundle.getString("impl.productID"));
            versionInfo.setTitle(bundle.getString("impl.title"));
            versionInfo.setVersionMajor(bundle.getString("release.major.number"));
            versionInfo.setVersionMinor(bundle.getString("release.minor.number"));
            versionInfo.setVersionBuild(bundle.getString("release.build.number"));
            String releaseMilestoneNumber = bundle.getString("release.milestone.number");
            if (releaseMilestoneNumber != null && (parts = releaseMilestoneNumber.replace('-', '.').split("\\.")).length > 0) {
                versionInfo.setVersionRelease(parts[0]);
                if (parts.length > 1) {
                    versionInfo.setVersionMilestone(parts[1]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return versionInfo;
    }

    protected static VersionInfo getVersionInfoFromProperties(ResourceBundle assemblyBundle) {
        VersionInfo versionInfo = new VersionInfo();
        try {
            versionInfo.setFromManifest(false);
            versionInfo.setTitle(assemblyBundle.getString("assembly.title"));
            versionInfo.setProductID(assemblyBundle.getString("assembly.productid"));
            versionInfo.setVersion(assemblyBundle.getString("assembly.version"));
        }
        catch (Exception ignored) {
            versionInfo.setVersionRelease("-error-");
        }
        return versionInfo;
    }
}

