/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component.xml;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.ui.UIException;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.services.SolutionURIResolver;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.uifoundation.component.xml.FilterPanel;
import org.pentaho.platform.uifoundation.component.xml.FilterPanelException;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.xml.sax.EntityResolver;

public class FilterPanelComponent
extends XmlComponent {
    private static final Log log = LogFactory.getLog(FilterPanelComponent.class);
    private static final long serialVersionUID = 700681534058825526L;
    private static final Log logger = LogFactory.getLog(FilterPanelComponent.class);
    private String definitionPath;
    private FilterPanel filterPanel;
    private String xslName;
    private Map defaultValues;

    public FilterPanelComponent(String definitionPath, String xslName, IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages, null);
        ActionInfo info;
        this.definitionPath = definitionPath;
        if (xslName == null) {
            xslName = "FilterPanelDefault.xsl";
        }
        if ((info = ActionInfo.parseActionString(definitionPath)) != null) {
            this.setSourcePath(info.getSolutionName() + File.separator + info.getPath());
        }
        this.xslName = xslName;
        this.defaultValues = new HashMap();
    }

    public void setDefaultValue(String filterName, String[] defaultValue) {
        this.defaultValues.put(filterName, defaultValue);
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    @Override
    public boolean validate() {
        return true;
    }

    public List getFilters() {
        return this.filterPanel.getFilters();
    }

    public boolean init() {
        if (this.filterPanel == null) {
            Document filterDocument = null;
            try {
                SAXReader reader = new SAXReader();
                reader.setEntityResolver((EntityResolver)((Object)new SolutionURIResolver()));
                filterDocument = reader.read(ActionSequenceResource.getInputStream(this.definitionPath, LocaleHelper.getLocale()));
            }
            catch (Throwable t) {
                logger.error((Object)Messages.getInstance().getString("FilterPanelComponent.ERROR_0002_CREATE_XML"), t);
                return false;
            }
            try {
                this.filterPanel = this.getFilterPanel(filterDocument);
            }
            catch (FilterPanelException e) {
                logger.error((Object)Messages.getInstance().getString("FilterPanelComponent.ERROR_0003_CREATE"), (Throwable)((Object)e));
                return false;
            }
        }
        return true;
    }

    @Override
    public Document getXmlContent() {
        boolean ok = this.filterPanel.populate(this.getParameterProviders(), this.defaultValues);
        if (!ok) {
            String msg = Messages.getInstance().getString("FilterPanelComponent.ERROR_0001_POPULATE");
            log.error((Object)msg);
            throw new UIException(msg);
        }
        String actionUrl = this.urlFactory.getActionUrlBuilder().getUrl();
        Document xForm = this.filterPanel.getXForm(actionUrl);
        this.setXsl("text/html", this.xslName);
        return xForm;
    }

    private FilterPanel getFilterPanel(Document filterDocument) throws FilterPanelException {
        FilterPanel newFilterPanel = new FilterPanel(this.getSession(), filterDocument, this);
        return newFilterPanel;
    }
}

