/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesCollection;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.uifoundation.chart.AbstractChartComponent;
import org.pentaho.platform.uifoundation.chart.AbstractJFreeChartComponent;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.chart.TimeSeriesCollectionChartDefinition;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class TimeSeriesCollectionChartComponent
extends AbstractJFreeChartComponent {
    private static final long serialVersionUID = -6268840271596447555L;
    protected String seriesName = null;

    public TimeSeriesCollectionChartComponent(int chartType, String definitionPath, int width, int height, IPentahoUrlFactory urlFactory, List messages) {
        super(chartType, definitionPath, width, height, urlFactory, messages);
    }

    public TimeSeriesCollectionChartComponent(String definitionPath, IPentahoUrlFactory urlFactory, ArrayList messages) {
        super(definitionPath, urlFactory, messages);
    }

    public TimeSeriesCollectionChartComponent(IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages);
    }

    public void setSeriesName(String seriesName) {
        this.seriesName = seriesName;
    }

    @Override
    public Dataset createChart(Document doc) {
        Node paramName2Node;
        if (this.actionPath != null) {
            this.values = this.getActionData();
        }
        if (this.values == null) {
            return null;
        }
        Node chartAttributes = doc.selectSingleNode("//chart");
        TimeSeriesCollectionChartDefinition chartDefinition = new TimeSeriesCollectionChartDefinition((IPentahoResultSet)this.values, this.byRow, chartAttributes, this.getSession());
        this.setChartType(chartDefinition.getChartType());
        this.setTitle(chartDefinition.getTitle());
        Node urlTemplateNode = chartAttributes.selectSingleNode("url-template");
        if (urlTemplateNode != null) {
            this.setUrlTemplate(urlTemplateNode.getText());
        }
        if ((paramName2Node = chartAttributes.selectSingleNode("series-name")) != null) {
            this.seriesName = paramName2Node.getText();
        }
        if (chartDefinition.getWidth() != -1 && this.width == -1) {
            this.setWidth(chartDefinition.getWidth());
        }
        if (chartDefinition.getHeight() != -1 && this.height == -1) {
            this.setHeight(chartDefinition.getHeight());
        }
        return chartDefinition;
    }

    @Override
    public Document getXmlContent() {
        Document result = DocumentHelper.createDocument();
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        this.setXslProperty("baseUrl", requestContext.getContextPath());
        this.setXslProperty("fullyQualifiedServerUrl", PentahoSystem.getApplicationContext().getFullyQualifiedServerURL());
        String mapName = "chart" + AbstractChartComponent.chartCount++;
        Document chartDefinition = this.jcrHelper.getSolutionDocument(this.definitionPath, RepositoryFilePermission.READ);
        if (chartDefinition == null) {
            Element errorElement = result.addElement("error");
            errorElement.addElement("title").setText(Messages.getInstance().getString("ABSTRACTCHARTEXPRESSION.ERROR_0001_ERROR_GENERATING_CHART"));
            String message = Messages.getInstance().getString("CHARTS.ERROR_0001_CHART_DEFINIION_MISSING", this.definitionPath);
            errorElement.addElement("message").setText(message);
            this.error(message);
            return result;
        }
        this.dataDefinition = this.createChart(chartDefinition);
        if (this.dataDefinition == null) {
            Element errorElement = result.addElement("error");
            errorElement.addElement("title").setText(Messages.getInstance().getString("ABSTRACTCHARTEXPRESSION.ERROR_0001_ERROR_GENERATING_CHART"));
            String message = Messages.getInstance().getString("CHARTS.ERROR_0002_CHART_DATA_MISSING", this.actionPath);
            errorElement.addElement("message").setText(message);
            return result;
        }
        PrintWriter printWriter = new PrintWriter(new StringWriter());
        String chartTitle = "";
        try {
            if (this.width == -1) {
                this.width = Integer.parseInt(chartDefinition.selectSingleNode("/chart/width").getText());
            }
            if (this.height == -1) {
                this.height = Integer.parseInt(chartDefinition.selectSingleNode("/chart/height").getText());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (chartDefinition.selectSingleNode("/chart/url-template") != null) {
            this.urlTemplate = chartDefinition.selectSingleNode("/chart/url-template").getText();
        }
        if (chartDefinition.selectSingleNode("/chart/paramName") != null) {
            this.paramName = chartDefinition.selectSingleNode("/chart/paramName").getText();
        }
        Element root = result.addElement("charts");
        TimeSeriesCollection chartDataDefinition = (TimeSeriesCollection)this.dataDefinition;
        if (chartDataDefinition.getSeriesCount() > 0) {
            String[] tempFileInfo = this.createTempFile();
            String fileName = tempFileInfo[0];
            String filePathWithoutExtension = tempFileInfo[1];
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            JFreeChartEngine.saveChart((Dataset)chartDataDefinition, chartTitle, "", filePathWithoutExtension, this.width, this.height, 1, printWriter, info, this);
            this.applyOuterURLTemplateParam();
            this.populateInfo(info);
            Element chartElement = root.addElement("chart");
            chartElement.addElement("mapName").setText(mapName);
            chartElement.addElement("width").setText(Integer.toString(this.width));
            chartElement.addElement("height").setText(Integer.toString(this.height));
            for (int row = 0; row < chartDataDefinition.getSeriesCount(); ++row) {
                for (int column = 0; column < chartDataDefinition.getItemCount(row); ++column) {
                    Number value = chartDataDefinition.getY(row, column);
                    Comparable rowKey = chartDataDefinition.getSeriesKey(row);
                    RegularTimePeriod columnKey = chartDataDefinition.getSeries(row).getTimePeriod(column);
                    Element valueElement = chartElement.addElement("value2D");
                    valueElement.addElement("value").setText(value.toString());
                    valueElement.addElement("row-key").setText(rowKey.toString());
                    valueElement.addElement("column-key").setText(columnKey.toString());
                }
            }
            String mapString = ImageMapUtilities.getImageMap((String)mapName, (ChartRenderingInfo)info);
            chartElement.addElement("imageMap").setText(mapString);
            chartElement.addElement("image").setText(fileName);
        }
        return result;
    }

    private void populateInfo(ChartRenderingInfo info) {
        if (this.urlTemplate == null) {
            return;
        }
        for (ChartEntity entity : info.getEntityCollection()) {
            if (!(entity instanceof XYItemEntity) || this.urlTemplate == null) continue;
            XYItemEntity xyItemEntity = (XYItemEntity)entity;
            if (this.paramName == null) {
                xyItemEntity.setURLText(this.urlTemplate);
                continue;
            }
            try {
                int seriesIndex = xyItemEntity.getSeriesIndex();
                int itemIndex = xyItemEntity.getItem();
                String xySeriesKey = (String)((Object)((TimeSeriesCollection)xyItemEntity.getDataset()).getSeriesKey(seriesIndex));
                String encodedVal = URLEncoder.encode(xySeriesKey, LocaleHelper.getSystemEncoding());
                String drillURL = TemplateUtil.applyTemplate(this.urlTemplate, this.paramName, encodedVal);
                String itemValueStr = ((TimeSeriesCollection)xyItemEntity.getDataset()).getX(seriesIndex, itemIndex).toString();
                encodedVal = URLEncoder.encode(itemValueStr, LocaleHelper.getSystemEncoding());
                drillURL = this.seriesName == null ? TemplateUtil.applyTemplate(drillURL, "SERIES", encodedVal) : TemplateUtil.applyTemplate(drillURL, this.seriesName, encodedVal);
                xyItemEntity.setURLText(drillURL);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean validate() {
        return true;
    }
}

