/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.actionsequence;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.repository2.unified.Converter;
import org.pentaho.platform.api.repository2.unified.IRepositoryContentConverterHandler;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.web.HttpUtil;

public class ActionSequenceResource
implements IActionSequenceResource {
    private String name;
    private String mimeType;
    private String address;
    private int sourceType;
    private static IUnifiedRepository repository;

    public ActionSequenceResource(String name, int sourceType, String mimeType, String address) {
        this.name = name;
        this.mimeType = mimeType;
        this.sourceType = sourceType;
        this.address = address;
    }

    public ActionSequenceResource(String name, int sourceType, String mimeType, String solutionName, String solutionPath, String location) {
        this(name, sourceType, mimeType, null);
    }

    private static IUnifiedRepository getRepository() {
        if (repository == null) {
            repository = PentahoSystem.get(IUnifiedRepository.class, null);
        }
        return repository;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public String getAddress() {
        return this.address;
    }

    public static int getResourceType(String sourceTypeName) {
        if ("solution-file".equals(sourceTypeName)) {
            return 1;
        }
        if ("file".equals(sourceTypeName)) {
            return 3;
        }
        if ("url".equals(sourceTypeName)) {
            return 2;
        }
        if ("xml".equals(sourceTypeName)) {
            return 6;
        }
        if ("string".equals(sourceTypeName)) {
            return 5;
        }
        return 4;
    }

    public static long getLastModifiedDate(String filePath, Locale locale) {
        if (filePath.startsWith("system")) {
            File file = null;
            filePath = PentahoSystem.getApplicationContext().getSolutionPath(filePath);
            if (locale == null) {
                file = new File(filePath);
            } else {
                String extension = FilenameUtils.getExtension((String)filePath);
                String baseName = FilenameUtils.removeExtension((String)filePath);
                if (extension.length() > 0) {
                    extension = "." + extension;
                }
                String language = locale.getLanguage();
                String country = locale.getCountry();
                String variant = locale.getVariant();
                if (!variant.equals("")) {
                    file = new File(baseName + "_" + language + "_" + country + "_" + variant + extension);
                }
                if (file == null || !file.exists()) {
                    file = new File(baseName + "_" + language + "_" + country + extension);
                }
                if (file == null || !file.exists()) {
                    file = new File(baseName + "_" + language + extension);
                }
                if (file == null || !file.exists()) {
                    file = new File(filePath);
                }
            }
            if (file != null) {
                return file.lastModified();
            }
        } else {
            RepositoryFile repositoryFile = null;
            if (locale == null) {
                repositoryFile = ActionSequenceResource.getRepository().getFile(filePath);
            } else {
                String extension = FilenameUtils.getExtension((String)filePath);
                String baseName = FilenameUtils.removeExtension((String)filePath);
                if (extension.length() > 0) {
                    extension = "." + extension;
                }
                String language = locale.getLanguage();
                String country = locale.getCountry();
                String variant = locale.getVariant();
                if (!variant.equals("")) {
                    repositoryFile = ActionSequenceResource.getRepository().getFile(baseName + "_" + language + "_" + country + "_" + variant + extension);
                }
                if (repositoryFile == null) {
                    repositoryFile = ActionSequenceResource.getRepository().getFile(baseName + "_" + language + "_" + country + extension);
                }
                if (repositoryFile == null) {
                    repositoryFile = ActionSequenceResource.getRepository().getFile(baseName + "_" + language + extension);
                }
                if (repositoryFile == null) {
                    repositoryFile = ActionSequenceResource.getRepository().getFile(filePath);
                }
            }
            if (repositoryFile != null) {
                return repositoryFile.getLastModifiedDate().getTime();
            }
        }
        return -1L;
    }

    public static InputStream getInputStream(String filePath, Locale locale) {
        InputStream inputStream = null;
        if (filePath.startsWith("system")) {
            File file = null;
            filePath = PentahoSystem.getApplicationContext().getSolutionPath(filePath);
            if (locale == null) {
                file = new File(filePath);
            } else {
                String extension = FilenameUtils.getExtension((String)filePath);
                String baseName = FilenameUtils.removeExtension((String)filePath);
                if (extension.length() > 0) {
                    extension = "." + extension;
                }
                String language = locale.getLanguage();
                String country = locale.getCountry();
                String variant = locale.getVariant();
                if (!variant.equals("")) {
                    file = new File(baseName + "_" + language + "_" + country + "_" + variant + extension);
                }
                if (file == null || !file.exists()) {
                    file = new File(baseName + "_" + language + "_" + country + extension);
                }
                if (file == null || !file.exists()) {
                    file = new File(baseName + "_" + language + extension);
                }
                if (file == null || !file.exists()) {
                    file = new File(filePath);
                }
            }
            if (file != null) {
                try {
                    inputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException ex) {}
            }
        } else {
            IRepositoryContentConverterHandler converterHandler = PentahoSystem.get(IRepositoryContentConverterHandler.class);
            RepositoryFile repositoryFile = null;
            if (locale == null) {
                repositoryFile = ActionSequenceResource.getRepository().getFile(filePath);
                String extension = FilenameUtils.getExtension((String)filePath);
                try {
                    Converter converter;
                    if (converterHandler != null && (converter = converterHandler.getConverter(extension)) != null) {
                        inputStream = converter.convert(repositoryFile.getId());
                    }
                    if (inputStream == null) {
                        inputStream = ((SimpleRepositoryFileData)ActionSequenceResource.getRepository().getDataForRead(repositoryFile.getId(), SimpleRepositoryFileData.class)).getStream();
                    }
                }
                catch (UnifiedRepositoryException ure) {}
            } else {
                Converter converter;
                String extension = FilenameUtils.getExtension((String)filePath);
                String baseName = FilenameUtils.removeExtension((String)filePath);
                if (extension.length() > 0) {
                    extension = "." + extension;
                }
                String language = locale.getLanguage();
                String country = locale.getCountry();
                String variant = locale.getVariant();
                if (!variant.equals("")) {
                    repositoryFile = ActionSequenceResource.getRepository().getFile(baseName + "_" + language + "_" + country + "_" + variant + extension);
                    try {
                        if (repositoryFile != null) {
                            if (converterHandler != null && (converter = converterHandler.getConverter(FilenameUtils.getExtension((String)filePath))) != null) {
                                inputStream = converter.convert(repositoryFile.getId());
                            }
                            if (inputStream == null) {
                                inputStream = ((SimpleRepositoryFileData)ActionSequenceResource.getRepository().getDataForRead(repositoryFile.getId(), SimpleRepositoryFileData.class)).getStream();
                            }
                        }
                    }
                    catch (UnifiedRepositoryException ure) {
                        // empty catch block
                    }
                }
                if (inputStream == null) {
                    repositoryFile = ActionSequenceResource.getRepository().getFile(baseName + "_" + language + "_" + country + extension);
                    try {
                        if (repositoryFile != null) {
                            if (converterHandler != null && (converter = converterHandler.getConverter(FilenameUtils.getExtension((String)filePath))) != null) {
                                inputStream = converter.convert(repositoryFile.getId());
                            }
                            if (inputStream == null) {
                                inputStream = ((SimpleRepositoryFileData)ActionSequenceResource.getRepository().getDataForRead(repositoryFile.getId(), SimpleRepositoryFileData.class)).getStream();
                            }
                        }
                    }
                    catch (UnifiedRepositoryException ure) {
                        // empty catch block
                    }
                }
                if (inputStream == null) {
                    repositoryFile = ActionSequenceResource.getRepository().getFile(baseName + "_" + language + extension);
                    try {
                        if (repositoryFile != null) {
                            if (converterHandler != null && (converter = converterHandler.getConverter(FilenameUtils.getExtension((String)filePath))) != null) {
                                inputStream = converter.convert(repositoryFile.getId());
                            }
                            if (inputStream == null) {
                                inputStream = ((SimpleRepositoryFileData)ActionSequenceResource.getRepository().getDataForRead(repositoryFile.getId(), SimpleRepositoryFileData.class)).getStream();
                            }
                        }
                    }
                    catch (UnifiedRepositoryException ure) {
                        // empty catch block
                    }
                }
                if (inputStream == null) {
                    repositoryFile = ActionSequenceResource.getRepository().getFile(filePath);
                    try {
                        if (repositoryFile != null) {
                            if (converterHandler != null && (converter = converterHandler.getConverter(FilenameUtils.getExtension((String)filePath))) != null) {
                                inputStream = converter.convert(repositoryFile.getId());
                            }
                            if (inputStream == null) {
                                inputStream = ((SimpleRepositoryFileData)ActionSequenceResource.getRepository().getDataForRead(repositoryFile.getId(), SimpleRepositoryFileData.class)).getStream();
                            }
                        }
                    }
                    catch (UnifiedRepositoryException ure) {
                        // empty catch block
                    }
                }
            }
        }
        return inputStream;
    }

    public long getLastModifiedDate(Locale locale) {
        int resourceSource = this.getSourceType();
        if (resourceSource == 2) {
            return -1L;
        }
        if (resourceSource == 1 || resourceSource == 3) {
            return ActionSequenceResource.getLastModifiedDate(this.getAddress(), locale);
        }
        if (resourceSource == 5 || resourceSource == 6) {
            return -1L;
        }
        return -1L;
    }

    public InputStream getInputStream(RepositoryFilePermission actionoperation, Locale locale) {
        int resourceSource = this.getSourceType();
        InputStream inputStream = null;
        if (resourceSource == 2) {
            inputStream = HttpUtil.getURLInputStream(this.getAddress());
        } else if (resourceSource == 1 || resourceSource == 3) {
            inputStream = ActionSequenceResource.getInputStream(this.getAddress(), locale);
        } else if (resourceSource == 5 || resourceSource == 6) {
            String s = this.getAddress();
            if (s == null) {
                s = "";
            }
            inputStream = new ByteArrayInputStream(s.getBytes());
        }
        return inputStream;
    }

    public InputStream getInputStream(RepositoryFilePermission actionOperation) {
        return this.getInputStream(actionOperation, null);
    }
}

