/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.actionsequence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IDisposable;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IActionParameter;

public class ActionParameter
implements IActionParameter {
    private String name;
    private String type;
    private Object value;
    private List variables;
    private Object defaultValue;
    private ParamSelections paramSelections = null;
    private int promptType = 0;
    private List saveLocations = null;
    private boolean isOutputParameter = true;
    private static final Log logger = LogFactory.getLog(ActionParameter.class);

    public ActionParameter(String name, String type, Object value, List variables, Object defaultValue) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.variables = variables;
        this.defaultValue = null;
        if (defaultValue != null) {
            if ("string".equalsIgnoreCase(type)) {
                this.defaultValue = defaultValue.toString();
            } else if ("string-list".equalsIgnoreCase(type) || "property-map-list".equalsIgnoreCase(type)) {
                if (defaultValue instanceof List) {
                    this.defaultValue = defaultValue;
                }
            } else if ("property-map".equalsIgnoreCase(type)) {
                if (defaultValue instanceof Map) {
                    this.defaultValue = defaultValue;
                }
            } else if ("result-set".equalsIgnoreCase(type)) {
                if (defaultValue instanceof IPentahoResultSet) {
                    this.defaultValue = defaultValue;
                }
            } else if ("long".equalsIgnoreCase(type)) {
                try {
                    this.defaultValue = Long.valueOf(defaultValue.toString());
                }
                catch (NumberFormatException e) {
                    logger.error((Object)e.getLocalizedMessage());
                }
            } else if ("integer".equalsIgnoreCase(type)) {
                try {
                    this.defaultValue = Integer.valueOf(defaultValue.toString());
                }
                catch (NumberFormatException e) {
                    logger.error((Object)e.getLocalizedMessage());
                }
            }
        }
        if (value == null && defaultValue != null) {
            this.promptType = 1;
        }
    }

    public List getSaveLocations() {
        return this.saveLocations == null ? new ArrayList() : this.saveLocations;
    }

    public void addSaveLocation(String location) {
        if (this.saveLocations == null) {
            this.saveLocations = new ArrayList();
        }
        this.saveLocations.add(location);
    }

    public List getVariables() {
        return this.variables == null ? new ArrayList() : this.variables;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getStringValue() {
        return this.value != null ? this.value.toString() : (this.defaultValue != null ? this.defaultValue.toString() : null);
    }

    public Object getValue() {
        return this.value != null ? this.value : this.defaultValue;
    }

    public List getValueAsList() {
        Object rtn;
        Object object = rtn = this.value != null ? this.value : this.defaultValue;
        if (rtn == null) {
            return new ArrayList();
        }
        if (rtn instanceof List) {
            return (List)rtn;
        }
        ArrayList<Object> al = new ArrayList<Object>();
        al.add(rtn);
        return al;
    }

    public IPentahoResultSet getValueAsResultSet() {
        Object rtn;
        Object object = rtn = this.value != null ? this.value : this.defaultValue;
        if (rtn == null) {
            return null;
        }
        if (rtn instanceof IPentahoResultSet) {
            return (IPentahoResultSet)rtn;
        }
        return null;
    }

    public void setValue(Object value) {
        this.setPromptStatus(value == null ? 1 : 0);
        if (this.value != value) {
            this.dispose();
            this.value = value;
        }
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean isDefaultValue() {
        return this.value == null && this.defaultValue != null;
    }

    public boolean isNull() {
        return this.value == null && this.defaultValue == null;
    }

    public void dispose() {
        if (this.value != null && this.value instanceof IDisposable) {
            ((IDisposable)this.value).dispose();
        }
    }

    public int getPromptType() {
        return this.promptType;
    }

    public boolean hasSelections() {
        return this.paramSelections != null;
    }

    public String getSelectionDisplayName() {
        return this.hasSelections() ? this.paramSelections.displayName : "";
    }

    public String getSelectionNameForValue(String val) {
        Object rtn = null;
        if (this.hasSelections() && this.paramSelections.selNames != null) {
            rtn = this.paramSelections.selNames.get(val);
        }
        return rtn != null ? rtn.toString() : val;
    }

    public List getSelectionValues() {
        return this.hasSelections() ? this.paramSelections.selValues : new ArrayList();
    }

    @Deprecated
    public void setParamSelections(List selValues, Map selNames, String displayname) {
        this.paramSelections = new ParamSelections(selValues, selNames, displayname);
    }

    public Map getSelectionNameMap() {
        return this.hasSelections() ? this.paramSelections.selNames : new HashMap();
    }

    public int getPromptStatus() {
        return this.promptType;
    }

    public boolean setPromptStatus(int status) {
        if (this.promptType == 2 || status < 0 || status > 3) {
            return false;
        }
        this.promptType = status;
        return true;
    }

    public boolean isOutputParameter() {
        return this.isOutputParameter;
    }

    public void setOutputParameter(boolean isOutputParameter) {
        this.isOutputParameter = isOutputParameter;
    }

    class ParamSelections {
        Map selNames;
        List selValues;
        String displayName;

        ParamSelections(List selValues, Map selNames, String displayname) {
            this.displayName = displayname != null ? displayname : "";
            this.selNames = selNames != null ? selNames : new HashMap();
            this.selValues = selValues != null ? selValues : new ArrayList();
        }
    }
}

