/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.solution.PentahoSessionParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.security.event.authentication.AuthenticationSuccessEvent;
import org.springframework.security.event.authentication.InteractiveAuthenticationSuccessEvent;
import org.springframework.util.Assert;

public class PentahoSessionStartupAuthenticationSuccessListener
implements ApplicationListener,
Ordered {
    private static final Log logger = LogFactory.getLog(PentahoSessionStartupAuthenticationSuccessListener.class);
    private int order = 150;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof InteractiveAuthenticationSuccessEvent || event instanceof AuthenticationSuccessEvent) {
            logger.debug((Object)"received InteractiveAuthenticationSuccessEvent");
            logger.debug((Object)"calling PentahoSystem.sessionStartup");
            try {
                IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
                Assert.notNull((Object)pentahoSession, (String)"PentahoSessionHolder doesn't have a session");
                PentahoSessionParameterProvider sessionParameters = new PentahoSessionParameterProvider(pentahoSession);
                PentahoSystem.sessionStartup(pentahoSession, sessionParameters);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

