/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.spring;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.objfac.spring.SpringScopeSessionHolder;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringPentahoObjectReference<T>
implements IPentahoObjectReference<T> {
    private ConfigurableApplicationContext context;
    private String name;
    private final Class<T> clazz;
    private IPentahoSession session;
    private final SpringBeanAttributes attributes;
    private static String PRIORITY = "priority";

    public SpringPentahoObjectReference(ConfigurableApplicationContext context, String name, Class<T> clazz, IPentahoSession session, BeanDefinition beanDef) {
        this.context = context;
        this.name = name;
        this.clazz = clazz;
        this.session = session;
        this.attributes = new SpringBeanAttributes(beanDef);
    }

    public Class<?> getObjectClass() {
        return this.clazz;
    }

    public T getObject() {
        SpringScopeSessionHolder.SESSION.set(this.session);
        Object obj = this.context.getBeanFactory().getBean(this.name);
        SpringScopeSessionHolder.SESSION.set(null);
        if (obj instanceof IPentahoInitializer) {
            ((IPentahoInitializer)obj).init(this.session);
        }
        return (T)obj;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringPentahoObjectReference that = (SpringPentahoObjectReference)o;
        if (!this.clazz.equals(that.clazz)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        return !(this.session != null ? !this.session.equals(that.session) : that.session != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.clazz.hashCode();
        result = 31 * result + (this.session != null ? this.session.hashCode() : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    public int compareTo(IPentahoObjectReference<T> o) {
        int pri2;
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        int pri1 = this.getRanking();
        if (pri1 == (pri2 = o.getRanking().intValue())) {
            return 0;
        }
        if (pri1 > pri2) {
            return 1;
        }
        return -1;
    }

    public Integer getRanking() {
        return this.extractPriority(this);
    }

    private int extractPriority(IPentahoObjectReference ref) {
        if (ref == null || ref.getAttributes() == null || !ref.getAttributes().containsKey(PRIORITY)) {
            return 0;
        }
        try {
            return Integer.parseInt(ref.getAttributes().get(PRIORITY).toString());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static class SpringBeanAttributes
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -5790844158879001752L;

        public SpringBeanAttributes(BeanDefinition definition) {
            for (String s : definition.attributeNames()) {
                this.put(s, definition.getAttribute(s));
            }
        }
    }
}

