/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class PublishedBeanRegistry {
    private static Map<Object, Map<Class<?>, List<String>>> classToBeanMap = Collections.synchronizedMap(new WeakHashMap());
    private static Map<ListableBeanFactory, Object> factoryMarkerCache = Collections.synchronizedMap(new WeakHashMap());

    public static void registerBean(String beanName, Class<?> clazz, Object factoryMarker) {
        List<String> beansImplementingType;
        if (beanName == null) {
            throw new IllegalArgumentException("Bean name cannot be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (factoryMarker == null) {
            throw new IllegalArgumentException("factoryMarker cannot be null");
        }
        Map<Class<?>, List<String>> registryMap = classToBeanMap.get(factoryMarker);
        if (registryMap == null) {
            registryMap = new WeakHashMap();
            classToBeanMap.put(factoryMarker, registryMap);
        }
        if ((beansImplementingType = registryMap.get(clazz)) == null) {
            beansImplementingType = Collections.synchronizedList(new ArrayList());
            registryMap.put(clazz, beansImplementingType);
        }
        beansImplementingType.add(beanName);
    }

    public static String[] getBeanNamesForType(ListableBeanFactory registry, Class<?> type) {
        if (registry == null) {
            throw new IllegalArgumentException("Registry cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (!registry.containsBean("PublishedBeanRegistryMarker")) {
            return new String[0];
        }
        Map<Class<?>, List<String>> map = factoryMarkerCache.containsKey(registry) ? classToBeanMap.get(factoryMarkerCache.get(registry)) : classToBeanMap.get(registry.getBean("PublishedBeanRegistryMarker"));
        if (map == null) {
            return new String[0];
        }
        List<String> beansImplementingType = map.get(type);
        if (beansImplementingType == null) {
            return new String[0];
        }
        return beansImplementingType.toArray(new String[beansImplementingType.size()]);
    }

    public static void registerFactory(ApplicationContext applicationContext) {
        Object markerBean = null;
        try {
            markerBean = applicationContext.getBean("PublishedBeanRegistryMarker");
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (markerBean == null) {
            return;
        }
        factoryMarkerCache.put((ListableBeanFactory)applicationContext, markerBean);
    }

    public static Set<ListableBeanFactory> getRegisteredFactories() {
        return factoryMarkerCache.keySet();
    }
}

