/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.references;

import java.util.Map;
import org.pentaho.platform.api.engine.IObjectCreator;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.objfac.references.AbstractPentahoObjectReference;

public class PrototypePentahoObjectReference<T>
extends AbstractPentahoObjectReference<T> {
    private final IObjectCreator<T> creator;

    public PrototypePentahoObjectReference(Class<T> type, IObjectCreator<T> creator, Map<String, Object> attributes, int priority) {
        super(type, attributes, priority);
        this.creator = creator;
    }

    @Override
    protected T createObject() throws ObjectFactoryException {
        IPentahoSession session = PentahoSessionHolder.getSession();
        try {
            return (T)this.creator.create(session);
        }
        catch (Exception e) {
            throw new ObjectFactoryException("Error creating instance", (Throwable)e);
        }
    }

    public static class Builder<T>
    extends BuilderBase<T, Builder<T>> {
        public Builder(Class<T> type) {
            this.type(type);
        }

        @Override
        public Builder<T> self() {
            return this;
        }
    }

    private static abstract class BuilderBase<T, B extends BuilderBase<T, B>>
    extends AbstractPentahoObjectReference.Builder<T, B> {
        IObjectCreator<T> creator;

        private BuilderBase() {
        }

        public B creator(IObjectCreator<T> creator) {
            this.creator = creator;
            return (B)((BuilderBase)this.self());
        }

        @Override
        public PrototypePentahoObjectReference<T> build() {
            return new PrototypePentahoObjectReference<T>(this.type, this.creator, this.attributes, this.priority);
        }
    }
}

