/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.references;

import java.util.Collections;
import java.util.Map;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPentahoObjectReference<T>
implements IPentahoObjectReference<T> {
    private final Map<String, Object> attributes;
    private final int ranking;
    private Class<T> type;
    private Logger logger = LoggerFactory.getLogger(AbstractPentahoObjectReference.class);

    protected AbstractPentahoObjectReference(Class<T> type, Map<String, Object> attributes, int ranking) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (attributes == null) {
            attributes = Collections.emptyMap();
        }
        this.type = type;
        this.attributes = attributes;
        this.ranking = ranking;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public T getObject() {
        try {
            return this.createObject();
        }
        catch (ObjectFactoryException e) {
            this.logger.error("Error creating object. Null will be returned.", (Throwable)e);
            return null;
        }
    }

    protected abstract T createObject() throws ObjectFactoryException;

    public Integer getRanking() {
        return this.ranking;
    }

    public int compareTo(IPentahoObjectReference<T> o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        return this.getRanking().compareTo(o.getRanking());
    }

    public Class<T> getObjectClass() {
        return this.type;
    }

    public static abstract class Builder<T, B extends Builder<T, B>> {
        protected int priority;
        protected Map<String, Object> attributes;
        protected Class<T> type;

        public B attributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this.self();
        }

        public B priority(int priority) {
            this.priority = priority;
            return this.self();
        }

        protected B type(Class<T> type) {
            this.type = type;
            return this.self();
        }

        protected abstract B self();

        public abstract IPentahoObjectReference<T> build();
    }
}

