/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class SimpleMapCacheManager
implements ICacheManager {
    protected static final Log logger = LogFactory.getLog(SimpleMapCacheManager.class);
    private final Map simpleMap = Collections.synchronizedMap(new HashMap());
    private static SimpleMapCacheManager _instance = new SimpleMapCacheManager();

    public static SimpleMapCacheManager getInstance() {
        return _instance;
    }

    public SimpleMapCacheManager() {
        PentahoSystem.addLogoutListener((ILogoutListener)this);
    }

    public void cacheStop() {
    }

    public boolean cacheEnabled(String region) {
        return true;
    }

    public void onLogout(IPentahoSession session) {
        this.removeRegionCache(session.getName());
    }

    public boolean addCacheRegion(String region, Properties cacheProperties) {
        return true;
    }

    public boolean addCacheRegion(String region) {
        return true;
    }

    public void clearRegionCache(String region) {
        this.removeFromMap(region);
    }

    public void removeRegionCache(String region) {
        this.removeFromMap(region);
    }

    public void putInRegionCache(String region, Object key, Object value) {
        this.simpleMap.put(this.getCorrectedKey(region, key), value);
    }

    public Object getFromRegionCache(String region, Object key) {
        return this.simpleMap.get(this.getCorrectedKey(region, key));
    }

    public Set getAllEntriesFromRegionCache(String region) {
        if (this.simpleMap != null) {
            return this.simpleMap.entrySet();
        }
        return null;
    }

    public Set getAllKeysFromRegionCache(String region) {
        if (this.simpleMap != null) {
            return this.simpleMap.keySet();
        }
        return null;
    }

    public List getAllValuesFromRegionCache(String region) {
        return this.getFromMap(region);
    }

    public void removeFromRegionCache(String region, Object key) {
        this.simpleMap.remove(this.getCorrectedKey(region, key));
    }

    public boolean cacheEnabled() {
        return true;
    }

    public void clearCache() {
        this.simpleMap.clear();
    }

    public Object getFromGlobalCache(Object key) {
        return this.getFromRegionCache("GLOBAL", key);
    }

    public Object getFromSessionCache(IPentahoSession session, String key) {
        return this.getFromRegionCache("SESSION", this.getCorrectedKey(session, key));
    }

    public void killSessionCache(IPentahoSession session) {
        this.removeFromMap(session.getId());
    }

    public void killSessionCaches() {
        this.removeRegionCache("SESSION");
    }

    public void putInGlobalCache(Object key, Object value) {
        this.putInRegionCache("GLOBAL", key, value);
    }

    public void putInSessionCache(IPentahoSession session, String key, Object value) {
        this.putInRegionCache("SESSION", this.getCorrectedKey(session, key), value);
    }

    public void removeFromGlobalCache(Object key) {
        this.removeFromRegionCache("GLOBAL", key);
    }

    public void removeFromSessionCache(IPentahoSession session, String key) {
        this.removeFromRegionCache("SESSION", this.getCorrectedKey(session, key));
    }

    private String getCorrectedKey(IPentahoSession session, String key) {
        String sessionId = session.getId();
        String newKey = null;
        if (sessionId != null) {
            newKey = sessionId + "\t" + key;
        }
        return newKey;
    }

    private String getCorrectedKey(String region, Object key) {
        return region + "\t" + key;
    }

    private List getFromMap(String id) {
        ArrayList list = new ArrayList();
        if (this.simpleMap != null) {
            String keyId = id + "\t";
            for (Map.Entry entry : this.simpleMap.entrySet()) {
                String key = entry.getKey() != null ? entry.getKey().toString() : "";
                if (!key.startsWith(keyId)) continue;
                list.add(entry.getValue());
            }
        }
        return list;
    }

    private void removeFromMap(String id) {
        if (this.simpleMap != null) {
            Iterator it = this.simpleMap.entrySet().iterator();
            String keyId = id + "\t";
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = entry.getKey() != null ? (String)entry.getKey() : "";
                if (!key.startsWith(keyId)) continue;
                it.remove();
            }
        }
    }

    public long getElementCountInRegionCache(String region) {
        long cnt = 0L;
        String regionKey = region + "\t";
        for (Map.Entry entry : this.simpleMap.entrySet()) {
            String key = entry.getKey() != null ? (String)entry.getKey() : "";
            if (!key.startsWith(regionKey)) continue;
            ++cnt;
        }
        return cnt;
    }

    public long getElementCountInSessionCache() {
        return this.getElementCountInRegionCache("SESSION");
    }

    public long getElementCountInGlobalCache() {
        return this.getElementCountInRegionCache("GLOBAL");
    }
}

