/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import com.cloudera.sqoop.SqoopOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class CredentialsUtil {
    public static final Log LOG = LogFactory.getLog((String)CredentialsUtil.class.getName());

    private CredentialsUtil() {
    }

    public static String fetchPasswordFromFile(SqoopOptions options) throws IOException {
        String passwordFilePath = options.getPasswordFilePath();
        if (passwordFilePath == null) {
            return options.getPassword();
        }
        return CredentialsUtil.fetchPasswordFromFile(options.getConf(), passwordFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fetchPasswordFromFile(Configuration conf, String passwordFilePath) throws IOException {
        LOG.debug((Object)("Fetching password from specified path: " + passwordFilePath));
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path path = new Path(passwordFilePath);
        if (!fs.exists(path)) {
            throw new IOException("The password file does not exist! " + passwordFilePath);
        }
        if (!fs.isFile(path)) {
            throw new IOException("The password file cannot be a directory! " + passwordFilePath);
        }
        FSDataInputStream is = fs.open(path);
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)is, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((Writer)writer);
            fs.close();
        }
    }
}

