/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.netezza;

import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.mapreduce.ExportJobBase;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.db.netezza.NetezzaExternalTableRecordExportMapper;
import org.apache.sqoop.mapreduce.db.netezza.NetezzaExternalTableTextExportMapper;

public class NetezzaExternalTableExportJob
extends ExportJobBase {
    public static final Log LOG = LogFactory.getLog((String)NetezzaExternalTableExportJob.class.getName());

    public NetezzaExternalTableExportJob(ExportJobContext context) {
        super(context, null, null, NullOutputFormat.class);
    }

    @Override
    protected void propagateOptionsToJob(Job job) {
        Configuration conf = job.getConfiguration();
        String nullValue = this.options.getInNullStringValue();
        if (nullValue != null) {
            conf.set("netezza.exttable.null.value", StringEscapeUtils.unescapeJava((String)nullValue));
        }
        conf.setInt("sqoop.input.field.delim", (int)this.options.getInputFieldDelim());
        conf.setInt("sqoop.input.record.delim", (int)this.options.getInputRecordDelim());
        conf.setInt("sqoop.input.enclosed.by", (int)this.options.getInputEnclosedBy());
        char escapeChar = this.options.getInputEscapedBy();
        if (escapeChar > '\u0000') {
            if (escapeChar != '\\') {
                LOG.info((Object)"Setting escaped char to \\ for Netezza external table export");
            }
            conf.setInt("sqoop.input.escaped.by", 92);
        }
        conf.setBoolean("sqoop.input.enclose.required", this.options.isOutputEncloseRequired());
    }

    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws ClassNotFoundException, IOException {
        Configuration conf = job.getConfiguration();
        ConnManager mgr = this.context.getConnManager();
        String username = this.options.getUsername();
        if (null == username || username.length() == 0) {
            DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString());
        } else {
            DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), username, this.options.getPassword());
        }
        String[] colNames = this.options.getColumns();
        if (null == colNames) {
            colNames = mgr.getColumnNames(tableName);
        }
        String[] sqlColNames = null;
        if (null != colNames) {
            sqlColNames = new String[colNames.length];
            for (int i = 0; i < colNames.length; ++i) {
                sqlColNames[i] = mgr.escapeColName(colNames[i]);
            }
        }
        DataDrivenDBInputFormat.setInput(job, DBWritable.class, tableName, null, null, sqlColNames);
        super.configureInputFormat(job, tableName, tableClassName, splitByCol);
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        if (this.inputIsSequenceFiles()) {
            return NetezzaExternalTableRecordExportMapper.class;
        }
        return NetezzaExternalTableTextExportMapper.class;
    }
}

