/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.hcat;

import com.cloudera.sqoop.lib.BlobRef;
import com.cloudera.sqoop.lib.ClobRef;
import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.lib.FieldFormatter;
import com.cloudera.sqoop.lib.LargeObjectLoader;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.data.DefaultHCatRecord;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.hcatalog.mapreduce.InputJobInfo;
import org.apache.hcatalog.mapreduce.StorerInfo;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.SqoopMapper;

public class SqoopHCatImportMapper
extends SqoopMapper<WritableComparable, SqoopRecord, WritableComparable, HCatRecord> {
    public static final Log LOG = LogFactory.getLog((String)SqoopHCatImportMapper.class.getName());
    private static boolean debugHCatImportMapper = false;
    private InputJobInfo jobInfo;
    private HCatSchema hCatFullTableSchema;
    private int fieldCount;
    private boolean bigDecimalFormatString;
    private LargeObjectLoader lobLoader;
    private HCatSchema partitionSchema = null;
    private HCatSchema dataColsSchema = null;
    private String stringDelimiterReplacements = null;
    private ArrayWritable delimCharsArray;
    private String hiveDelimsReplacement;
    private boolean doHiveDelimsReplacement = false;
    private DelimiterSet hiveDelimiters;
    private String staticPartitionKey;
    private int[] hCatFieldPositions;
    private int colCount;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String inputJobInfoStr = conf.get("mapreduce.lib.hcat.job.info");
        this.jobInfo = (InputJobInfo)HCatUtil.deserialize((String)inputJobInfoStr);
        this.dataColsSchema = this.jobInfo.getTableInfo().getDataColumns();
        this.partitionSchema = this.jobInfo.getTableInfo().getPartitionColumns();
        StringBuilder storerInfoStr = new StringBuilder(1024);
        StorerInfo storerInfo = this.jobInfo.getTableInfo().getStorerInfo();
        storerInfoStr.append("HCatalog Storer Info : ").append("\n\tHandler = ").append(storerInfo.getStorageHandlerClass()).append("\n\tInput format class = ").append(storerInfo.getIfClass()).append("\n\tOutput format class = ").append(storerInfo.getOfClass()).append("\n\tSerde class = ").append(storerInfo.getSerdeClass());
        Properties storerProperties = storerInfo.getProperties();
        if (!storerProperties.isEmpty()) {
            storerInfoStr.append("\nStorer properties ");
            for (Map.Entry<Object, Object> entry : storerProperties.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                storerInfoStr.append("\n\t").append(key).append('=').append(val);
            }
        }
        storerInfoStr.append("\n");
        LOG.info((Object)storerInfoStr);
        this.hCatFullTableSchema = new HCatSchema(this.dataColsSchema.getFields());
        for (HCatFieldSchema hfs : this.partitionSchema.getFields()) {
            this.hCatFullTableSchema.append(hfs);
        }
        this.fieldCount = this.hCatFullTableSchema.size();
        this.lobLoader = new LargeObjectLoader(conf, new Path(this.jobInfo.getTableInfo().getTableLocation()));
        this.bigDecimalFormatString = conf.getBoolean("sqoop.bigdecimal.format.string", true);
        debugHCatImportMapper = conf.getBoolean("sqoop.hcat.debug.import.mapper", false);
        IntWritable[] delimChars = (IntWritable[])DefaultStringifier.loadArray((Configuration)conf, (String)"sqoop.hive.delims.to.replace", IntWritable.class);
        this.hiveDelimiters = new DelimiterSet((char)delimChars[0].get(), (char)delimChars[1].get(), (char)delimChars[2].get(), (char)delimChars[3].get(), delimChars[4].get() == 1);
        this.hiveDelimsReplacement = conf.get("sqoop.hive.delims.replacement");
        if (this.hiveDelimsReplacement == null) {
            this.hiveDelimsReplacement = "";
        }
        this.doHiveDelimsReplacement = Boolean.valueOf(conf.get("sqoop.hive.delims.replacement.enabled"));
        IntWritable[] fPos = (IntWritable[])DefaultStringifier.loadArray((Configuration)conf, (String)"sqoop.hcat.field.positions", IntWritable.class);
        this.hCatFieldPositions = new int[fPos.length];
        for (int i = 0; i < fPos.length; ++i) {
            this.hCatFieldPositions[i] = fPos[i].get();
        }
        LOG.debug((Object)("Hive delims replacement enabled : " + this.doHiveDelimsReplacement));
        LOG.debug((Object)("Hive Delimiters : " + this.hiveDelimiters.toString()));
        LOG.debug((Object)("Hive delimiters replacement : " + this.hiveDelimsReplacement));
        this.staticPartitionKey = conf.get("sqoop.hcat.partition.key");
        LOG.debug((Object)("Static partition key used : " + this.staticPartitionKey));
    }

    public void map(WritableComparable key, SqoopRecord value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            value.loadLargeObjects(this.lobLoader);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
        if (this.colCount == -1) {
            this.colCount = value.getFieldMap().size();
        }
        context.write((Object)key, (Object)this.convertToHCatRecord(value));
    }

    protected void cleanup(Mapper.Context context) throws IOException {
        if (null != this.lobLoader) {
            this.lobLoader.close();
        }
    }

    private HCatRecord convertToHCatRecord(SqoopRecord sqr) throws IOException {
        Map<String, Object> fieldMap = sqr.getFieldMap();
        DefaultHCatRecord result = new DefaultHCatRecord(this.fieldCount);
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            String hfn = key.toLowerCase();
            if (this.staticPartitionKey != null && this.staticPartitionKey.equals(hfn)) continue;
            HCatFieldSchema hfs = this.hCatFullTableSchema.get(hfn);
            if (debugHCatImportMapper) {
                LOG.debug((Object)("SqoopRecordVal: field = " + key + " Val " + val + " of type " + (val == null ? null : val.getClass().getName()) + ", hcattype " + hfs.getTypeString()));
            }
            Object hCatVal = this.toHCat(val, hfs.getType(), hfs.getTypeString());
            result.set(hfn, this.hCatFullTableSchema, hCatVal);
        }
        return result;
    }

    private Object toHCat(Object val, HCatFieldSchema.Type hfsType, String hCatTypeString) {
        if (val == null) {
            return null;
        }
        Object retVal = null;
        if (val instanceof Number) {
            retVal = this.convertNumberTypes(val, hfsType);
        } else if (val instanceof Boolean) {
            retVal = this.convertBooleanTypes(val, hfsType);
        } else if (val instanceof String) {
            if (hfsType == HCatFieldSchema.Type.STRING) {
                String str = (String)val;
                retVal = this.doHiveDelimsReplacement ? FieldFormatter.hiveStringReplaceDelims(str, this.hiveDelimsReplacement, this.hiveDelimiters) : str;
            }
        } else if (val instanceof java.util.Date) {
            retVal = this.converDateTypes(val, hfsType);
        } else if (val instanceof BytesWritable) {
            if (hfsType == HCatFieldSchema.Type.BINARY) {
                BytesWritable bw = (BytesWritable)val;
                retVal = bw.getBytes();
            }
        } else if (val instanceof BlobRef) {
            if (hfsType == HCatFieldSchema.Type.BINARY) {
                BlobRef br = (BlobRef)val;
                byte[] bytes = br.isExternal() ? br.toString().getBytes() : (byte[])br.getData();
                retVal = bytes;
            }
        } else if (val instanceof ClobRef) {
            if (hfsType == HCatFieldSchema.Type.STRING) {
                ClobRef cr = (ClobRef)val;
                String s = cr.isExternal() ? cr.toString() : (String)cr.getData();
                retVal = s;
            }
        } else {
            throw new UnsupportedOperationException("Objects of type " + val.getClass().getName() + " are not suported");
        }
        if (retVal == null) {
            LOG.error((Object)("Objects of type " + val.getClass().getName() + " can not be mapped to HCatalog type " + hCatTypeString));
        }
        return retVal;
    }

    private Object converDateTypes(Object val, HCatFieldSchema.Type hfsType) {
        if (val instanceof Date) {
            if (hfsType == HCatFieldSchema.Type.BIGINT) {
                return ((Date)val).getTime();
            }
            if (hfsType == HCatFieldSchema.Type.STRING) {
                return val.toString();
            }
        } else if (val instanceof Time) {
            if (hfsType == HCatFieldSchema.Type.BIGINT) {
                return ((Time)val).getTime();
            }
            if (hfsType == HCatFieldSchema.Type.STRING) {
                return val.toString();
            }
        } else if (val instanceof Timestamp) {
            if (hfsType == HCatFieldSchema.Type.BIGINT) {
                return ((Timestamp)val).getTime();
            }
            if (hfsType == HCatFieldSchema.Type.STRING) {
                return val.toString();
            }
        }
        return null;
    }

    private Object convertBooleanTypes(Object val, HCatFieldSchema.Type hfsType) {
        Boolean b = (Boolean)val;
        if (hfsType == HCatFieldSchema.Type.BOOLEAN) {
            return b;
        }
        if (hfsType == HCatFieldSchema.Type.TINYINT) {
            return (byte)(b != false ? 1 : 0);
        }
        if (hfsType == HCatFieldSchema.Type.SMALLINT) {
            return (short)(b != false ? 1 : 0);
        }
        if (hfsType == HCatFieldSchema.Type.INT) {
            return b != false ? 1 : 0;
        }
        if (hfsType == HCatFieldSchema.Type.BIGINT) {
            return (long)(b != false ? 1 : 0);
        }
        if (hfsType == HCatFieldSchema.Type.FLOAT) {
            return Float.valueOf(b != false ? 1 : 0);
        }
        if (hfsType == HCatFieldSchema.Type.DOUBLE) {
            return (double)(b != false ? 1 : 0);
        }
        if (hfsType == HCatFieldSchema.Type.STRING) {
            return val.toString();
        }
        return null;
    }

    private Object convertNumberTypes(Object val, HCatFieldSchema.Type hfsType) {
        if (!(val instanceof Number)) {
            return null;
        }
        if (val instanceof BigDecimal && hfsType == HCatFieldSchema.Type.STRING) {
            BigDecimal bd = (BigDecimal)val;
            if (this.bigDecimalFormatString) {
                return bd.toPlainString();
            }
            return bd.toString();
        }
        Number n = (Number)val;
        if (hfsType == HCatFieldSchema.Type.TINYINT) {
            return n.byteValue();
        }
        if (hfsType == HCatFieldSchema.Type.SMALLINT) {
            return n.shortValue();
        }
        if (hfsType == HCatFieldSchema.Type.INT) {
            return n.intValue();
        }
        if (hfsType == HCatFieldSchema.Type.BIGINT) {
            return n.longValue();
        }
        if (hfsType == HCatFieldSchema.Type.FLOAT) {
            return Float.valueOf(n.floatValue());
        }
        if (hfsType == HCatFieldSchema.Type.DOUBLE) {
            return n.doubleValue();
        }
        if (hfsType == HCatFieldSchema.Type.BOOLEAN) {
            return n.byteValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (hfsType == HCatFieldSchema.Type.STRING) {
            return n.toString();
        }
        return null;
    }
}

