/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.TaskInputOutputContextImpl;
import org.apache.hadoop.util.Progressable;

public class ReduceContextImpl<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends TaskInputOutputContextImpl<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
implements ReduceContext<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private RawKeyValueIterator input;
    private Counter inputValueCounter;
    private Counter inputKeyCounter;
    private RawComparator<KEYIN> comparator;
    private KEYIN key;
    private VALUEIN value;
    private boolean firstValue = false;
    private boolean nextKeyIsSame = false;
    private boolean hasMore;
    protected Progressable reporter;
    private Deserializer<KEYIN> keyDeserializer;
    private Deserializer<VALUEIN> valueDeserializer;
    private DataInputBuffer buffer = new DataInputBuffer();
    private BytesWritable currentRawKey = new BytesWritable();
    private ValueIterable iterable = new ValueIterable();
    private final SerializationFactory serializationFactory;
    private final Class<KEYIN> keyClass;
    private final Class<VALUEIN> valueClass;
    private final Configuration conf;
    private final TaskAttemptID taskid;
    private int currentKeyLength = -1;
    private int currentValueLength = -1;

    public ReduceContextImpl(Configuration conf, TaskAttemptID taskid, RawKeyValueIterator input, Counter inputKeyCounter, Counter inputValueCounter, RecordWriter<KEYOUT, VALUEOUT> output, OutputCommitter committer, StatusReporter reporter, RawComparator<KEYIN> comparator, Class<KEYIN> keyClass, Class<VALUEIN> valueClass) throws InterruptedException, IOException {
        super(conf, taskid, output, committer, reporter);
        this.input = input;
        this.inputKeyCounter = inputKeyCounter;
        this.inputValueCounter = inputValueCounter;
        this.comparator = comparator;
        this.serializationFactory = new SerializationFactory(conf);
        this.keyDeserializer = this.serializationFactory.getDeserializer(keyClass);
        this.keyDeserializer.open((InputStream)this.buffer);
        this.valueDeserializer = this.serializationFactory.getDeserializer(valueClass);
        this.valueDeserializer.open((InputStream)this.buffer);
        this.hasMore = input.next();
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.conf = conf;
        this.taskid = taskid;
    }

    @Override
    public boolean nextKey() throws IOException, InterruptedException {
        while (this.hasMore && this.nextKeyIsSame) {
            this.nextKeyValue();
        }
        if (this.hasMore) {
            if (this.inputKeyCounter != null) {
                this.inputKeyCounter.increment(1L);
            }
            return this.nextKeyValue();
        }
        return false;
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.hasMore) {
            this.key = null;
            this.value = null;
            return false;
        }
        this.firstValue = !this.nextKeyIsSame;
        DataInputBuffer nextKey = this.input.getKey();
        this.currentRawKey.set(nextKey.getData(), nextKey.getPosition(), nextKey.getLength() - nextKey.getPosition());
        this.buffer.reset(this.currentRawKey.getBytes(), 0, this.currentRawKey.getLength());
        this.key = this.keyDeserializer.deserialize(this.key);
        DataInputBuffer nextVal = this.input.getValue();
        this.buffer.reset(nextVal.getData(), nextVal.getPosition(), nextVal.getLength() - nextVal.getPosition());
        this.value = this.valueDeserializer.deserialize(this.value);
        this.currentKeyLength = nextKey.getLength() - nextKey.getPosition();
        this.currentValueLength = nextVal.getLength() - nextVal.getPosition();
        this.hasMore = this.input.next();
        if (this.hasMore) {
            nextKey = this.input.getKey();
            this.nextKeyIsSame = this.comparator.compare(this.currentRawKey.getBytes(), 0, this.currentRawKey.getLength(), nextKey.getData(), nextKey.getPosition(), nextKey.getLength() - nextKey.getPosition()) == 0;
        } else {
            this.nextKeyIsSame = false;
        }
        this.inputValueCounter.increment(1L);
        return true;
    }

    @Override
    public KEYIN getCurrentKey() {
        return this.key;
    }

    @Override
    public VALUEIN getCurrentValue() {
        return this.value;
    }

    @Override
    public Iterable<VALUEIN> getValues() throws IOException, InterruptedException {
        return this.iterable;
    }

    protected class ValueIterable
    implements Iterable<VALUEIN> {
        private ValueIterator iterator;

        protected ValueIterable() {
            this.iterator = new ValueIterator();
        }

        @Override
        public Iterator<VALUEIN> iterator() {
            return this.iterator;
        }
    }

    protected class ValueIterator
    implements ReduceContext.ValueIterator<VALUEIN> {
        protected ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return ReduceContextImpl.this.firstValue || ReduceContextImpl.this.nextKeyIsSame;
        }

        @Override
        public VALUEIN next() {
            if (ReduceContextImpl.this.firstValue) {
                ReduceContextImpl.this.firstValue = false;
                return ReduceContextImpl.this.value;
            }
            if (!ReduceContextImpl.this.nextKeyIsSame) {
                throw new NoSuchElementException("iterate past last value");
            }
            try {
                ReduceContextImpl.this.nextKeyValue();
                return ReduceContextImpl.this.value;
            }
            catch (IOException ie) {
                throw new RuntimeException("next value iterator failed", ie);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("next value iterator interrupted", ie);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not implemented");
        }

        private void writeFirstKeyValueBytes(DataOutputStream out) throws IOException {
            assert (ReduceContextImpl.this.getCurrentKey() != null && ReduceContextImpl.this.getCurrentValue() != null);
            WritableUtils.writeVInt((DataOutput)out, (int)ReduceContextImpl.this.currentKeyLength);
            WritableUtils.writeVInt((DataOutput)out, (int)ReduceContextImpl.this.currentValueLength);
            Serializer keySerializer = ReduceContextImpl.this.serializationFactory.getSerializer(ReduceContextImpl.this.keyClass);
            keySerializer.open((OutputStream)out);
            keySerializer.serialize(ReduceContextImpl.this.getCurrentKey());
            Serializer valueSerializer = ReduceContextImpl.this.serializationFactory.getSerializer(ReduceContextImpl.this.valueClass);
            valueSerializer.open((OutputStream)out);
            valueSerializer.serialize(ReduceContextImpl.this.getCurrentValue());
        }
    }
}

