/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.tools;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.ZKFailoverController;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.proto.HAZKInfoProtos;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.HAUtil;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTrackerHAServiceTarget;
import org.apache.hadoop.mapred.MapReducePolicyProvider;
import org.apache.hadoop.mapred.tools.MRHAAdmin;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class MRZKFailoverController
extends ZKFailoverController {
    private static final Log LOG = LogFactory.getLog(MRZKFailoverController.class);
    private AccessControlList adminAcl;
    private final JobTrackerHAServiceTarget localJTTarget;

    protected HAServiceTarget dataToTarget(byte[] data) {
        HAZKInfoProtos.ActiveNodeInfo proto;
        try {
            proto = HAZKInfoProtos.ActiveNodeInfo.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Invalid data in ZK: " + StringUtils.byteToHexString((byte[])data));
        }
        JobTrackerHAServiceTarget ret = new JobTrackerHAServiceTarget(this.conf, proto.getNamenodeId());
        InetSocketAddress addressFromProtobuf = new InetSocketAddress(proto.getHostname(), proto.getPort());
        if (!addressFromProtobuf.equals(ret.getAddress())) {
            throw new RuntimeException("Mismatched address stored in ZK for " + (Object)((Object)ret) + ": Stored protobuf was " + addressFromProtobuf + ", address from our own " + "configuration for this JobTracker was " + ret.getAddress());
        }
        ret.setZkfcPort(proto.getZkfcPort());
        return ret;
    }

    protected byte[] targetToData(HAServiceTarget target) {
        InetSocketAddress addr = target.getAddress();
        return HAZKInfoProtos.ActiveNodeInfo.newBuilder().setHostname(addr.getHostName()).setPort(addr.getPort()).setZkfcPort(target.getZKFCAddress().getPort()).setNameserviceId(this.localJTTarget.getLogicalName()).setNamenodeId(this.localJTTarget.getJobTrackerId()).build().toByteArray();
    }

    protected InetSocketAddress getRpcAddressToBindTo() {
        int zkfcPort = MRZKFailoverController.getZkfcPort(this.conf);
        return new InetSocketAddress(this.localTarget.getAddress().getAddress(), zkfcPort);
    }

    protected PolicyProvider getPolicyProvider() {
        return new MapReducePolicyProvider();
    }

    public static int getZkfcPort(Configuration conf) {
        return conf.getInt("mapred.ha.zkfc.port", 8018);
    }

    public static MRZKFailoverController create(Configuration conf) {
        String logicalName;
        Configuration localJTConf = MRHAAdmin.addSecurityConfiguration(conf);
        if (!HAUtil.isHAEnabled(localJTConf, logicalName = HAUtil.getLogicalName(localJTConf))) {
            throw new HadoopIllegalArgumentException("HA is not enabled for this jobtracker.");
        }
        String jtId = HAUtil.getJobTrackerId(localJTConf);
        HAUtil.setGenericConf(localJTConf, logicalName, jtId, HAUtil.JOB_TRACKER_SPECIFIC_KEYS);
        HAUtil.setGenericConf(localJTConf, logicalName, jtId, ZKFC_CONF_KEYS);
        JobTrackerHAServiceTarget localTarget = new JobTrackerHAServiceTarget(localJTConf, jtId);
        return new MRZKFailoverController(localJTConf, localTarget);
    }

    private MRZKFailoverController(Configuration conf, JobTrackerHAServiceTarget localTarget) {
        super(conf, (HAServiceTarget)localTarget);
        this.localJTTarget = localTarget;
        this.adminAcl = new AccessControlList(conf.get("mapreduce.cluster.administrators", " "));
        LOG.info((Object)("Failover controller configured for JobTracker " + (Object)((Object)localTarget)));
    }

    protected void initRPC() throws IOException {
        super.initRPC();
        this.localJTTarget.setZkfcPort(this.rpcServer.getAddress().getPort());
    }

    public void loginAsFCUser() throws IOException {
        InetSocketAddress socAddr = NetUtils.createSocketAddr((String)this.conf.get("mapred.jobtracker.rpc-address"));
        SecurityUtil.login((Configuration)this.conf, (String)"mapreduce.jobtracker.keytab.file", (String)"mapreduce.jobtracker.kerberos.principal", (String)socAddr.getHostName());
    }

    protected String getScopeInsideParentNode() {
        return HAUtil.getLogicalName(this.conf);
    }

    public static void main(String[] args) throws Exception {
        if (DFSUtil.parseHelpArgument((String[])args, (String)"Usage: java zkfc [ -formatZK [-force] [-nonInteractive] ]", (PrintStream)System.out, (boolean)true)) {
            System.exit(0);
        }
        GenericOptionsParser parser = new GenericOptionsParser((Configuration)new JobConf(), args);
        MRZKFailoverController zkfc = MRZKFailoverController.create(parser.getConfiguration());
        System.exit(zkfc.run(parser.getRemainingArgs()));
    }

    protected void checkRpcAdminAccess() throws IOException, AccessControlException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation zkfcUgi = UserGroupInformation.getLoginUser();
        if (this.adminAcl.isUserAllowed(ugi) || ugi.getShortUserName().equals(zkfcUgi.getShortUserName())) {
            LOG.info((Object)("Allowed RPC access from " + ugi + " at " + Server.getRemoteAddress()));
            return;
        }
        String msg = "Disallowed RPC access from " + ugi + " at " + Server.getRemoteAddress() + ". Not listed in " + "mapreduce.cluster.administrators";
        LOG.warn((Object)msg);
        throw new AccessControlException(msg);
    }
}

