/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.filecache;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.filecache.TaskDistributedCacheManager;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.MRAsyncDiskService;
import org.apache.hadoop.util.RunJar;

public class TrackerDistributedCacheManager {
    private LinkedHashMap<String, CacheStatus> cachedArchives = new LinkedHashMap();
    private Map<JobID, TaskDistributedCacheManager> jobArchives = Collections.synchronizedMap(new HashMap());
    private final TaskController taskController;
    private static final FsPermission PUBLIC_CACHE_OBJECT_PERM = FsPermission.createImmutable((short)493);
    private static final long DEFAULT_CACHE_SIZE = 0x280000000L;
    private static final long DEFAULT_CACHE_SUBDIR_LIMIT = 10000L;
    private static final float DEFAULT_CACHE_KEEP_AROUND_PCT = 0.95f;
    private long allowedCacheSize;
    private long allowedCacheSubdirs;
    private long allowedCacheSizeCleanupGoal;
    private long allowedCacheSubdirsCleanupGoal;
    private static final Log LOG = LogFactory.getLog(TrackerDistributedCacheManager.class);
    private final LocalFileSystem localFs;
    private LocalDirAllocator lDirAllocator;
    private Configuration trackerConf;
    private static final Random random = new Random();
    protected BaseDirManager baseDirManager = new BaseDirManager();
    protected CleanupThread cleanupThread;
    private MRAsyncDiskService asyncDiskService;

    public TrackerDistributedCacheManager(Configuration conf, TaskController controller) throws IOException {
        this.localFs = FileSystem.getLocal((Configuration)conf);
        this.trackerConf = conf;
        this.lDirAllocator = new LocalDirAllocator("mapred.local.dir");
        this.allowedCacheSize = conf.getLong("local.cache.size", 0x280000000L);
        this.allowedCacheSubdirs = conf.getLong("mapreduce.tasktracker.cache.local.numberdirectories", 10000L);
        double cleanupPct = conf.getFloat("mapreduce.tasktracker.cache.local.keep.pct", 0.95f);
        this.allowedCacheSizeCleanupGoal = (long)((double)this.allowedCacheSize * cleanupPct);
        this.allowedCacheSubdirsCleanupGoal = (long)((double)this.allowedCacheSubdirs * cleanupPct);
        this.taskController = controller;
        this.cleanupThread = new CleanupThread(conf);
    }

    public TrackerDistributedCacheManager(Configuration conf, TaskController taskController, MRAsyncDiskService asyncDiskService) throws IOException {
        this(conf, taskController);
        this.asyncDiskService = asyncDiskService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Path getLocalCache(URI cache, Configuration conf, String subDir, FileStatus fileStatus, boolean isArchive, long confFileStamp, boolean isPublic, TaskDistributedCacheManager.CacheFile file) throws IOException {
        CacheStatus lcacheStatus;
        String user = TrackerDistributedCacheManager.getLocalizedCacheOwner(isPublic);
        String key = this.getKey(cache, conf, confFileStamp, user, isArchive);
        Path localizedPath = null;
        Path localPath = null;
        Object object = this.cachedArchives;
        synchronized (object) {
            lcacheStatus = this.cachedArchives.get(key);
            if (lcacheStatus == null) {
                String uniqueString = String.valueOf(random.nextLong()) + "_" + cache.hashCode() + "_" + confFileStamp % Integer.MAX_VALUE;
                String cachePath = new Path(subDir, new Path(uniqueString, this.makeRelative(cache, conf))).toString();
                localPath = this.lDirAllocator.getLocalPathForWrite(cachePath, fileStatus.getLen(), this.trackerConf, isPublic);
                lcacheStatus = new CacheStatus(new Path(localPath.toString().replace(cachePath, "")), localPath, new Path(subDir), uniqueString, isPublic ? null : user, key);
                this.cachedArchives.put(key, lcacheStatus);
            }
            file.setStatus(lcacheStatus);
            lcacheStatus.incRefCount();
        }
        try {
            object = lcacheStatus;
            synchronized (object) {
                if (!lcacheStatus.isInited()) {
                    if (isPublic) {
                        localizedPath = this.localizePublicCacheObject(conf, cache, confFileStamp, lcacheStatus, fileStatus, isArchive);
                    } else {
                        localizedPath = localPath;
                        if (!isArchive) {
                            lcacheStatus.size = fileStatus.getLen();
                            this.baseDirManager.addCacheInfoUpdate(lcacheStatus);
                        }
                    }
                    lcacheStatus.initComplete();
                } else {
                    localizedPath = this.checkCacheStatusValidity(conf, cache, confFileStamp, lcacheStatus, fileStatus, isArchive);
                }
            }
        }
        catch (IOException ie) {
            lcacheStatus.decRefCount();
            throw ie;
        }
        return localizedPath;
    }

    void releaseCache(CacheStatus status) throws IOException {
        status.decRefCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSize(CacheStatus status, long size) throws IOException {
        if (size != 0L) {
            CacheStatus cacheStatus = status;
            synchronized (cacheStatus) {
                status.size = size;
                this.baseDirManager.addCacheInfoUpdate(status);
            }
        }
    }

    int getReferenceCount(CacheStatus status) throws IOException {
        return status.getRefCount();
    }

    static String getLocalizedCacheOwner(boolean isPublic) throws IOException {
        String user = isPublic ? UserGroupInformation.getLoginUser().getShortUserName() : UserGroupInformation.getCurrentUser().getShortUserName();
        return user;
    }

    String makeRelative(URI cache, Configuration conf) throws IOException {
        URI defaultUri;
        String host = cache.getHost();
        if (host == null) {
            host = cache.getScheme();
        }
        if (host == null && (host = (defaultUri = FileSystem.get((Configuration)conf).getUri()).getHost()) == null) {
            host = defaultUri.getScheme();
        }
        String path = host + cache.getPath();
        path = path.replace(":/", "/");
        return path;
    }

    private Path checkCacheStatusValidity(Configuration conf, URI cache, long confFileStamp, CacheStatus cacheStatus, FileStatus fileStatus, boolean isArchive) throws IOException {
        FileSystem fs = FileSystem.get((URI)cache, (Configuration)conf);
        if (!this.ifExistsAndFresh(conf, fs, cache, confFileStamp, cacheStatus, fileStatus)) {
            throw new IOException("Stale cache file: " + cacheStatus.localizedLoadPath + " for cache-file: " + cache);
        }
        LOG.info((Object)String.format("Using existing cache of %s->%s", cache.toString(), cacheStatus.localizedLoadPath));
        return cacheStatus.localizedLoadPath;
    }

    static boolean isPublic(Configuration conf, URI uri, Map<URI, FileStatus> statCache) throws IOException {
        Path current;
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        if (!TrackerDistributedCacheManager.checkPermissionOfOther(fs, current = new Path(uri.getPath()), FsAction.READ, statCache)) {
            return false;
        }
        return TrackerDistributedCacheManager.ancestorsHaveExecutePermissions(fs, current.getParent(), statCache);
    }

    static boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path, Map<URI, FileStatus> statCache) throws IOException {
        for (Path current = path; current != null; current = current.getParent()) {
            if (TrackerDistributedCacheManager.checkPermissionOfOther(fs, current, FsAction.EXECUTE, statCache)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action, Map<URI, FileStatus> statCache) throws IOException {
        FileStatus status = TrackerDistributedCacheManager.getFileStatus(fs, path, statCache);
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        return otherAction.implies(action);
    }

    private static Path createRandomPath(Path base) throws IOException {
        return new Path(base.toString() + "-work-" + random.nextLong());
    }

    public static long downloadCacheObject(Configuration conf, URI source, Path destination, long desiredTimestamp, boolean isArchive, FsPermission permission) throws IOException {
        FileSystem sourceFs = FileSystem.get((URI)source, (Configuration)conf);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path sourcePath = new Path(source.getPath());
        long modifiedTime = sourceFs.getFileStatus(sourcePath).getModificationTime();
        if (modifiedTime != desiredTimestamp) {
            DateFormat df = DateFormat.getDateTimeInstance(3, 3);
            throw new IOException("The distributed cache object " + source + " changed during the job from " + df.format(new Date(desiredTimestamp)) + " to " + df.format(new Date(modifiedTime)));
        }
        Path parchive = null;
        parchive = isArchive ? new Path(destination, destination.getName()) : destination;
        if (localFs.exists(parchive)) {
            return 0L;
        }
        Path finalDir = parchive.getParent();
        Path workDir = TrackerDistributedCacheManager.createRandomPath(finalDir);
        LOG.info((Object)("Creating " + destination.getName() + " in " + workDir + " with " + permission));
        if (!localFs.mkdirs(workDir, permission)) {
            throw new IOException("Mkdirs failed to create directory " + workDir);
        }
        Path workFile = new Path(workDir, parchive.getName());
        sourceFs.copyToLocalFile(sourcePath, workFile);
        localFs.setPermission(workFile, permission);
        if (isArchive) {
            String tmpArchive = workFile.getName().toLowerCase();
            File srcFile = new File(workFile.toString());
            File destDir = new File(workDir.toString());
            LOG.info((Object)String.format("Extracting %s to %s", srcFile.toString(), destDir.toString()));
            if (tmpArchive.endsWith(".jar")) {
                RunJar.unJar((File)srcFile, (File)destDir);
            } else if (tmpArchive.endsWith(".zip")) {
                FileUtil.unZip((File)srcFile, (File)destDir);
            } else if (TrackerDistributedCacheManager.isTarFile(tmpArchive)) {
                FileUtil.unTar((File)srcFile, (File)destDir);
            } else {
                LOG.warn((Object)String.format("Cache file %s specified as archive, but not valid extension.", srcFile.toString()));
            }
            try {
                FileUtil.chmod((String)destDir.toString(), (String)"ugo+rx", (boolean)true);
            }
            catch (InterruptedException ie) {
                throw new IOException("Interrupted while chmodding", ie);
            }
        }
        if (!localFs.rename(workDir, finalDir)) {
            localFs.delete(workDir, true);
            if (!localFs.exists(finalDir)) {
                throw new IOException("Failed to promote distributed cache object " + workDir + " to " + finalDir);
            }
            return 0L;
        }
        LOG.info((Object)String.format("Cached %s as %s", source.toString(), destination.toString()));
        long cacheSize = FileUtil.getDU((File)new File(parchive.getParent().toString()));
        return cacheSize;
    }

    Path localizePublicCacheObject(Configuration conf, URI cache, long confFileStamp, CacheStatus cacheStatus, FileStatus fileStatus, boolean isArchive) throws IOException {
        long size;
        cacheStatus.size = size = TrackerDistributedCacheManager.downloadCacheObject(conf, cache, cacheStatus.localizedLoadPath, confFileStamp, isArchive, PUBLIC_CACHE_OBJECT_PERM);
        this.baseDirManager.addCacheInfoUpdate(cacheStatus);
        LOG.info((Object)String.format("Cached %s as %s", cache.toString(), cacheStatus.localizedLoadPath));
        return cacheStatus.localizedLoadPath;
    }

    private static boolean isTarFile(String filename) {
        return filename.endsWith(".tgz") || filename.endsWith(".tar.gz") || filename.endsWith(".tar");
    }

    private boolean ifExistsAndFresh(Configuration conf, FileSystem fs, URI cache, long confFileStamp, CacheStatus lcacheStatus, FileStatus fileStatus) throws IOException {
        long dfsFileStamp = fileStatus != null ? fileStatus.getModificationTime() : DistributedCache.getTimestamp(conf, cache);
        if (dfsFileStamp != confFileStamp) {
            LOG.fatal((Object)("File: " + cache + " has changed on HDFS since job started"));
            throw new IOException("File: " + cache + " has changed on HDFS since job started");
        }
        return true;
    }

    String getKey(URI cache, Configuration conf, long timeStamp, String user, boolean isArchive) throws IOException {
        return (isArchive ? "a" : "f") + "^" + this.makeRelative(cache, conf) + String.valueOf(timeStamp) + user;
    }

    public static void createAllSymlink(Configuration conf, File jobCacheDir, File workDir) throws IOException {
        if (jobCacheDir == null || !jobCacheDir.isDirectory() || workDir == null || !workDir.isDirectory()) {
            return;
        }
        boolean createSymlink = DistributedCache.getSymlink(conf);
        if (createSymlink) {
            File[] list = jobCacheDir.listFiles();
            for (int i = 0; i < list.length; ++i) {
                String target = list[i].getAbsolutePath();
                String link = new File(workDir, list[i].getName()).toString();
                LOG.info((Object)String.format("Creating symlink: %s <- %s", target, link));
                int ret = FileUtil.symLink((String)target, (String)link);
                if (ret == 0) continue;
                LOG.warn((Object)String.format("Failed to create symlink: %s <- %s", target, link));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeCache() {
        LinkedHashMap<String, CacheStatus> linkedHashMap = this.cachedArchives;
        synchronized (linkedHashMap) {
            for (Map.Entry<String, CacheStatus> f : this.cachedArchives.entrySet()) {
                try {
                    this.localFs.delete(f.getValue().localizedLoadPath, true);
                    this.localFs.delete(f.getValue().localizedLoadPath, true);
                }
                catch (IOException ie) {
                    LOG.debug((Object)("Error cleaning up cache (" + f.getValue().localizedLoadPath + ")"), (Throwable)ie);
                }
            }
            this.cachedArchives.clear();
        }
    }

    public TaskDistributedCacheManager newTaskDistributedCacheManager(JobID jobId, Configuration taskConf) throws IOException {
        TaskDistributedCacheManager result = new TaskDistributedCacheManager(this, taskConf);
        this.jobArchives.put(jobId, result);
        return result;
    }

    public void setArchiveSizes(JobID jobId, long[] sizes) throws IOException {
        TaskDistributedCacheManager mgr = this.jobArchives.get(jobId);
        if (mgr != null) {
            mgr.setSizes(sizes);
        }
    }

    public void removeTaskDistributedCacheManager(JobID jobId) {
        this.jobArchives.remove(jobId);
    }

    protected TaskDistributedCacheManager getTaskDistributedCacheManager(JobID jobId) {
        return this.jobArchives.get(jobId);
    }

    private static FileStatus getFileStatus(Configuration job, URI uri, Map<URI, FileStatus> statCache) throws IOException {
        FileStatus stat = statCache.get(uri);
        if (stat == null) {
            stat = DistributedCache.getFileStatus(job, uri);
            statCache.put(uri, stat);
        }
        return stat;
    }

    private static FileStatus getFileStatus(FileSystem fs, Path path, Map<URI, FileStatus> statCache) throws IOException {
        URI uri = path.toUri();
        FileStatus stat = statCache.get(uri);
        if (stat == null) {
            stat = fs.getFileStatus(path);
            statCache.put(uri, stat);
        }
        return stat;
    }

    public static void determineTimestampsAndCacheVisibilities(Configuration job) throws IOException {
        HashMap<URI, FileStatus> statCache = new HashMap<URI, FileStatus>();
        TrackerDistributedCacheManager.determineTimestamps(job, statCache);
        TrackerDistributedCacheManager.determineCacheVisibilities(job, statCache);
    }

    static void determineTimestamps(Configuration job, Map<URI, FileStatus> statCache) throws IOException {
        URI[] tfiles;
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        if (tarchives != null) {
            FileStatus status = TrackerDistributedCacheManager.getFileStatus(job, tarchives[0], statCache);
            StringBuffer archiveFileSizes = new StringBuffer(String.valueOf(status.getLen()));
            StringBuffer archiveTimestamps = new StringBuffer(String.valueOf(status.getModificationTime()));
            for (int i = 1; i < tarchives.length; ++i) {
                status = TrackerDistributedCacheManager.getFileStatus(job, tarchives[i], statCache);
                archiveFileSizes.append(",");
                archiveFileSizes.append(String.valueOf(status.getLen()));
                archiveTimestamps.append(",");
                archiveTimestamps.append(String.valueOf(status.getModificationTime()));
            }
            job.set("mapred.cache.archives.filesizes", archiveFileSizes.toString());
            DistributedCache.setArchiveTimestamps(job, archiveTimestamps.toString());
        }
        if ((tfiles = DistributedCache.getCacheFiles(job)) != null) {
            FileStatus status = TrackerDistributedCacheManager.getFileStatus(job, tfiles[0], statCache);
            StringBuffer fileSizes = new StringBuffer(String.valueOf(status.getLen()));
            StringBuffer fileTimestamps = new StringBuffer(String.valueOf(status.getModificationTime()));
            for (int i = 1; i < tfiles.length; ++i) {
                status = DistributedCache.getFileStatus(job, tfiles[i]);
                fileSizes.append(",");
                fileSizes.append(String.valueOf(status.getLen()));
                fileTimestamps.append(",");
                fileTimestamps.append(String.valueOf(status.getModificationTime()));
            }
            job.set("mapred.cache.files.filesizes", fileSizes.toString());
            DistributedCache.setFileTimestamps(job, fileTimestamps.toString());
        }
    }

    static void determineCacheVisibilities(Configuration job, Map<URI, FileStatus> statCache) throws IOException {
        URI[] tfiles;
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        if (tarchives != null) {
            StringBuffer archiveVisibilities = new StringBuffer(String.valueOf(TrackerDistributedCacheManager.isPublic(job, tarchives[0], statCache)));
            for (int i = 1; i < tarchives.length; ++i) {
                archiveVisibilities.append(",");
                archiveVisibilities.append(String.valueOf(TrackerDistributedCacheManager.isPublic(job, tarchives[i], statCache)));
            }
            TrackerDistributedCacheManager.setArchiveVisibilities(job, archiveVisibilities.toString());
        }
        if ((tfiles = DistributedCache.getCacheFiles(job)) != null) {
            StringBuffer fileVisibilities = new StringBuffer(String.valueOf(TrackerDistributedCacheManager.isPublic(job, tfiles[0], statCache)));
            for (int i = 1; i < tfiles.length; ++i) {
                fileVisibilities.append(",");
                fileVisibilities.append(String.valueOf(TrackerDistributedCacheManager.isPublic(job, tfiles[i], statCache)));
            }
            TrackerDistributedCacheManager.setFileVisibilities(job, fileVisibilities.toString());
        }
    }

    private static boolean[] parseBooleans(String[] strs) {
        if (null == strs) {
            return null;
        }
        boolean[] result = new boolean[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result[i] = Boolean.parseBoolean(strs[i]);
        }
        return result;
    }

    public static boolean[] getFileVisibilities(Configuration conf) {
        return TrackerDistributedCacheManager.parseBooleans(conf.getStrings("mapreduce.job.cache.files.visibilities"));
    }

    public static boolean[] getArchiveVisibilities(Configuration conf) {
        return TrackerDistributedCacheManager.parseBooleans(conf.getStrings("mapreduce.job.cache.archives.visibilities"));
    }

    static void setArchiveVisibilities(Configuration conf, String booleans) {
        conf.set("mapreduce.job.cache.archives.visibilities", booleans);
    }

    static void setFileVisibilities(Configuration conf, String booleans) {
        conf.set("mapreduce.job.cache.files.visibilities", booleans);
    }

    public static void getDelegationTokens(Configuration job, Credentials credentials) throws IOException {
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        URI[] tfiles = DistributedCache.getCacheFiles(job);
        int size = (tarchives != null ? tarchives.length : 0) + (tfiles != null ? tfiles.length : 0);
        Path[] ps = new Path[size];
        int i = 0;
        if (tarchives != null) {
            for (i = 0; i < tarchives.length; ++i) {
                ps[i] = new Path(tarchives[i].toString());
            }
        }
        if (tfiles != null) {
            for (int j = 0; j < tfiles.length; ++j) {
                ps[i + j] = new Path(tfiles[j].toString());
            }
        }
        TokenCache.obtainTokensForNamenodes(credentials, ps, job);
    }

    public static void validate(Configuration conf) throws InvalidJobConfException {
        String[] archiveStrings = conf.getStrings("mapred.cache.archives");
        String[] fileStrings = conf.getStrings("mapred.cache.files");
        Path thisSubject = null;
        if (archiveStrings != null && fileStrings != null) {
            HashSet<Path> archivesSet = new HashSet<Path>();
            for (String archiveString : archiveStrings) {
                archivesSet.add(TrackerDistributedCacheManager.coreLocation(archiveString, conf));
            }
            for (String fileString : fileStrings) {
                thisSubject = TrackerDistributedCacheManager.coreLocation(fileString, conf);
                if (!archivesSet.contains(thisSubject)) continue;
                throw new InvalidJobConfException("The core URI, \"" + thisSubject + "\" is listed both in " + "mapred.cache.files" + " and in " + "mapred.cache.archives" + " .");
            }
        }
    }

    private static Path coreLocation(String uriString, Configuration conf) throws InvalidJobConfException {
        if (DistributedCache.getSymlink(conf)) {
            try {
                URI uri = new URI(uriString);
                uriString = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new InvalidJobConfException("Badly formatted URI: " + uriString, e);
            }
        }
        Path path = new Path(uriString);
        try {
            path = path.makeQualified(path.getFileSystem(conf));
        }
        catch (IOException e) {
            throw new InvalidJobConfException("Invalid file system in distributed cache for the URI: " + uriString, e);
        }
        return path;
    }

    public void startCleanupThread() {
        this.cleanupThread.start();
    }

    public void stopCleanupThread() {
        this.cleanupThread.stopRunning();
        this.cleanupThread.interrupt();
    }

    protected class BaseDirManager {
        private TreeMap<Path, CacheDir> properties = new TreeMap();

        protected BaseDirManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkAndCleanup() throws IOException {
            LinkedList<CacheStatus> toBeDeletedCache = new LinkedList<CacheStatus>();
            HashMap<Path, CacheDir> toBeCleanedBaseDir = new HashMap<Path, CacheDir>();
            AbstractMap abstractMap = this.properties;
            synchronized (abstractMap) {
                LOG.debug((Object)"checkAndCleanup: Allowed Cache Size test");
                for (Map.Entry<Path, CacheDir> baseDir : this.properties.entrySet()) {
                    CacheDir baseDirCounts = baseDir.getValue();
                    LOG.debug((Object)(baseDir.getKey() + ": allowedCacheSize=" + TrackerDistributedCacheManager.this.allowedCacheSize + ",baseDirCounts.size=" + baseDirCounts.size + ",allowedCacheSubdirs=" + TrackerDistributedCacheManager.this.allowedCacheSubdirs + ",baseDirCounts.subdirs=" + baseDirCounts.subdirs));
                    if (TrackerDistributedCacheManager.this.allowedCacheSize >= baseDirCounts.size && TrackerDistributedCacheManager.this.allowedCacheSubdirs >= baseDirCounts.subdirs) continue;
                    CacheDir tcc = new CacheDir();
                    tcc.size = baseDirCounts.size - TrackerDistributedCacheManager.this.allowedCacheSizeCleanupGoal;
                    tcc.subdirs = baseDirCounts.subdirs - TrackerDistributedCacheManager.this.allowedCacheSubdirsCleanupGoal;
                    toBeCleanedBaseDir.put(baseDir.getKey(), tcc);
                }
            }
            abstractMap = TrackerDistributedCacheManager.this.cachedArchives;
            synchronized (abstractMap) {
                LOG.debug((Object)"checkAndCleanup: Global Cache Size Check");
                Iterator it = TrackerDistributedCacheManager.this.cachedArchives.entrySet().iterator();
                while (it.hasNext()) {
                    boolean gotLock;
                    Map.Entry entry = it.next();
                    String cacheId = (String)entry.getKey();
                    CacheStatus cacheStatus = (CacheStatus)TrackerDistributedCacheManager.this.cachedArchives.get(cacheId);
                    CacheDir leftToClean = (CacheDir)toBeCleanedBaseDir.get(cacheStatus.getBaseDir());
                    if (leftToClean == null || leftToClean.size <= 0L && leftToClean.subdirs <= 0L || !(gotLock = cacheStatus.lock.tryLock())) continue;
                    try {
                        boolean isUsed = cacheStatus.isUsed();
                        long cacheSize = cacheStatus.size;
                        LOG.debug((Object)(cacheStatus.getLocalizedUniqueDir() + ": isUsed=" + isUsed + " size=" + cacheSize + " leftToClean.size=" + leftToClean.size));
                        if (isUsed) continue;
                        leftToClean.size -= cacheSize;
                        --leftToClean.subdirs;
                        toBeDeletedCache.add(cacheStatus);
                        it.remove();
                    }
                    finally {
                        cacheStatus.lock.unlock();
                    }
                }
            }
            for (CacheStatus cacheStatus : toBeDeletedCache) {
                cacheStatus.lock.lock();
                try {
                    Path localizedDir = cacheStatus.getLocalizedUniqueDir();
                    if (cacheStatus.user == null) {
                        LOG.info((Object)("Deleted path " + localizedDir));
                        try {
                            TrackerDistributedCacheManager.this.localFs.delete(localizedDir, true);
                        }
                        catch (IOException e) {
                            LOG.warn((Object)("Could not delete distributed cache empty directory " + localizedDir), (Throwable)e);
                        }
                    } else {
                        LOG.info((Object)("Deleted path " + localizedDir + " as " + cacheStatus.user));
                        String base = cacheStatus.getBaseDir().toString();
                        String userDir = TaskTracker.getUserDir(cacheStatus.user);
                        int skip = base.length() + 1 + userDir.length() + 1;
                        String relative = localizedDir.toString().substring(skip);
                        TrackerDistributedCacheManager.this.taskController.deleteAsUser(cacheStatus.user, relative);
                    }
                    this.deleteCacheInfoUpdate(cacheStatus);
                }
                finally {
                    cacheStatus.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteCacheInfoUpdate(CacheStatus cacheStatus) {
            if (!cacheStatus.inited) {
                return;
            }
            TreeMap<Path, CacheDir> treeMap = TrackerDistributedCacheManager.this.baseDirManager.properties;
            synchronized (treeMap) {
                CacheDir cacheDir = this.properties.get(cacheStatus.getBaseDir());
                if (cacheDir != null) {
                    cacheDir.size -= cacheStatus.size;
                    --cacheDir.subdirs;
                } else {
                    LOG.warn((Object)("Cannot find size and number of subdirectories of baseDir: " + cacheStatus.getBaseDir()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCacheInfoUpdate(CacheStatus cacheStatus) {
            long cacheSize = cacheStatus.size;
            TreeMap<Path, CacheDir> treeMap = TrackerDistributedCacheManager.this.baseDirManager.properties;
            synchronized (treeMap) {
                CacheDir cacheDir = this.properties.get(cacheStatus.getBaseDir());
                if (cacheDir != null) {
                    cacheDir.size += cacheSize;
                    ++cacheDir.subdirs;
                } else {
                    cacheDir = new CacheDir();
                    cacheDir.size = cacheSize;
                    cacheDir.subdirs = 1L;
                    this.properties.put(cacheStatus.getBaseDir(), cacheDir);
                }
            }
        }
    }

    private static class CacheDir {
        long size;
        long subdirs;

        private CacheDir() {
        }
    }

    protected class CleanupThread
    extends Thread {
        private long cleanUpCheckPeriod = 60000L;
        private volatile boolean running = true;

        public CleanupThread(Configuration conf) {
            this.cleanUpCheckPeriod = conf.getLong("mapreduce.tasktracker.distributedcache.checkperiod", this.cleanUpCheckPeriod);
        }

        public void stopRunning() {
            this.running = false;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Thread.sleep(this.cleanUpCheckPeriod);
                    TrackerDistributedCacheManager.this.baseDirManager.checkAndCleanup();
                }
                catch (IOException e) {
                    LOG.error((Object)"Exception in DistributedCache CleanupThread.", (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"Cleanup...", (Throwable)e);
                    this.running = false;
                }
                catch (Throwable t) {
                    this.exitTaskTracker(t);
                }
            }
        }

        protected void exitTaskTracker(Throwable t) {
            LOG.fatal((Object)"Distributed Cache cleanup thread received runtime exception. Exiting the TaskTracker", t);
            Runtime.getRuntime().exit(-1);
        }
    }

    class CacheStatus {
        private AtomicInteger refcount;
        long size;
        boolean inited = false;
        private final ReentrantLock lock = new ReentrantLock();
        Path subDir;
        String uniqueString;
        Path localizedLoadPath;
        Path localizedBaseDir;
        final String user;
        private final String key;

        public CacheStatus(Path baseDir, Path localLoadPath, Path subDir, String uniqueString, String user, String key) {
            this.localizedLoadPath = localLoadPath;
            this.refcount = new AtomicInteger();
            this.localizedBaseDir = baseDir;
            this.size = 0L;
            this.subDir = subDir;
            this.uniqueString = uniqueString;
            this.user = user;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incRefCount() {
            this.lock.lock();
            try {
                this.refcount.incrementAndGet();
                LOG.debug((Object)(this.localizedLoadPath + ": refcount=" + this.refcount.get()));
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decRefCount() {
            LinkedHashMap linkedHashMap = TrackerDistributedCacheManager.this.cachedArchives;
            synchronized (linkedHashMap) {
                this.lock.lock();
                try {
                    this.refcount.decrementAndGet();
                    LOG.debug((Object)(this.localizedLoadPath + ": refcount=" + this.refcount.get()));
                    if (this.refcount.get() <= 0) {
                        String key = this.key;
                        TrackerDistributedCacheManager.this.cachedArchives.remove(key);
                        TrackerDistributedCacheManager.this.cachedArchives.put(key, this);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        public int getRefCount() {
            return this.refcount.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isUsed() {
            this.lock.lock();
            try {
                LOG.debug((Object)(this.localizedLoadPath + ": refcount=" + this.refcount.get()));
                boolean bl = this.refcount.get() > 0;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        Path getBaseDir() {
            return this.localizedBaseDir;
        }

        void initComplete() {
            this.inited = true;
        }

        boolean isInited() {
            return this.inited;
        }

        Path getLocalizedUniqueDir() {
            return new Path(this.localizedBaseDir, new Path(this.subDir, this.uniqueString));
        }
    }
}

