/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class TransportInfo
implements Streamable,
Serializable,
ToXContent {
    private BoundTransportAddress address;

    TransportInfo() {
    }

    public TransportInfo(BoundTransportAddress address) {
        this.address = address;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("transport");
        builder.field("bound_address", this.address.boundAddress().toString());
        builder.field("publish_address", this.address.publishAddress().toString());
        builder.endObject();
        return builder;
    }

    public static TransportInfo readTransportInfo(StreamInput in) throws IOException {
        TransportInfo info = new TransportInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.address = BoundTransportAddress.readBoundTransportAddress(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.address.writeTo(out);
    }

    public BoundTransportAddress address() {
        return this.address;
    }

    public BoundTransportAddress getAddress() {
        return this.address();
    }
}

