/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.explain;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.SearchHitPhase;
import org.elasticsearch.search.fetch.explain.ExplainParseElement;
import org.elasticsearch.search.internal.SearchContext;

public class ExplainSearchHitPhase
implements SearchHitPhase {
    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of("explain", new ExplainParseElement());
    }

    @Override
    public boolean executionNeeded(SearchContext context) {
        return context.explain();
    }

    @Override
    public void execute(SearchContext context, SearchHitPhase.HitContext hitContext) throws ElasticSearchException {
        try {
            hitContext.hit().explanation(context.searcher().explain(context.query(), hitContext.hit().docId()));
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to explain doc [" + hitContext.hit().type() + "#" + hitContext.hit().id() + "]", (Throwable)e);
        }
    }
}

