/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.internal.SearchContext;

public class FieldsParseElement
implements SearchParseElement {
    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            boolean added = false;
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                String name = parser.text();
                if (name.contains("_source.") || name.contains("doc[")) {
                    SearchScript searchScript = context.scriptService().search(context.lookup(), "mvel", name, null);
                    context.scriptFields().add(new ScriptFieldsContext.ScriptField(name, searchScript, true));
                    continue;
                }
                if ("*".equals(name)) {
                    added = true;
                    context.fieldNames().add("*");
                    continue;
                }
                FieldMapper fieldMapper = context.mapperService().smartNameFieldMapper(name);
                if (fieldMapper == null) continue;
                if (fieldMapper.stored()) {
                    added = true;
                    context.fieldNames().add(name);
                    continue;
                }
                SearchScript searchScript = context.scriptService().search(context.lookup(), "mvel", "_source." + fieldMapper.names().fullName(), null);
                context.scriptFields().add(new ScriptFieldsContext.ScriptField(name, searchScript, true));
            }
            if (!added) {
                context.emptyFieldNames();
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            String name = parser.text();
            if (name.contains("_source.") || name.contains("doc[")) {
                SearchScript searchScript = context.scriptService().search(context.lookup(), "mvel", name, null);
                context.scriptFields().add(new ScriptFieldsContext.ScriptField(name, searchScript, true));
            } else if ("*".equals(name)) {
                context.fieldNames().add("*");
            } else {
                FieldMapper fieldMapper = context.mapperService().smartNameFieldMapper(name);
                if (fieldMapper != null) {
                    if (fieldMapper.stored()) {
                        context.fieldNames().add(name);
                    } else {
                        SearchScript searchScript = context.scriptService().search(context.lookup(), "mvel", "_source." + fieldMapper.names().fullName(), null);
                        context.scriptFields().add(new ScriptFieldsContext.ScriptField(name, searchScript, true));
                    }
                } else {
                    context.emptyFieldNames();
                }
            }
        }
    }
}

