/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ShardFieldDocSortedHitQueue;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Ordering;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.ExtTIntArrayList;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.controller.ScoreDocQueue;
import org.elasticsearch.search.controller.ShardDoc;
import org.elasticsearch.search.controller.ShardFieldDoc;
import org.elasticsearch.search.controller.ShardScoreDoc;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetProcessors;
import org.elasticsearch.search.facet.InternalFacets;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResultProvider;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;

public class SearchPhaseController
extends AbstractComponent {
    public static Ordering<QuerySearchResultProvider> QUERY_RESULT_ORDERING = new Ordering<QuerySearchResultProvider>(){

        @Override
        public int compare(@Nullable QuerySearchResultProvider o1, @Nullable QuerySearchResultProvider o2) {
            int i = o1.shardTarget().index().compareTo(o2.shardTarget().index());
            if (i == 0) {
                i = o1.shardTarget().shardId() - o2.shardTarget().shardId();
            }
            return i;
        }
    };
    private static final ShardDoc[] EMPTY = new ShardDoc[0];
    private final FacetProcessors facetProcessors;
    private final boolean optimizeSingleShard;

    @Inject
    public SearchPhaseController(Settings settings, FacetProcessors facetProcessors) {
        super(settings);
        this.facetProcessors = facetProcessors;
        this.optimizeSingleShard = this.componentSettings.getAsBoolean("optimize_single_shard", true);
    }

    public boolean optimizeSingleShard() {
        return this.optimizeSingleShard;
    }

    public AggregatedDfs aggregateDfs(Iterable<DfsSearchResult> results) {
        TObjectIntHashMap<Term> dfMap = new TObjectIntHashMap<Term>(10, 0.5f, -1);
        long aggMaxDoc = 0L;
        for (DfsSearchResult result : results) {
            for (int i = 0; i < result.freqs().length; ++i) {
                dfMap.adjustOrPutValue(result.terms()[i], result.freqs()[i], result.freqs()[i]);
            }
            aggMaxDoc += (long)result.maxDoc();
        }
        return new AggregatedDfs(dfMap, aggMaxDoc);
    }

    /*
     * WARNING - void declaration
     */
    public ShardDoc[] sortDocs(Collection<? extends QuerySearchResultProvider> results1) {
        void var9_32;
        PriorityQueue queue;
        int n;
        if (results1.isEmpty()) {
            return EMPTY;
        }
        if (this.optimizeSingleShard) {
            boolean canOptimize = false;
            QuerySearchResult result = null;
            if (results1.size() == 1) {
                canOptimize = true;
                result = results1.iterator().next().queryResult();
            } else {
                for (QuerySearchResultProvider querySearchResultProvider : results1) {
                    if (querySearchResultProvider.queryResult().topDocs().scoreDocs.length <= 0) continue;
                    if (result != null) {
                        canOptimize = false;
                        break;
                    }
                    canOptimize = true;
                    result = querySearchResultProvider.queryResult();
                }
            }
            if (canOptimize) {
                int n2;
                ScoreDoc[] scoreDocs = result.topDocs().scoreDocs;
                if (scoreDocs.length < result.from()) {
                    return EMPTY;
                }
                int n3 = result.size();
                if (scoreDocs.length - result.from() < n3) {
                    n2 = scoreDocs.length - result.from();
                }
                if (result.topDocs() instanceof TopFieldDocs) {
                    ShardDoc[] docs = new ShardDoc[n2];
                    for (int i = 0; i < n2; ++i) {
                        ScoreDoc scoreDoc = scoreDocs[result.from() + i];
                        docs[i] = new ShardFieldDoc(result.shardTarget(), scoreDoc.doc, scoreDoc.score, ((FieldDoc)scoreDoc).fields);
                    }
                    return docs;
                }
                ShardDoc[] docs = new ShardDoc[n2];
                for (int i = 0; i < n2; ++i) {
                    ScoreDoc scoreDoc = scoreDocs[result.from() + i];
                    docs[i] = new ShardScoreDoc(result.shardTarget(), scoreDoc.doc, scoreDoc.score);
                }
                return docs;
            }
        }
        List<? extends QuerySearchResultProvider> results = QUERY_RESULT_ORDERING.sortedCopy(results1);
        QuerySearchResultProvider queryResultProvider = results.get(0);
        int totalNumDocs = 0;
        int n4 = queryResultProvider.queryResult().from() + queryResultProvider.queryResult().size();
        if (queryResultProvider.includeFetch()) {
            n = n4 * results.size();
        }
        if (queryResultProvider.queryResult().topDocs() instanceof TopFieldDocs) {
            void var8_22;
            TopFieldDocs fieldDocs = (TopFieldDocs)queryResultProvider.queryResult().topDocs();
            boolean bl = false;
            while (var8_22 < fieldDocs.fields.length) {
                boolean bl2 = true;
                boolean resolvedField = false;
                for (QuerySearchResultProvider querySearchResultProvider : results) {
                    for (ScoreDoc doc : querySearchResultProvider.queryResult().topDocs().scoreDocs) {
                        FieldDoc fDoc = (FieldDoc)doc;
                        if (fDoc.fields[var8_22] == null) continue;
                        bl2 = false;
                        if (fDoc.fields[var8_22] instanceof String) {
                            fieldDocs.fields[var8_22] = new SortField(fieldDocs.fields[var8_22].getField(), 3, fieldDocs.fields[var8_22].getReverse());
                        }
                        resolvedField = true;
                        break;
                    }
                    if (!resolvedField) continue;
                    break;
                }
                if (!resolvedField && bl2 && fieldDocs.fields[var8_22].getField() != null) {
                    fieldDocs.fields[var8_22] = new SortField(fieldDocs.fields[var8_22].getField(), 3, fieldDocs.fields[var8_22].getReverse());
                }
                ++var8_22;
            }
            queue = new ShardFieldDocSortedHitQueue(fieldDocs.fields, n);
            block6: for (QuerySearchResultProvider querySearchResultProvider : results) {
                QuerySearchResult result = querySearchResultProvider.queryResult();
                ScoreDoc[] scoreDocs = result.topDocs().scoreDocs;
                totalNumDocs += scoreDocs.length;
                for (ScoreDoc doc : scoreDocs) {
                    ShardFieldDoc nodeFieldDoc = new ShardFieldDoc(result.shardTarget(), doc.doc, doc.score, ((FieldDoc)doc).fields);
                    if (queue.insertWithOverflow((Object)nodeFieldDoc) == nodeFieldDoc) continue block6;
                }
            }
        } else {
            queue = new ScoreDocQueue(n);
            block8: for (QuerySearchResultProvider querySearchResultProvider : results) {
                QuerySearchResult querySearchResult = querySearchResultProvider.queryResult();
                ScoreDoc[] scoreDocs = querySearchResult.topDocs().scoreDocs;
                totalNumDocs += scoreDocs.length;
                for (ScoreDoc doc : scoreDocs) {
                    ShardScoreDoc nodeScoreDoc = new ShardScoreDoc(querySearchResult.shardTarget(), doc.doc, doc.score);
                    if (queue.insertWithOverflow((Object)nodeScoreDoc) == nodeScoreDoc) continue block8;
                }
            }
        }
        int resultDocsSize = queryResultProvider.queryResult().size();
        if (queryResultProvider.includeFetch()) {
            resultDocsSize *= results.size();
        }
        if (totalNumDocs < n) {
            resultDocsSize = totalNumDocs - queryResultProvider.queryResult().from();
        }
        if (resultDocsSize <= 0) {
            return EMPTY;
        }
        ShardDoc[] shardDocArray = new ShardDoc[resultDocsSize];
        int n5 = resultDocsSize - 1;
        while (var9_32 >= 0) {
            shardDocArray[var9_32] = (ShardDoc)queue.pop();
            --var9_32;
        }
        return shardDocArray;
    }

    public Map<SearchShardTarget, ExtTIntArrayList> docIdsToLoad(ShardDoc[] shardDocs) {
        HashMap<SearchShardTarget, ExtTIntArrayList> result = Maps.newHashMap();
        for (ShardDoc shardDoc : shardDocs) {
            ExtTIntArrayList list = (ExtTIntArrayList)result.get(shardDoc.shardTarget());
            if (list == null) {
                list = new ExtTIntArrayList();
                result.put(shardDoc.shardTarget(), list);
            }
            list.add(shardDoc.docId());
        }
        return result;
    }

    public InternalSearchResponse merge(ShardDoc[] sortedDocs, Map<SearchShardTarget, ? extends QuerySearchResultProvider> queryResults, Map<SearchShardTarget, ? extends FetchSearchResultProvider> fetchResults) {
        QuerySearchResult queryResult;
        QuerySearchResult querySearchResult;
        boolean sorted = false;
        int sortScoreIndex = -1;
        try {
            querySearchResult = Iterables.get(queryResults.values(), 0).queryResult();
        }
        catch (IndexOutOfBoundsException e) {
            return InternalSearchResponse.EMPTY;
        }
        if (querySearchResult.topDocs() instanceof TopFieldDocs) {
            sorted = true;
            TopFieldDocs fieldDocs = (TopFieldDocs)querySearchResult.queryResult().topDocs();
            for (int i = 0; i < fieldDocs.fields.length; ++i) {
                if (fieldDocs.fields[i].getType() != 0) continue;
                sortScoreIndex = i;
            }
        }
        InternalFacets facets = null;
        if (!queryResults.isEmpty() && (queryResult = queryResults.values().iterator().next().queryResult()).facets() != null && queryResult.facets().facets() != null && !queryResult.facets().facets().isEmpty()) {
            ArrayList<Facet> aggregatedFacets = Lists.newArrayList();
            ArrayList<Facet> namedFacets = Lists.newArrayList();
            for (Facet facet : queryResult.facets()) {
                namedFacets.clear();
                for (QuerySearchResultProvider querySearchResultProvider : queryResults.values()) {
                    for (Facet facet1 : querySearchResultProvider.queryResult().facets()) {
                        if (!facet.name().equals(facet1.name())) continue;
                        namedFacets.add(facet1);
                    }
                }
                Facet facet2 = this.facetProcessors.processor(facet.type()).reduce(facet.name(), namedFacets);
                aggregatedFacets.add(facet2);
            }
            facets = new InternalFacets(aggregatedFacets);
        }
        long totalHits = 0L;
        float maxScore = Float.NEGATIVE_INFINITY;
        boolean timedOut = false;
        for (QuerySearchResultProvider querySearchResultProvider : queryResults.values()) {
            if (querySearchResultProvider.queryResult().searchTimedOut()) {
                timedOut = true;
            }
            totalHits += (long)querySearchResultProvider.queryResult().topDocs().totalHits;
            if (Float.isNaN(querySearchResultProvider.queryResult().topDocs().getMaxScore())) continue;
            maxScore = Math.max(maxScore, querySearchResultProvider.queryResult().topDocs().getMaxScore());
        }
        if (Float.isInfinite(maxScore)) {
            maxScore = Float.NaN;
        }
        for (FetchSearchResultProvider fetchSearchResultProvider : fetchResults.values()) {
            fetchSearchResultProvider.fetchResult().initCounter();
        }
        ArrayList<InternalSearchHit> hits = new ArrayList<InternalSearchHit>();
        if (!fetchResults.isEmpty()) {
            for (ShardDoc shardDoc : sortedDocs) {
                FetchSearchResult fetchResult;
                int index;
                FetchSearchResultProvider fetchResultProvider = fetchResults.get(shardDoc.shardTarget());
                if (fetchResultProvider == null || (index = (fetchResult = fetchResultProvider.fetchResult()).counterGetAndIncrement()) >= fetchResult.hits().internalHits().length) continue;
                InternalSearchHit searchHit = fetchResult.hits().internalHits()[index];
                searchHit.score(shardDoc.score());
                searchHit.shard(fetchResult.shardTarget());
                if (sorted) {
                    FieldDoc fieldDoc = (FieldDoc)shardDoc;
                    searchHit.sortValues(fieldDoc.fields);
                    if (sortScoreIndex != -1) {
                        searchHit.score(((Number)((Object)fieldDoc.fields[sortScoreIndex])).floatValue());
                    }
                }
                hits.add(searchHit);
            }
        }
        InternalSearchHits internalSearchHits = new InternalSearchHits(hits.toArray(new InternalSearchHit[hits.size()]), totalHits, maxScore);
        return new InternalSearchResponse(internalSearchHits, facets, timedOut);
    }
}

