/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import org.elasticsearch.search.SearchException;
import org.elasticsearch.search.internal.SearchContext;

public class SearchContextException
extends SearchException {
    public SearchContextException(SearchContext context, String msg) {
        super(context.shardTarget(), SearchContextException.buildMessage(context, msg));
    }

    public SearchContextException(SearchContext context, String msg, Throwable t) {
        super(context.shardTarget(), SearchContextException.buildMessage(context, msg), t);
    }

    private static String buildMessage(SearchContext context, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(context.shardTarget().index()).append("][").append(context.shardTarget().shardId()).append("]: ");
        if (context.parsedQuery() != null) {
            sb.append("query[").append(context.parsedQuery().query()).append("],");
        }
        sb.append("from[").append(context.from()).append("],size[").append(context.size()).append("]");
        if (context.sort() != null) {
            sb.append(",sort[").append(context.sort()).append("]");
        }
        return sb.append(": ").append(msg).toString();
    }
}

