/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilderException;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;
import org.elasticsearch.index.query.xcontent.XContentSpanQueryBuilder;

public class SpanNotQueryBuilder
extends BaseQueryBuilder
implements XContentSpanQueryBuilder {
    private XContentSpanQueryBuilder include;
    private XContentSpanQueryBuilder exclude;
    private float boost = -1.0f;

    public SpanNotQueryBuilder include(XContentSpanQueryBuilder include) {
        this.include = include;
        return this;
    }

    public SpanNotQueryBuilder exclude(XContentSpanQueryBuilder exclude) {
        this.exclude = exclude;
        return this;
    }

    public SpanNotQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.include == null) {
            throw new QueryBuilderException("Must specify include when using spanNot query");
        }
        if (this.exclude == null) {
            throw new QueryBuilderException("Must specify exclude when using spanNot query");
        }
        builder.startObject("span_not");
        builder.field("include");
        this.include.toXContent(builder, params);
        builder.field("exclude");
        this.exclude.toXContent(builder, params);
        if (this.boost == -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

