/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;

public class FieldQueryBuilder
extends BaseQueryBuilder {
    private final String name;
    private final Object query;
    private Operator defaultOperator;
    private String analyzer;
    private Boolean autoGeneratePhraseQueries;
    private Boolean allowLeadingWildcard;
    private Boolean lowercaseExpandedTerms;
    private Boolean enablePositionIncrements;
    private Boolean analyzeWildcard;
    private float fuzzyMinSim = -1.0f;
    private float boost = -1.0f;
    private int fuzzyPrefixLength = -1;
    private int phraseSlop = -1;
    private boolean extraSet = false;

    public FieldQueryBuilder(String name, String query) {
        this(name, (Object)query);
    }

    public FieldQueryBuilder(String name, int query) {
        this(name, (Object)query);
    }

    public FieldQueryBuilder(String name, long query) {
        this(name, (Object)query);
    }

    public FieldQueryBuilder(String name, float query) {
        this(name, Float.valueOf(query));
    }

    public FieldQueryBuilder(String name, double query) {
        this(name, (Object)query);
    }

    public FieldQueryBuilder(String name, boolean query) {
        this(name, (Object)query);
    }

    public FieldQueryBuilder(String name, Object query) {
        this.name = name;
        this.query = query;
    }

    public FieldQueryBuilder boost(float boost) {
        this.boost = boost;
        this.extraSet = true;
        return this;
    }

    public FieldQueryBuilder defaultOperator(Operator defaultOperator) {
        this.defaultOperator = defaultOperator;
        this.extraSet = true;
        return this;
    }

    public FieldQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        this.extraSet = true;
        return this;
    }

    public void autoGeneratePhraseQueries(boolean autoGeneratePhraseQueries) {
        this.autoGeneratePhraseQueries = autoGeneratePhraseQueries;
    }

    public FieldQueryBuilder allowLeadingWildcard(boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
        this.extraSet = true;
        return this;
    }

    public FieldQueryBuilder lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        this.extraSet = true;
        return this;
    }

    public FieldQueryBuilder enablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
        this.extraSet = true;
        return this;
    }

    public FieldQueryBuilder fuzzyMinSim(float fuzzyMinSim) {
        this.fuzzyMinSim = fuzzyMinSim;
        this.extraSet = true;
        return this;
    }

    public FieldQueryBuilder fuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
        this.extraSet = true;
        return this;
    }

    public FieldQueryBuilder phraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
        this.extraSet = true;
        return this;
    }

    public FieldQueryBuilder analyzeWildcard(boolean analyzeWildcard) {
        this.analyzeWildcard = analyzeWildcard;
        this.extraSet = true;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("field");
        if (!this.extraSet) {
            builder.field(this.name, this.query);
        } else {
            builder.startObject(this.name);
            builder.field("query", this.query);
            if (this.defaultOperator != null) {
                builder.field("default_operator", this.defaultOperator.name().toLowerCase());
            }
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.autoGeneratePhraseQueries != null) {
                builder.field("auto_generate_phrase_queries", (Object)this.autoGeneratePhraseQueries);
            }
            if (this.allowLeadingWildcard != null) {
                builder.field("allow_leading_wildcard", (Object)this.allowLeadingWildcard);
            }
            if (this.lowercaseExpandedTerms != null) {
                builder.field("lowercase_expanded_terms", (Object)this.lowercaseExpandedTerms);
            }
            if (this.enablePositionIncrements != null) {
                builder.field("enable_position_increments", (Object)this.enablePositionIncrements);
            }
            if (this.fuzzyMinSim != -1.0f) {
                builder.field("fuzzy_min_sim", this.fuzzyMinSim);
            }
            if (this.boost != -1.0f) {
                builder.field("boost", this.boost);
            }
            if (this.fuzzyPrefixLength != -1) {
                builder.field("fuzzy_prefix_length", this.fuzzyPrefixLength);
            }
            if (this.phraseSlop != -1) {
                builder.field("phrase_slop", this.phraseSlop);
            }
            if (this.analyzeWildcard != null) {
                builder.field("analyze_wildcard", (Object)this.analyzeWildcard);
            }
            builder.endObject();
        }
        builder.endObject();
    }

    public static enum Operator {
        OR,
        AND;

    }
}

